/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public class UsesMethod<P>
extends JavaIsoVisitor<P> {
    private final String methodPattern;
    private final MethodMatcher methodMatcher;

    public UsesMethod(String methodPattern) {
        this(new MethodMatcher(methodPattern), methodPattern);
    }

    public UsesMethod(String methodPattern, boolean matchOverrides) {
        this(new MethodMatcher(methodPattern, matchOverrides), methodPattern);
    }

    public UsesMethod(String methodPattern, @Nullable Boolean matchOverrides) {
        this(new MethodMatcher(methodPattern, Boolean.TRUE.equals(matchOverrides)), methodPattern);
    }

    public UsesMethod(MethodMatcher methodMatcher) {
        this(methodMatcher, methodMatcher.toString());
    }

    private UsesMethod(MethodMatcher methodMatcher, String methodPattern) {
        this.methodMatcher = methodMatcher;
        this.methodPattern = methodPattern;
    }

    public J preVisit(@NonNull J tree, P p) {
        this.stopAfterPreVisit();
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)tree;
            for (JavaType.Method type : cu.getTypesInUse().getUsedMethods()) {
                if (!this.methodMatcher.matches(type)) continue;
                return this.found(cu);
            }
        }
        return tree;
    }

    private <J2 extends J> J2 found(J2 j) {
        return (J2)((J)SearchResult.found((Tree)((J)j.withMarkers(j.getMarkers().compute((Marker)new MethodMatch(Tree.randomId(), this.methodPattern), (s1, s2) -> s1 == null ? s2 : s1)))));
    }

    @Generated
    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public static final class MethodMatch
    implements Marker {
        private final UUID id;
        private final String methodMatcher;

        @Generated
        public MethodMatch(UUID id, String methodMatcher) {
            this.id = id;
            this.methodMatcher = methodMatcher;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getMethodMatcher() {
            return this.methodMatcher;
        }

        @org.openrewrite.internal.lang.NonNull
        @Generated
        public String toString() {
            return "UsesMethod.MethodMatch(id=" + this.getId() + ", methodMatcher=" + this.getMethodMatcher() + ")";
        }

        @org.openrewrite.internal.lang.NonNull
        @Generated
        public MethodMatch withId(UUID id) {
            return this.id == id ? this : new MethodMatch(id, this.methodMatcher);
        }

        @org.openrewrite.internal.lang.NonNull
        @Generated
        public MethodMatch withMethodMatcher(String methodMatcher) {
            return this.methodMatcher == methodMatcher ? this : new MethodMatch(this.id, methodMatcher);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodMatch)) {
                return false;
            }
            MethodMatch other = (MethodMatch)o;
            String this$methodMatcher = this.getMethodMatcher();
            String other$methodMatcher = other.getMethodMatcher();
            return !(this$methodMatcher == null ? other$methodMatcher != null : !this$methodMatcher.equals(other$methodMatcher));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $methodMatcher = this.getMethodMatcher();
            result = result * 59 + ($methodMatcher == null ? 43 : $methodMatcher.hashCode());
            return result;
        }
    }
}

