/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.openapi.swagger;

import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class MigrateApiImplicitParam
extends Recipe {
    private static final String FQN_SCHEMA = "io.swagger.v3.oas.annotations.media.Schema";

    public String getDisplayName() {
        return "Migrate `@ApiImplicitParam` to `@Parameter`";
    }

    public String getDescription() {
        return "Migrate `@ApiImplicitParam` to `@Parameter`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.swagger.annotations.ApiImplicitParam dataTypeClass()", false), new UsesMethod("io.swagger.annotations.ApiImplicitParam defaultValue()", false)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation anno = super.visitAnnotation(annotation, (Object)ctx);
                if (!new AnnotationMatcher("io.swagger.v3.oas.annotations.Parameter").matches(anno)) {
                    return anno;
                }
                StringBuilder tpl = new StringBuilder();
                StringBuilder schemaTpl = new StringBuilder();
                ArrayList<Expression> schemaArgs = new ArrayList<Expression>();
                ArrayList<Expression> args = new ArrayList<Expression>();
                for (Expression exp : anno.getArguments()) {
                    Expression expression;
                    if (this.isDataTypeClass(exp)) {
                        expression = ((J.Assignment)exp).getAssignment();
                        this.addSchema(schemaTpl, "implementation");
                        schemaArgs.add(expression);
                        continue;
                    }
                    if (this.isDefaultValue(exp)) {
                        expression = ((J.Assignment)exp).getAssignment();
                        this.addSchema(schemaTpl, "defaultValue");
                        schemaArgs.add(expression);
                        continue;
                    }
                    tpl.append("#{any()}, ");
                    args.add(exp);
                }
                if (tpl.toString().endsWith(", ")) {
                    tpl.delete(tpl.length() - 2, tpl.length());
                }
                if (schemaTpl.length() > 0) {
                    if (schemaTpl.toString().endsWith(", ")) {
                        schemaTpl.delete(schemaTpl.length() - 2, schemaTpl.length());
                    }
                    schemaTpl.append(")");
                    tpl.append(", ").append((CharSequence)schemaTpl);
                    args.addAll(schemaArgs);
                }
                anno = (J.Annotation)JavaTemplate.builder((String)tpl.toString()).imports(new String[]{MigrateApiImplicitParam.FQN_SCHEMA}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"swagger-annotations"})).build().apply(this.updateCursor((Tree)anno), annotation.getCoordinates().replaceArguments(), args.toArray());
                this.maybeAddImport(MigrateApiImplicitParam.FQN_SCHEMA, false);
                return (J.Annotation)this.maybeAutoFormat((J)annotation, (J)anno, ctx, this.getCursor().getParentTreeCursor());
            }

            private void addSchema(StringBuilder tpl, String key) {
                if (tpl.length() == 0) {
                    tpl.append("schema = @Schema(");
                }
                tpl.append(key).append(" = #{any()}, ");
            }

            private boolean isDataTypeClass(Expression exp) {
                return exp instanceof J.Assignment && ((J.Identifier)((J.Assignment)exp).getVariable()).getSimpleName().equals("dataTypeClass");
            }

            private boolean isDefaultValue(Expression exp) {
                return exp instanceof J.Assignment && ((J.Identifier)((J.Assignment)exp).getVariable()).getSimpleName().equals("defaultValue");
            }
        });
    }
}

