/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Err;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class ComputedAttribute
extends SimpleNodeConstructor {
    private Expression attributeName;
    private Expression namespace = null;
    private NamespaceResolver nsContext;
    private SimpleType schemaType;
    private int annotation;
    private int validationAction;
    private boolean allowNameAsQName;
    private int options;

    public ComputedAttribute(Expression attributeName, Expression namespace, NamespaceResolver nsContext, int validationAction, SimpleType schemaType, int annotation, boolean allowNameAsQName) {
        this.attributeName = attributeName;
        this.namespace = namespace;
        this.nsContext = nsContext;
        this.schemaType = schemaType;
        this.annotation = annotation == -1 ? 631 : annotation;
        this.validationAction = validationAction;
        this.options = 0;
        this.allowNameAsQName = allowNameAsQName;
        this.adoptChildExpression(attributeName);
        this.adoptChildExpression(namespace);
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public int getInstructionNameCode() {
        return 131;
    }

    public Expression getNameExpression() {
        return this.attributeName;
    }

    public Expression getNamespaceExpression() {
        return this.namespace;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsContext;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.ATTRIBUTE;
    }

    public int getCardinality() {
        return 16384;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.attributeName = visitor.simplify(this.attributeName);
        this.namespace = visitor.simplify(this.namespace);
        return super.simplify(visitor);
    }

    public void localTypeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        this.attributeName = visitor.typeCheck(this.attributeName, contextItemType);
        this.adoptChildExpression(this.attributeName);
        RoleLocator role = new RoleLocator(4, "attribute/name", 0, null);
        role.setSourceLocator(this);
        if (this.allowNameAsQName) {
            boolean maybeQName;
            ItemType nameItemType;
            this.attributeName = TypeChecker.staticTypeCheck(this.attributeName, SequenceType.SINGLE_ATOMIC, false, role, visitor);
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            boolean maybeString = th.relationship(nameItemType = this.attributeName.getItemType(th), BuiltInAtomicType.STRING) != 4 || th.relationship(nameItemType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
            boolean bl = maybeQName = th.relationship(nameItemType, BuiltInAtomicType.QNAME) != 4;
            if (!maybeString && !maybeQName) {
                XPathException err = new XPathException("The attribute name must be either an xs:string, an xs:QName, or untyped atomic");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
        } else {
            this.attributeName = TypeChecker.staticTypeCheck(this.attributeName, SequenceType.SINGLE_STRING, false, role, visitor);
        }
        if (this.namespace != null) {
            visitor.typeCheck(this.namespace, contextItemType);
            this.adoptChildExpression(this.namespace);
            role = new RoleLocator(4, "attribute/namespace", 0, null);
            role.setSourceLocator(this);
            this.namespace = TypeChecker.staticTypeCheck(this.namespace, SequenceType.SINGLE_STRING, false, role, visitor);
        }
        if (Literal.isAtomic(this.attributeName)) {
            try {
                AtomicValue val = (AtomicValue)((Literal)this.attributeName).getValue();
                if (val instanceof StringValue) {
                    String[] parts = env.getConfiguration().getNameChecker().checkQNameParts(val.getStringValueCS());
                    if (this.namespace == null) {
                        String uri = this.getNamespaceResolver().getURIForPrefix(parts[0], true);
                        if (uri == null) {
                            XPathException se = new XPathException("Prefix " + parts[0] + " has not been declared");
                            se.setErrorCode("XPST0081");
                            se.setIsStaticError(true);
                            throw se;
                        }
                        this.namespace = new StringLiteral(uri);
                    }
                }
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                e.setIsStaticError(true);
                throw e;
            }
        }
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.attributeName = visitor.optimize(this.attributeName, contextItemType);
        return super.optimize(visitor, contextItemType);
    }

    public Expression copy() {
        ComputedAttribute exp = new ComputedAttribute(this.attributeName == null ? null : this.attributeName.copy(), this.namespace == null ? null : this.namespace.copy(), this.nsContext, this.validationAction, this.schemaType, this.annotation, this.allowNameAsQName);
        try {
            exp.setSelect(this.select == null ? null : this.select.copy(), this.getExecutable().getConfiguration());
        }
        catch (XPathException err) {
            throw new UnsupportedOperationException(err.getMessage());
        }
        return exp;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(3);
        if (this.select != null) {
            list.add(this.select);
        }
        list.add(this.attributeName);
        if (this.namespace != null) {
            list.add(this.namespace);
        }
        return list.iterator();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.attributeName == original) {
            this.attributeName = replacement;
            found = true;
        }
        if (this.namespace == original) {
            this.namespace = replacement;
            found = true;
        }
        return found;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.attributeName = this.doPromotion(this.attributeName, offer);
        if (this.namespace != null) {
            this.namespace = this.doPromotion(this.namespace, offer);
        }
        super.promoteInst(offer);
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (parentType instanceof SimpleType) {
            XPathException err = new XPathException("Attributes are not permitted here: the containing element is of simple type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        CharSequence value;
        int ann;
        int opt;
        SequenceReceiver out;
        int nameCode;
        block12: {
            nameCode = this.evaluateNameCode(context);
            if (nameCode == -1) {
                return null;
            }
            out = context.getReceiver();
            opt = this.options;
            ann = this.annotation;
            value = this.expandChildren(context).toString();
            if (this.schemaType != null) {
                try {
                    ValidationFailure err = this.schemaType.validateContent(value, DummyNamespaceResolver.getInstance(), context.getConfiguration().getNameChecker());
                    if (err != null) {
                        ValidationException ve = new ValidationException("Attribute value " + Err.wrap(value, 4) + " does not match the required type " + this.schemaType.getDescription() + ". " + err.getMessage());
                        ve.setErrorCode("XTTE1540");
                        throw ve;
                    }
                    break block12;
                }
                catch (UnresolvedReferenceException ure) {
                    throw new ValidationException(ure);
                }
            }
            if (this.validationAction == 1 || this.validationAction == 2) {
                try {
                    ann = context.getConfiguration().validateAttribute(nameCode, value, this.validationAction);
                }
                catch (ValidationException e) {
                    XPathException err = XPathException.makeXPathException(e);
                    String errorCode = e.getErrorCodeLocalPart();
                    if (errorCode == null) {
                        errorCode = this.validationAction == 1 ? "XTTE1510" : "XTTE1515";
                    }
                    err.setErrorCode(errorCode);
                    err.setXPathContext(context);
                    err.setLocator(this);
                    err.setIsTypeError(true);
                    throw err;
                }
            }
        }
        if ((nameCode & 0xFFFFF) == 388) {
            value = Whitespace.collapseWhitespace(value);
        }
        try {
            out.attribute(nameCode, ann, value, this.locationId, opt);
        }
        catch (XPathException err) {
            throw ComputedAttribute.dynamicError(this, err, context);
        }
        return null;
    }

    public int evaluateNameCode(XPathContext context) throws XPathException {
        String localName;
        NamePool pool = context.getNamePool();
        Item nameValue = this.attributeName.evaluateItem(context);
        String prefix = null;
        String uri = null;
        if (nameValue instanceof StringValue) {
            XPathException err;
            CharSequence rawName = nameValue.getStringValueCS();
            if (Whitespace.containsWhitespace(rawName)) {
                rawName = Whitespace.trim(rawName);
            }
            try {
                String[] parts = context.getConfiguration().getNameChecker().getQNameParts(rawName);
                prefix = parts[0];
                localName = parts[1];
            }
            catch (QNameException err2) {
                XPathException err1 = new XPathException("Invalid attribute name: " + rawName, this);
                err1.setErrorCode(this.isXSLT() ? "XTDE0850" : "XQDY0074");
                err1.setXPathContext(context);
                throw ComputedAttribute.dynamicError(this, err1, context);
            }
            if (rawName.toString().equals("xmlns") && this.namespace == null) {
                err = new XPathException("Invalid attribute name: " + rawName, this);
                err.setErrorCode(this.isXSLT() ? "XTDE0855" : "XQDY0044");
                err.setXPathContext(context);
                throw ComputedAttribute.dynamicError(this, err, context);
            }
            if (prefix.equals("xmlns")) {
                if (this.namespace == null) {
                    err = new XPathException("Invalid attribute name: " + rawName, this);
                    err.setErrorCode(this.isXSLT() ? "XTDE0860" : "XQDY0044");
                    err.setXPathContext(context);
                    throw ComputedAttribute.dynamicError(this, err, context);
                }
                prefix = "";
            }
        } else if (nameValue instanceof QNameValue && this.allowNameAsQName) {
            localName = ((QNameValue)nameValue).getLocalName();
            uri = ((QNameValue)nameValue).getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            if (localName.equals("xmlns") && uri.length() == 0) {
                XPathException err = new XPathException("Invalid attribute name: xmlns", this);
                err.setErrorCode("XQDY0044");
                err.setXPathContext(context);
                throw ComputedAttribute.dynamicError(this, err, context);
            }
            if ("xmlns".equals(prefix) || uri.equals("http://www.w3.org/2000/xmlns/")) {
                XPathException err = new XPathException("Invalid attribute namespace: http://www.w3.org/2000/xmlns/", this);
                err.setErrorCode("XQDY0044");
                err.setXPathContext(context);
                throw ComputedAttribute.dynamicError(this, err, context);
            }
            if (uri.length() == 0) {
                prefix = "";
            } else {
                prefix = ((QNameValue)nameValue).getPrefix();
                if (prefix.length() == 0) {
                    if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
                        prefix = "xml";
                    } else {
                        prefix = pool.suggestPrefixForURI(uri);
                        if (prefix == null) {
                            prefix = "ns0";
                        }
                    }
                }
            }
        } else {
            XPathException err = new XPathException("Attribute name must be either a string or a QName", this);
            err.setErrorCode("XPTY0004");
            err.setIsTypeError(true);
            err.setXPathContext(context);
            throw ComputedAttribute.dynamicError(this, err, context);
        }
        if (this.namespace == null && uri == null) {
            if (prefix.length() == 0) {
                uri = "";
            } else {
                uri = this.nsContext.getURIForPrefix(prefix, false);
                if (uri == null) {
                    XPathException err = new XPathException("Undeclared prefix in attribute name: " + prefix, this);
                    err.setErrorCode(this.isXSLT() ? "XTDE0860" : "XQDY0074");
                    err.setXPathContext(context);
                    throw ComputedAttribute.dynamicError(this, err, context);
                }
            }
        } else {
            if (uri == null) {
                if (this.namespace instanceof StringLiteral) {
                    uri = ((StringLiteral)this.namespace).getStringValue();
                } else {
                    uri = this.namespace.evaluateAsString(context).toString();
                    if (!AnyURIValue.isValidURI(uri)) {
                        XPathException de = new XPathException("The value of the namespace attribute must be a valid URI");
                        de.setErrorCode("XTDE0865");
                        de.setXPathContext(context);
                        de.setLocator(this);
                        throw de;
                    }
                }
            }
            if (uri.length() == 0) {
                prefix = "";
            } else if (prefix.length() == 0 && (prefix = pool.suggestPrefixForURI(uri)) == null) {
                prefix = "ns0";
            }
        }
        return pool.allocate(prefix, uri, localName);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("computedAttribute");
        out.emitAttribute("validation", Validation.toString(this.validationAction));
        if (this.schemaType != null) {
            out.emitAttribute("type", this.schemaType.getDescription());
        }
        out.startSubsidiaryElement("name");
        this.attributeName.explain(out);
        out.endSubsidiaryElement();
        if (this.namespace != null) {
            out.startSubsidiaryElement("namespace");
            this.namespace.explain(out);
            out.endSubsidiaryElement();
        }
        out.startSubsidiaryElement("select");
        this.getSelect().explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

