/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.JsonSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.ObjectMapperFactory;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.SemVer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelUtils.class);
    private static final String URI_FORMAT = "uri";
    private static final String generateAliasAsModelKey = "generateAliasAsModel";
    private static final String openapiDocVersion = "x-original-swagger-version";
    private static final String disallowAdditionalPropertiesIfNotPresent = "x-disallow-additional-properties-if-not-present";
    private static final String freeFormExplicit = "x-is-free-form";
    private static final ObjectMapper JSON_MAPPER = ObjectMapperFactory.createJson();
    private static final ObjectMapper YAML_MAPPER = ObjectMapperFactory.createYaml();

    public static boolean isDisallowAdditionalPropertiesIfNotPresent() {
        return Boolean.parseBoolean(GlobalSettings.getProperty(disallowAdditionalPropertiesIfNotPresent, "true"));
    }

    public static void setDisallowAdditionalPropertiesIfNotPresent(boolean value) {
        GlobalSettings.setProperty(disallowAdditionalPropertiesIfNotPresent, Boolean.toString(value));
    }

    public static boolean isGenerateAliasAsModel() {
        return Boolean.parseBoolean(GlobalSettings.getProperty(generateAliasAsModelKey, "false"));
    }

    public static void setGenerateAliasAsModel(boolean value) {
        GlobalSettings.setProperty(generateAliasAsModelKey, Boolean.toString(value));
    }

    public static boolean isGenerateAliasAsModel(Schema schema) {
        return ModelUtils.isGenerateAliasAsModel() || schema.getExtensions() != null && ((Object)schema.getExtensions().getOrDefault("x-generate-alias-as-model", false)).equals(true);
    }

    public static CodegenModel getModelByName(String name, Map<String, ModelsMap> models) {
        List<ModelMap> dataModelsList;
        ModelsMap data = models.get(name);
        if (data != null && (dataModelsList = data.getModels()) != null) {
            for (ModelMap entryMap : dataModelsList) {
                CodegenModel model = entryMap.getModel();
                if (model == null) continue;
                return model;
            }
        }
        return null;
    }

    public static List<String> getAllUsedSchemas(OpenAPI openAPI) {
        Map<String, List<String>> childrenMap = ModelUtils.getChildrenMap(openAPI);
        ArrayList<String> allUsedSchemas = new ArrayList<String>();
        ModelUtils.visitOpenAPI(openAPI, (s, t) -> {
            if (s.get$ref() != null) {
                String ref = ModelUtils.getSimpleRef(s.get$ref());
                if (!allUsedSchemas.contains(ref)) {
                    allUsedSchemas.add(ref);
                }
                if (childrenMap.containsKey(ref)) {
                    for (String child : (List)childrenMap.get(ref)) {
                        if (allUsedSchemas.contains(child)) continue;
                        allUsedSchemas.add(child);
                    }
                }
            }
        });
        return allUsedSchemas;
    }

    public static List<String> getUnusedSchemas(OpenAPI openAPI) {
        Map<String, List<String>> tmpChildrenMap;
        try {
            tmpChildrenMap = ModelUtils.getChildrenMap(openAPI);
        }
        catch (NullPointerException npe) {
            tmpChildrenMap = new HashMap<String, List<String>>();
        }
        Map<String, List<String>> childrenMap = tmpChildrenMap;
        ArrayList<String> unusedSchemas = new ArrayList<String>();
        if (openAPI != null) {
            Map<String, Schema> schemas = ModelUtils.getSchemas(openAPI);
            unusedSchemas.addAll(schemas.keySet());
            ModelUtils.visitOpenAPI(openAPI, (s, t) -> {
                if (s.get$ref() != null) {
                    String ref = ModelUtils.getSimpleRef(s.get$ref());
                    unusedSchemas.remove(ref);
                    if (childrenMap.containsKey(ref)) {
                        unusedSchemas.removeAll((Collection)childrenMap.get(ref));
                    }
                }
            });
        }
        return unusedSchemas;
    }

    public static List<String> getSchemasUsedOnlyInFormParam(OpenAPI openAPI) {
        ArrayList schemasUsedInFormParam = new ArrayList();
        ArrayList schemasUsedInOtherCases = new ArrayList();
        ModelUtils.visitOpenAPI(openAPI, (s, t) -> {
            if (s != null && s.get$ref() != null) {
                String ref = ModelUtils.getSimpleRef(s.get$ref());
                if ("application/x-www-form-urlencoded".equalsIgnoreCase(t) || "multipart/form-data".equalsIgnoreCase(t)) {
                    schemasUsedInFormParam.add(ref);
                } else {
                    schemasUsedInOtherCases.add(ref);
                }
            }
        });
        return schemasUsedInFormParam.stream().filter(n -> !schemasUsedInOtherCases.contains(n)).collect(Collectors.toList());
    }

    private static void visitOpenAPI(OpenAPI openAPI, OpenAPISchemaVisitor visitor) {
        Paths paths = openAPI.getPaths();
        ArrayList<String> visitedSchemas = new ArrayList<String>();
        if (paths != null) {
            for (PathItem path : paths.values()) {
                ModelUtils.visitPathItem(path, openAPI, visitor, visitedSchemas);
            }
        }
    }

    private static void visitPathItem(PathItem pathItem, OpenAPI openAPI, OpenAPISchemaVisitor visitor, List<String> visitedSchemas) {
        List allOperations = pathItem.readOperations();
        if (allOperations != null) {
            for (Operation operation : allOperations) {
                ModelUtils.visitParameters(openAPI, operation.getParameters(), visitor, visitedSchemas);
                RequestBody requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody());
                if (requestBody != null) {
                    ModelUtils.visitContent(openAPI, requestBody.getContent(), visitor, visitedSchemas);
                }
                if (operation.getResponses() != null) {
                    for (ApiResponse r : operation.getResponses().values()) {
                        ApiResponse apiResponse = ModelUtils.getReferencedApiResponse(openAPI, r);
                        if (apiResponse == null) continue;
                        ModelUtils.visitContent(openAPI, apiResponse.getContent(), visitor, visitedSchemas);
                        if (apiResponse.getHeaders() == null) continue;
                        for (Map.Entry entry : apiResponse.getHeaders().entrySet()) {
                            Header header = ModelUtils.getReferencedHeader(openAPI, (Header)entry.getValue());
                            if (header.getSchema() != null) {
                                ModelUtils.visitSchema(openAPI, header.getSchema(), (String)entry.getKey(), visitedSchemas, visitor);
                            }
                            ModelUtils.visitContent(openAPI, header.getContent(), visitor, visitedSchemas);
                        }
                    }
                }
                if (operation.getCallbacks() == null) continue;
                for (Callback c : operation.getCallbacks().values()) {
                    Callback callback = ModelUtils.getReferencedCallback(openAPI, c);
                    if (callback == null) continue;
                    for (PathItem pathItem2 : callback.values()) {
                        ModelUtils.visitPathItem(pathItem2, openAPI, visitor, visitedSchemas);
                    }
                }
            }
        }
        ModelUtils.visitParameters(openAPI, pathItem.getParameters(), visitor, visitedSchemas);
    }

    private static void visitParameters(OpenAPI openAPI, List<Parameter> parameters, OpenAPISchemaVisitor visitor, List<String> visitedSchemas) {
        if (parameters != null) {
            for (Parameter p : parameters) {
                Parameter parameter = ModelUtils.getReferencedParameter(openAPI, p);
                if (parameter != null) {
                    if (parameter.getSchema() != null) {
                        ModelUtils.visitSchema(openAPI, parameter.getSchema(), null, visitedSchemas, visitor);
                    }
                    ModelUtils.visitContent(openAPI, parameter.getContent(), visitor, visitedSchemas);
                    continue;
                }
                OnceLogger.once(LOGGER).warn("Unreferenced parameter(s) found.");
            }
        }
    }

    private static void visitContent(OpenAPI openAPI, Content content, OpenAPISchemaVisitor visitor, List<String> visitedSchemas) {
        if (content != null) {
            for (Map.Entry e : content.entrySet()) {
                if (((MediaType)e.getValue()).getSchema() == null) continue;
                ModelUtils.visitSchema(openAPI, ((MediaType)e.getValue()).getSchema(), (String)e.getKey(), visitedSchemas, visitor);
            }
        }
    }

    private static void visitSchema(OpenAPI openAPI, Schema schema, String mimeType, List<String> visitedSchemas, OpenAPISchemaVisitor visitor) {
        Map properties;
        Object additionalProperties;
        String ref;
        if (schema == null) {
            return;
        }
        visitor.visit(schema, mimeType);
        if (schema.get$ref() != null && !visitedSchemas.contains(ref = ModelUtils.getSimpleRef(schema.get$ref()))) {
            visitedSchemas.add(ref);
            Schema referencedSchema = ModelUtils.getSchemas(openAPI).get(ref);
            if (referencedSchema != null) {
                ModelUtils.visitSchema(openAPI, referencedSchema, mimeType, visitedSchemas, visitor);
            }
        }
        if (ModelUtils.isComposedSchema(schema)) {
            List anyOf;
            List allOf;
            List oneOf = schema.getOneOf();
            if (oneOf != null) {
                for (Schema s : oneOf) {
                    ModelUtils.visitSchema(openAPI, s, mimeType, visitedSchemas, visitor);
                }
            }
            if ((allOf = schema.getAllOf()) != null) {
                for (Schema s : allOf) {
                    ModelUtils.visitSchema(openAPI, s, mimeType, visitedSchemas, visitor);
                }
            }
            if ((anyOf = schema.getAnyOf()) != null) {
                for (Schema s : anyOf) {
                    ModelUtils.visitSchema(openAPI, s, mimeType, visitedSchemas, visitor);
                }
            }
        } else if (ModelUtils.isArraySchema(schema)) {
            Schema<?> itemsSchema = ModelUtils.getSchemaItems(schema);
            if (itemsSchema != null) {
                ModelUtils.visitSchema(openAPI, itemsSchema, mimeType, visitedSchemas, visitor);
            }
        } else if (ModelUtils.isMapSchema(schema) && (additionalProperties = schema.getAdditionalProperties()) instanceof Schema) {
            ModelUtils.visitSchema(openAPI, (Schema)additionalProperties, mimeType, visitedSchemas, visitor);
        }
        if (schema.getNot() != null) {
            ModelUtils.visitSchema(openAPI, schema.getNot(), mimeType, visitedSchemas, visitor);
        }
        if ((properties = schema.getProperties()) != null) {
            for (Schema property : properties.values()) {
                ModelUtils.visitSchema(openAPI, property, null, visitedSchemas, visitor);
            }
        }
    }

    public static String getSimpleRef(String ref) {
        if (ref == null) {
            OnceLogger.once(LOGGER).warn("Failed to get the schema name: null");
            return null;
        }
        if (ref.startsWith("#/components/")) {
            ref = ref.substring(ref.lastIndexOf("/") + 1);
        } else if (ref.startsWith("#/definitions/")) {
            ref = ref.substring(ref.lastIndexOf("/") + 1);
        } else {
            OnceLogger.once(LOGGER).warn("Failed to get the schema name: {}", (Object)ref);
            return null;
        }
        try {
            ref = URLDecoder.decode(ref, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            OnceLogger.once(LOGGER).warn("Found UnsupportedEncodingException: {}", (Object)ref);
        }
        ref = ref.replace("~1", "/").replace("~0", "~");
        return ref;
    }

    public static boolean isTypeObjectSchema(Schema schema) {
        if (schema instanceof JsonSchema) {
            if (schema.getTypes() != null && schema.getTypes().size() == 1) {
                return "object".equals(schema.getTypes().iterator().next());
            }
            return false;
        }
        return "object".equals(schema.getType());
    }

    public static boolean isObjectSchema(Schema schema) {
        if (schema == null) {
            return false;
        }
        return schema instanceof ObjectSchema || "object".equals(schema.getType()) && !ModelUtils.isMapSchema(schema) || schema.getType() == null && schema.getProperties() != null && !schema.getProperties().isEmpty();
    }

    public static boolean isComposedSchema(Schema schema) {
        if (schema == null) {
            return false;
        }
        if (schema instanceof ComposedSchema) {
            return true;
        }
        if (schema.getOneOf() != null) {
            return true;
        }
        if (schema.getAnyOf() != null) {
            return true;
        }
        return schema.getAllOf() != null;
    }

    public static boolean isComplexComposedSchema(Schema schema) {
        int count = 0;
        if (schema.getAllOf() != null && !schema.getAllOf().isEmpty()) {
            ++count;
        }
        if (schema.getOneOf() != null && !schema.getOneOf().isEmpty()) {
            ++count;
        }
        if (schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) {
            ++count;
        }
        if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            ++count;
        }
        return count > 1;
    }

    public static boolean isMapSchema(Schema schema) {
        if (schema == null) {
            return false;
        }
        if (schema.getAdditionalProperties() instanceof Boolean && Boolean.FALSE.equals(schema.getAdditionalProperties())) {
            return false;
        }
        if (schema instanceof JsonSchema) {
            return schema.getAdditionalProperties() instanceof JsonSchema || schema.getAdditionalProperties() instanceof Boolean && (Boolean)schema.getAdditionalProperties() != false;
        }
        return schema instanceof MapSchema || schema.getAdditionalProperties() instanceof Schema || schema.getAdditionalProperties() instanceof Boolean && (Boolean)schema.getAdditionalProperties() != false;
    }

    public static boolean isArraySchema(Schema schema) {
        if (schema == null) {
            return false;
        }
        if (schema instanceof JsonSchema) {
            return schema.getTypes() != null && schema.getTypes().contains("array");
        }
        return schema instanceof ArraySchema || "array".equals(schema.getType());
    }

    public static Schema<?> getSchemaItems(Schema schema) {
        if (!ModelUtils.isArraySchema(schema)) {
            return null;
        }
        Schema items = schema.getItems();
        if (items == null && !(schema instanceof JsonSchema)) {
            LOGGER.error("Undefined array inner type for `{}`. Default to String.", (Object)schema.getName());
            items = new StringSchema().description("TODO default missing array inner type to string");
            schema.setItems(items);
        }
        return items;
    }

    public static boolean isSet(Schema schema) {
        return ModelUtils.isArraySchema(schema) && Boolean.TRUE.equals(schema.getUniqueItems());
    }

    public static boolean isStringSchema(Schema schema) {
        return schema instanceof StringSchema || "string".equals(schema.getType());
    }

    public static boolean isIntegerSchema(Schema schema) {
        return schema instanceof IntegerSchema || "integer".equals(schema.getType());
    }

    public static boolean isShortSchema(Schema schema) {
        return "integer".equals(schema.getType()) && "int32".equals(schema.getFormat());
    }

    public static boolean isUnsignedIntegerSchema(Schema schema) {
        return "integer".equals(schema.getType()) && ("int32".equals(schema.getFormat()) || schema.getFormat() == null) && schema.getExtensions() != null && schema.getExtensions().getOrDefault("x-unsigned", Boolean.FALSE) != false;
    }

    public static boolean isLongSchema(Schema schema) {
        return "integer".equals(schema.getType()) && "int64".equals(schema.getFormat());
    }

    public static boolean isUnsignedLongSchema(Schema schema) {
        return "integer".equals(schema.getType()) && "int64".equals(schema.getFormat()) && schema.getExtensions() != null && schema.getExtensions().getOrDefault("x-unsigned", Boolean.FALSE) != false;
    }

    public static boolean isBooleanSchema(Schema schema) {
        return schema instanceof BooleanSchema || "boolean".equals(schema.getType());
    }

    public static boolean isNumberSchema(Schema schema) {
        return schema instanceof NumberSchema || "number".equals(schema.getType());
    }

    public static boolean isFloatSchema(Schema schema) {
        return "number".equals(schema.getType()) && "float".equals(schema.getFormat());
    }

    public static boolean isDoubleSchema(Schema schema) {
        return "number".equals(schema.getType()) && "double".equals(schema.getFormat());
    }

    public static boolean isDateSchema(Schema schema) {
        return schema instanceof DateSchema || "string".equals(schema.getType()) && "date".equals(schema.getFormat());
    }

    public static boolean isDateTimeSchema(Schema schema) {
        return schema instanceof DateTimeSchema || "string".equals(schema.getType()) && "date-time".equals(schema.getFormat());
    }

    public static boolean isPasswordSchema(Schema schema) {
        return schema instanceof PasswordSchema || "string".equals(schema.getType()) && "password".equals(schema.getFormat());
    }

    public static boolean isByteArraySchema(Schema schema) {
        return schema instanceof ByteArraySchema || "string".equals(schema.getType()) && "byte".equals(schema.getFormat());
    }

    public static boolean isBinarySchema(Schema schema) {
        return schema instanceof BinarySchema || "string".equals(schema.getType()) && "binary".equals(schema.getFormat());
    }

    public static boolean isFileSchema(Schema schema) {
        return schema instanceof FileSchema || ModelUtils.isBinarySchema(schema);
    }

    public static boolean isUUIDSchema(Schema schema) {
        return schema instanceof UUIDSchema || "string".equals(schema.getType()) && "uuid".equals(schema.getFormat());
    }

    public static boolean isURISchema(Schema schema) {
        return "string".equals(schema.getType()) && URI_FORMAT.equals(schema.getFormat());
    }

    public static boolean isEmailSchema(Schema schema) {
        return schema instanceof EmailSchema || "string".equals(schema.getType()) && "email".equals(schema.getFormat());
    }

    public static boolean isDecimalSchema(Schema schema) {
        return "string".equals(schema.getType()) && "number".equals(schema.getFormat());
    }

    public static boolean shouldIgnoreBeanValidation(Schema schema) {
        return ModelUtils.isByteArraySchema(schema) || ModelUtils.isBinarySchema(schema) || ModelUtils.isUUIDSchema(schema) || ModelUtils.isURISchema(schema);
    }

    public static boolean isModel(Schema schema) {
        return schema != null && (null != schema.getProperties() && !schema.getProperties().isEmpty() || ModelUtils.isComposedSchema(schema) || schema instanceof ObjectSchema);
    }

    public static boolean isModelWithPropertiesOnly(Schema schema) {
        return schema != null && null != schema.getProperties() && !schema.getProperties().isEmpty() && (schema.getAdditionalProperties() == null || schema.getAdditionalProperties() instanceof Boolean && (Boolean)schema.getAdditionalProperties() == false);
    }

    public static boolean hasValidation(Schema sc) {
        return sc.getMaxItems() != null || sc.getMinProperties() != null || sc.getMaxProperties() != null || sc.getMinLength() != null || sc.getMinItems() != null || sc.getMultipleOf() != null || sc.getPattern() != null || sc.getMaxLength() != null || sc.getMinimum() != null || sc.getMaximum() != null || sc.getExclusiveMaximum() != null || sc.getExclusiveMinimum() != null || sc.getUniqueItems() != null;
    }

    public static boolean isFreeFormObject(Schema schema) {
        List<Schema> interfaces;
        if (schema == null) {
            OnceLogger.once(LOGGER).error("Schema cannot be null in isFreeFormObject check");
            return false;
        }
        if (schema instanceof JsonSchema) {
            if (ModelUtils.isComposedSchema(schema)) {
                return false;
            }
            if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                return false;
            }
            if (schema.getAdditionalProperties() instanceof Boolean && ((Boolean)schema.getAdditionalProperties()).booleanValue()) {
                return true;
            }
            if (schema.getAdditionalProperties() instanceof JsonSchema) {
                return true;
            }
            if (schema.getTypes() != null) {
                if (schema.getTypes().size() == 1) {
                    return "object".equals(schema.getTypes().iterator().next());
                }
                return false;
            }
            return false;
        }
        if (ModelUtils.isComposedSchema(schema) && (interfaces = ModelUtils.getInterfaces(schema)) != null && !interfaces.isEmpty()) {
            return false;
        }
        if ("object".equals(schema.getType()) && (schema.getProperties() == null || schema.getProperties().isEmpty())) {
            Schema addlProps = ModelUtils.getAdditionalProperties(schema);
            if (schema.getExtensions() != null && schema.getExtensions().containsKey(freeFormExplicit)) {
                boolean isFreeFormExplicit = Boolean.parseBoolean(String.valueOf(schema.getExtensions().get(freeFormExplicit)));
                if (!isFreeFormExplicit && addlProps != null && addlProps.getProperties() != null && !addlProps.getProperties().isEmpty()) {
                    OnceLogger.once(LOGGER).error(String.format(Locale.ROOT, "Potentially confusing usage of %s within model which defines additional properties", freeFormExplicit));
                }
                return isFreeFormExplicit;
            }
            if (addlProps == null) {
                return true;
            }
            if (addlProps instanceof ObjectSchema) {
                ObjectSchema objSchema = (ObjectSchema)addlProps;
                return objSchema.getProperties() == null || objSchema.getProperties().isEmpty();
            }
            if (addlProps instanceof Schema) {
                return addlProps.getType() == null && addlProps.get$ref() == null && (addlProps.getProperties() == null || addlProps.getProperties().isEmpty());
            }
        }
        return false;
    }

    public static boolean shouldGenerateFreeFormObjectModel(String name, CodegenConfig config) {
        Schema refSchema = new Schema();
        refSchema.set$ref("#/components/schemas/" + name);
        Schema unaliasedSchema = config.unaliasSchema(refSchema);
        return unaliasedSchema.get$ref() != null;
    }

    public static boolean shouldGenerateMapModel(Schema schema) {
        return ModelUtils.isGenerateAliasAsModel(schema) || ModelUtils.isComposedSchema(schema) || schema.getProperties() != null && !schema.getProperties().isEmpty();
    }

    public static boolean shouldGenerateArrayModel(Schema schema) {
        return ModelUtils.isGenerateAliasAsModel(schema) || schema.getProperties() != null && !schema.getProperties().isEmpty();
    }

    public static Schema getReferencedSchema(OpenAPI openAPI, Schema schema) {
        if (schema == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)schema.get$ref())) {
            return schema;
        }
        try {
            Schema refSchema = ModelUtils.getSchemaFromRefToSchemaWithProperties(openAPI, schema.get$ref());
            if (refSchema != null) {
                return refSchema;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse $ref {}. Please report the issue to openapi-generator GitHub repo.", (Object)schema.get$ref());
        }
        String name = ModelUtils.getSimpleRef(schema.get$ref());
        Schema referencedSchema = ModelUtils.getSchema(openAPI, name);
        if (referencedSchema != null) {
            return referencedSchema;
        }
        return schema;
    }

    public static Schema getSchemaFromRefToSchemaWithProperties(OpenAPI openAPI, String refString) {
        if (refString == null) {
            return null;
        }
        String[] parts = refString.split("/");
        if (parts.length == 6 && "properties".equals(parts[4])) {
            Schema referencedSchema = ModelUtils.getSchema(openAPI, parts[3]);
            return (Schema)referencedSchema.getProperties().get(parts[5]);
        }
        return null;
    }

    public static boolean isRefToSchemaWithProperties(String refString) {
        if (refString == null) {
            return false;
        }
        String[] parts = refString.split("/");
        return parts.length == 6 && "properties".equals(parts[4]);
    }

    public static Schema getSchema(OpenAPI openAPI, String name) {
        if (name == null) {
            return null;
        }
        return ModelUtils.getSchemas(openAPI).get(name);
    }

    public static Map<String, Schema> getSchemas(OpenAPI openAPI) {
        if (openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null) {
            return openAPI.getComponents().getSchemas();
        }
        return Collections.emptyMap();
    }

    public static List<Schema> getAllSchemas(OpenAPI openAPI) {
        ArrayList<Schema> allSchemas = new ArrayList<Schema>();
        ArrayList refSchemas = new ArrayList();
        ModelUtils.getSchemas(openAPI).forEach((key, schema) -> ModelUtils.visitSchema(openAPI, schema, null, refSchemas, (s, mimetype) -> allSchemas.add(s)));
        return allSchemas;
    }

    public static RequestBody getReferencedRequestBody(OpenAPI openAPI, RequestBody requestBody) {
        String name;
        RequestBody referencedRequestBody;
        if (requestBody != null && StringUtils.isNotEmpty((CharSequence)requestBody.get$ref()) && (referencedRequestBody = ModelUtils.getRequestBody(openAPI, name = ModelUtils.getSimpleRef(requestBody.get$ref()))) != null) {
            return referencedRequestBody;
        }
        return requestBody;
    }

    public static RequestBody getRequestBody(OpenAPI openAPI, String name) {
        if (name == null) {
            return null;
        }
        if (openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getRequestBodies() != null) {
            return (RequestBody)openAPI.getComponents().getRequestBodies().get(name);
        }
        return null;
    }

    public static ApiResponse getReferencedApiResponse(OpenAPI openAPI, ApiResponse apiResponse) {
        String name;
        ApiResponse referencedApiResponse;
        if (apiResponse != null && StringUtils.isNotEmpty((CharSequence)apiResponse.get$ref()) && (referencedApiResponse = ModelUtils.getApiResponse(openAPI, name = ModelUtils.getSimpleRef(apiResponse.get$ref()))) != null) {
            return referencedApiResponse;
        }
        return apiResponse;
    }

    public static ApiResponse getApiResponse(OpenAPI openAPI, String name) {
        if (name != null && openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getResponses() != null) {
            return (ApiResponse)openAPI.getComponents().getResponses().get(name);
        }
        return null;
    }

    public static Parameter getReferencedParameter(OpenAPI openAPI, Parameter parameter) {
        String name;
        Parameter referencedParameter;
        if (parameter != null && StringUtils.isNotEmpty((CharSequence)parameter.get$ref()) && (referencedParameter = ModelUtils.getParameter(openAPI, name = ModelUtils.getSimpleRef(parameter.get$ref()))) != null) {
            return referencedParameter;
        }
        return parameter;
    }

    public static Parameter getParameter(OpenAPI openAPI, String name) {
        if (name != null && openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getParameters() != null) {
            return (Parameter)openAPI.getComponents().getParameters().get(name);
        }
        return null;
    }

    public static Callback getReferencedCallback(OpenAPI openAPI, Callback callback) {
        String name;
        Callback referencedCallback;
        if (callback != null && StringUtils.isNotEmpty((CharSequence)callback.get$ref()) && (referencedCallback = ModelUtils.getCallback(openAPI, name = ModelUtils.getSimpleRef(callback.get$ref()))) != null) {
            return referencedCallback;
        }
        return callback;
    }

    public static Callback getCallback(OpenAPI openAPI, String name) {
        if (name != null && openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getCallbacks() != null) {
            return (Callback)openAPI.getComponents().getCallbacks().get(name);
        }
        return null;
    }

    public static Schema getSchemaFromRequestBody(RequestBody requestBody) {
        return ModelUtils.getSchemaFromContent(requestBody.getContent());
    }

    public static Schema getSchemaFromResponse(OpenAPI openAPI, ApiResponse response) {
        ApiResponse result = ModelUtils.getReferencedApiResponse(openAPI, response);
        if (result == null) {
            return null;
        }
        return ModelUtils.getSchemaFromContent(result.getContent());
    }

    private static Schema getSchemaFromContent(Content content) {
        if (content == null || content.isEmpty()) {
            return null;
        }
        Map.Entry entry = (Map.Entry)content.entrySet().iterator().next();
        if (content.size() > 1) {
            OnceLogger.once(LOGGER).debug("Multiple schemas found in the OAS 'content' section, returning only the first one ({})", entry.getKey());
        }
        return ((MediaType)entry.getValue()).getSchema();
    }

    public static boolean hasSelfReference(OpenAPI openAPI, Schema schema) {
        return ModelUtils.hasSelfReference(openAPI, schema, null);
    }

    public static boolean hasSelfReference(OpenAPI openAPI, Schema schema, Set<String> visitedSchemaNames) {
        block19: {
            block18: {
                List anyOf;
                List allOf;
                if (visitedSchemaNames == null) {
                    visitedSchemaNames = new HashSet<String>();
                }
                if (schema.get$ref() != null) {
                    String ref = ModelUtils.getSimpleRef(schema.get$ref());
                    if (!visitedSchemaNames.contains(ref)) {
                        visitedSchemaNames.add(ref);
                        Schema referencedSchema = ModelUtils.getSchemas(openAPI).get(ref);
                        if (referencedSchema != null) {
                            return ModelUtils.hasSelfReference(openAPI, referencedSchema, visitedSchemaNames);
                        }
                        LOGGER.error("Failed to obtain schema from `{}` in self reference check", (Object)ref);
                        return false;
                    }
                    return true;
                }
                if (!ModelUtils.isComposedSchema(schema)) break block18;
                List oneOf = schema.getOneOf();
                if (oneOf != null) {
                    for (Schema s : oneOf) {
                        if (!ModelUtils.hasSelfReference(openAPI, s, visitedSchemaNames)) continue;
                        return true;
                    }
                }
                if ((allOf = schema.getAllOf()) != null) {
                    for (Schema s : allOf) {
                        if (!ModelUtils.hasSelfReference(openAPI, s, visitedSchemaNames)) continue;
                        return true;
                    }
                }
                if ((anyOf = schema.getAnyOf()) == null) break block19;
                for (Schema s : anyOf) {
                    if (!ModelUtils.hasSelfReference(openAPI, s, visitedSchemaNames)) continue;
                    return true;
                }
                break block19;
            }
            if (ModelUtils.isArraySchema(schema)) {
                Schema<?> itemsSchema = ModelUtils.getSchemaItems(schema);
                if (itemsSchema != null) {
                    return ModelUtils.hasSelfReference(openAPI, itemsSchema, visitedSchemaNames);
                }
            } else if (ModelUtils.isMapSchema(schema)) {
                Object additionalProperties = schema.getAdditionalProperties();
                if (additionalProperties instanceof Schema) {
                    return ModelUtils.hasSelfReference(openAPI, (Schema)additionalProperties, visitedSchemaNames);
                }
            } else {
                if (schema.getNot() != null) {
                    return ModelUtils.hasSelfReference(openAPI, schema.getNot(), visitedSchemaNames);
                }
                if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                    for (Schema property : schema.getProperties().values()) {
                        if (!ModelUtils.hasSelfReference(openAPI, property, visitedSchemaNames)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Schema unaliasSchema(OpenAPI openAPI, Schema schema) {
        return ModelUtils.unaliasSchema(openAPI, schema, Collections.emptyMap());
    }

    public static Schema unaliasSchema(OpenAPI openAPI, Schema schema, Map<String, String> schemaMappings) {
        Map<String, Schema> allSchemas = ModelUtils.getSchemas(openAPI);
        if (allSchemas == null || allSchemas.isEmpty()) {
            return schema;
        }
        if (schema != null && StringUtils.isNotEmpty((CharSequence)schema.get$ref())) {
            String simpleRef = ModelUtils.getSimpleRef(schema.get$ref());
            if (schemaMappings.containsKey(simpleRef)) {
                LOGGER.debug("Schema unaliasing of {} omitted because aliased class is to be mapped to {}", (Object)simpleRef, (Object)schemaMappings.get(simpleRef));
                return schema;
            }
            Schema ref = allSchemas.get(simpleRef);
            if (ref == null) {
                if (!ModelUtils.isRefToSchemaWithProperties(schema.get$ref())) {
                    OnceLogger.once(LOGGER).warn("{} is not defined", (Object)schema.get$ref());
                }
                return schema;
            }
            if (ref.getEnum() != null && !ref.getEnum().isEmpty()) {
                return schema;
            }
            if (ModelUtils.isArraySchema(ref)) {
                if (ModelUtils.isGenerateAliasAsModel(ref)) {
                    return schema;
                }
                return ModelUtils.unaliasSchema(openAPI, allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), schemaMappings);
            }
            if (ModelUtils.isComposedSchema(ref)) {
                return schema;
            }
            if (ModelUtils.isMapSchema(ref)) {
                if (ref.getProperties() != null && !ref.getProperties().isEmpty()) {
                    return schema;
                }
                if (ModelUtils.isGenerateAliasAsModel(ref)) {
                    return schema;
                }
                return ModelUtils.unaliasSchema(openAPI, allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), schemaMappings);
            }
            if (ModelUtils.isObjectSchema(ref)) {
                if (ref.getProperties() != null && !ref.getProperties().isEmpty()) {
                    return schema;
                }
                return ModelUtils.unaliasSchema(openAPI, allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), schemaMappings);
            }
            return ModelUtils.unaliasSchema(openAPI, allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), schemaMappings);
        }
        return schema;
    }

    public static Schema getAdditionalProperties(Schema schema) {
        Object addProps = schema.getAdditionalProperties();
        if (addProps instanceof Schema) {
            return (Schema)addProps;
        }
        if (addProps == null && ModelUtils.isDisallowAdditionalPropertiesIfNotPresent()) {
            return null;
        }
        if (addProps == null || addProps instanceof Boolean && ((Boolean)addProps).booleanValue()) {
            return new Schema();
        }
        return null;
    }

    public static Header getReferencedHeader(OpenAPI openAPI, Header header) {
        String name;
        Header referencedheader;
        if (header != null && StringUtils.isNotEmpty((CharSequence)header.get$ref()) && (referencedheader = ModelUtils.getHeader(openAPI, name = ModelUtils.getSimpleRef(header.get$ref()))) != null) {
            return referencedheader;
        }
        return header;
    }

    public static Header getHeader(OpenAPI openAPI, String name) {
        if (name != null && openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getHeaders() != null) {
            return (Header)openAPI.getComponents().getHeaders().get(name);
        }
        return null;
    }

    public static Map<String, List<String>> getChildrenMap(OpenAPI openAPI) {
        Map<String, Schema> allSchemas = ModelUtils.getSchemas(openAPI);
        Map<String, List<Map.Entry>> groupedByParent = allSchemas.entrySet().stream().filter(entry -> ModelUtils.isComposedSchema((Schema)entry.getValue())).filter(entry -> ModelUtils.getParentName((Schema)entry.getValue(), allSchemas) != null).collect(Collectors.groupingBy(entry -> ModelUtils.getParentName((Schema)entry.getValue(), allSchemas)));
        return groupedByParent.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((List)entry.getValue()).stream().map(e -> (String)e.getKey()).collect(Collectors.toList())));
    }

    public static List<Schema> getInterfaces(Schema composed) {
        if (composed.getAllOf() != null && !composed.getAllOf().isEmpty()) {
            return composed.getAllOf();
        }
        if (composed.getAnyOf() != null && !composed.getAnyOf().isEmpty()) {
            return composed.getAnyOf();
        }
        if (composed.getOneOf() != null && !composed.getOneOf().isEmpty()) {
            return composed.getOneOf();
        }
        return Collections.emptyList();
    }

    public static String getParentName(Schema composedSchema, Map<String, Schema> allSchemas) {
        List<Schema> interfaces = ModelUtils.getInterfaces(composedSchema);
        int nullSchemaChildrenCount = 0;
        boolean hasAmbiguousParents = false;
        ArrayList<String> refedWithoutDiscriminator = new ArrayList<String>();
        if (interfaces != null && !interfaces.isEmpty()) {
            for (Schema schema : interfaces) {
                if (StringUtils.isNotEmpty((CharSequence)schema.get$ref())) {
                    String parentName = ModelUtils.getSimpleRef(schema.get$ref());
                    Schema s = allSchemas.get(parentName);
                    if (s == null) {
                        LOGGER.error("Failed to obtain schema from {}", (Object)parentName);
                        return "UNKNOWN_PARENT_NAME";
                    }
                    if (ModelUtils.hasOrInheritsDiscriminator(s, allSchemas, new ArrayList<Schema>())) {
                        return parentName;
                    }
                    hasAmbiguousParents = true;
                    refedWithoutDiscriminator.add(parentName);
                    continue;
                }
                if (!ModelUtils.isNullType(schema)) continue;
                ++nullSchemaChildrenCount;
            }
            if (refedWithoutDiscriminator.size() == 1 && nullSchemaChildrenCount == 1) {
                hasAmbiguousParents = false;
            }
        }
        return null;
    }

    public static List<String> getAllParentsName(Schema composedSchema, Map<String, Schema> allSchemas, boolean includeAncestors) {
        String parentName;
        List<Schema> interfaces = ModelUtils.getInterfaces(composedSchema);
        ArrayList<String> names = new ArrayList<String>();
        if (interfaces != null && !interfaces.isEmpty()) {
            for (Schema schema : interfaces) {
                if (!StringUtils.isNotEmpty((CharSequence)schema.get$ref())) continue;
                String parentName2 = ModelUtils.getSimpleRef(schema.get$ref());
                Schema s = allSchemas.get(parentName2);
                if (s == null) {
                    LOGGER.error("Failed to obtain schema from {}", (Object)parentName2);
                    names.add("UNKNOWN_PARENT_NAME");
                    continue;
                }
                if (!ModelUtils.hasOrInheritsDiscriminator(s, allSchemas, new ArrayList<Schema>())) continue;
                names.add(parentName2);
                if (!includeAncestors || !ModelUtils.isComposedSchema(s)) continue;
                names.addAll(ModelUtils.getAllParentsName(s, allSchemas, true));
            }
        }
        if ((parentName = ModelUtils.getParentName(composedSchema, allSchemas)) != null && !names.contains(parentName)) {
            names.add(parentName);
        }
        return names;
    }

    private static boolean hasOrInheritsDiscriminator(Schema schema, Map<String, Schema> allSchemas, ArrayList<Schema> visitedSchemas) {
        for (Schema s : visitedSchemas) {
            if (s != schema) continue;
            return false;
        }
        visitedSchemas.add(schema);
        if (schema.getDiscriminator() != null && StringUtils.isNotEmpty((CharSequence)schema.getDiscriminator().getPropertyName()) || ModelUtils.isExtensionParent(schema)) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)schema.get$ref())) {
            Schema s;
            String parentName = ModelUtils.getSimpleRef(schema.get$ref());
            s = allSchemas.get(parentName);
            if (s != null) {
                return ModelUtils.hasOrInheritsDiscriminator(s, allSchemas, visitedSchemas);
            }
            LOGGER.error("Failed to obtain schema from {}", (Object)parentName);
        } else if (ModelUtils.isComposedSchema(schema)) {
            List<Schema> interfaces = ModelUtils.getInterfaces(schema);
            for (Schema i : interfaces) {
                if (!ModelUtils.hasOrInheritsDiscriminator(i, allSchemas, visitedSchemas)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExtensionParent(Schema schema) {
        if (schema == null || schema.getExtensions() == null) {
            return false;
        }
        Object xParent = schema.getExtensions().get("x-parent");
        if (xParent == null) {
            return false;
        }
        if (xParent instanceof Boolean) {
            return (Boolean)xParent;
        }
        if (xParent instanceof String) {
            return StringUtils.isNotEmpty((CharSequence)((String)xParent));
        }
        return false;
    }

    public static boolean isNullable(Schema schema) {
        if (schema == null) {
            return false;
        }
        if (Boolean.TRUE.equals(schema.getNullable())) {
            return true;
        }
        if (schema.getExtensions() != null && schema.getExtensions().get("x-nullable") != null) {
            return Boolean.parseBoolean(schema.getExtensions().get("x-nullable").toString());
        }
        if (ModelUtils.isComposedSchema(schema)) {
            return ModelUtils.isNullableComposedSchema(schema);
        }
        return false;
    }

    public static boolean isNullableComposedSchema(Schema schema) {
        List oneOf = schema.getOneOf();
        if (oneOf != null && oneOf.size() <= 2) {
            for (Schema s : oneOf) {
                if (!ModelUtils.isNullType(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNullType(Schema schema) {
        return "null".equals(schema.getType());
    }

    public static boolean isAnyType(Schema schema) {
        return schema.get$ref() == null && schema.getType() == null;
    }

    public static void syncValidationProperties(Schema schema, IJsonSchemaValidationProperties target) {
        Boolean exclusiveMaximum;
        Boolean exclusiveMinimum;
        BigDecimal maximum;
        BigDecimal minimum;
        BigDecimal multipleOf;
        String pattern;
        Integer maxLength;
        Integer minLength;
        Integer maxProperties;
        Integer minProperties;
        Boolean uniqueItems;
        Integer maxItems;
        if (schema == null || target == null || schema.get$ref() != null) {
            return;
        }
        SchemaValidations.ValidationSetBuilder vSB = new SchemaValidations.ValidationSetBuilder();
        Integer minItems = schema.getMinItems();
        if (minItems != null) {
            vSB.withMinItems();
        }
        if ((maxItems = schema.getMaxItems()) != null) {
            vSB.withMaxItems();
        }
        if ((uniqueItems = schema.getUniqueItems()) != null) {
            vSB.withUniqueItems();
        }
        if ((minProperties = schema.getMinProperties()) != null) {
            vSB.withMinProperties();
        }
        if ((maxProperties = schema.getMaxProperties()) != null) {
            vSB.withMaxProperties();
        }
        if ((minLength = schema.getMinLength()) != null) {
            vSB.withMinLength();
        }
        if ((maxLength = schema.getMaxLength()) != null) {
            vSB.withMaxLength();
        }
        if ((pattern = schema.getPattern()) != null) {
            vSB.withPattern();
        }
        if ((multipleOf = schema.getMultipleOf()) != null) {
            vSB.withMultipleOf();
        }
        if ((minimum = schema.getMinimum()) != null) {
            vSB.withMinimum();
        }
        if ((maximum = schema.getMaximum()) != null) {
            vSB.withMaximum();
        }
        if ((exclusiveMinimum = schema.getExclusiveMinimum()) != null) {
            vSB.withExclusiveMinimum();
        }
        if ((exclusiveMaximum = schema.getExclusiveMaximum()) != null) {
            vSB.withExclusiveMaximum();
        }
        LinkedHashSet<String> setValidations = vSB.build();
        if (ModelUtils.isBooleanSchema(schema) || ModelUtils.isNullType(schema)) {
            ModelUtils.logWarnMessagesForIneffectiveValidations(setValidations, schema, new HashSet<String>());
        } else if (ModelUtils.isArraySchema(schema)) {
            if (minItems != null || maxItems != null || uniqueItems != null) {
                ModelUtils.setArrayValidations(minItems, maxItems, uniqueItems, target);
            }
            ModelUtils.logWarnMessagesForIneffectiveValidations(new LinkedHashSet<String>(setValidations), schema, SchemaValidations.ARRAY_VALIDATIONS);
        } else if (ModelUtils.isTypeObjectSchema(schema)) {
            if (minProperties != null || maxProperties != null) {
                ModelUtils.setObjectValidations(minProperties, maxProperties, target);
            }
            ModelUtils.logWarnMessagesForIneffectiveValidations(new LinkedHashSet<String>(setValidations), schema, SchemaValidations.OBJECT_VALIDATIONS);
        } else if (ModelUtils.isStringSchema(schema)) {
            if (minLength != null || maxLength != null || pattern != null) {
                ModelUtils.setStringValidations(minLength, maxLength, pattern, target);
            }
            if (ModelUtils.isDecimalSchema(schema)) {
                if (multipleOf != null || minimum != null || maximum != null || exclusiveMinimum != null || exclusiveMaximum != null) {
                    ModelUtils.setNumericValidations(schema, multipleOf, minimum, maximum, exclusiveMinimum, exclusiveMaximum, target);
                }
                HashSet<String> stringAndNumericValidations = new HashSet<String>(SchemaValidations.STRING_VALIDATIONS);
                stringAndNumericValidations.addAll(SchemaValidations.NUMERIC_VALIDATIONS);
                ModelUtils.logWarnMessagesForIneffectiveValidations(new LinkedHashSet<String>(setValidations), schema, stringAndNumericValidations);
            } else {
                ModelUtils.logWarnMessagesForIneffectiveValidations(new LinkedHashSet<String>(setValidations), schema, SchemaValidations.STRING_VALIDATIONS);
            }
        } else if (ModelUtils.isNumberSchema(schema) || ModelUtils.isIntegerSchema(schema)) {
            if (multipleOf != null || minimum != null || maximum != null || exclusiveMinimum != null || exclusiveMaximum != null) {
                ModelUtils.setNumericValidations(schema, multipleOf, minimum, maximum, exclusiveMinimum, exclusiveMaximum, target);
            }
            ModelUtils.logWarnMessagesForIneffectiveValidations(new LinkedHashSet<String>(setValidations), schema, SchemaValidations.NUMERIC_VALIDATIONS);
        } else if (ModelUtils.isAnyType(schema)) {
            ModelUtils.setArrayValidations(minItems, maxItems, uniqueItems, target);
            ModelUtils.setObjectValidations(minProperties, maxProperties, target);
            ModelUtils.setStringValidations(minLength, maxLength, pattern, target);
            ModelUtils.setNumericValidations(schema, multipleOf, minimum, maximum, exclusiveMinimum, exclusiveMaximum, target);
        }
        if (!setValidations.isEmpty()) {
            target.setHasValidation(true);
        }
    }

    private static void setArrayValidations(Integer minItems, Integer maxItems, Boolean uniqueItems, IJsonSchemaValidationProperties target) {
        if (minItems != null) {
            target.setMinItems(minItems);
        }
        if (maxItems != null) {
            target.setMaxItems(maxItems);
        }
        if (uniqueItems != null) {
            target.setUniqueItems(uniqueItems);
        }
        if (uniqueItems != null) {
            target.setUniqueItemsBoolean(uniqueItems);
        }
    }

    private static void setObjectValidations(Integer minProperties, Integer maxProperties, IJsonSchemaValidationProperties target) {
        if (minProperties != null) {
            target.setMinProperties(minProperties);
        }
        if (maxProperties != null) {
            target.setMaxProperties(maxProperties);
        }
    }

    private static void setStringValidations(Integer minLength, Integer maxLength, String pattern, IJsonSchemaValidationProperties target) {
        if (minLength != null) {
            target.setMinLength(minLength);
        }
        if (maxLength != null) {
            target.setMaxLength(maxLength);
        }
        if (pattern != null) {
            target.setPattern(pattern);
        }
    }

    private static void setNumericValidations(Schema schema, BigDecimal multipleOf, BigDecimal minimum, BigDecimal maximum, Boolean exclusiveMinimum, Boolean exclusiveMaximum, IJsonSchemaValidationProperties target) {
        if (multipleOf != null) {
            target.setMultipleOf(multipleOf);
        }
        if (minimum != null) {
            if (ModelUtils.isIntegerSchema(schema)) {
                target.setMinimum(String.valueOf(minimum.longValue()));
            } else {
                target.setMinimum(String.valueOf(minimum));
            }
            if (exclusiveMinimum != null) {
                target.setExclusiveMinimum(exclusiveMinimum);
            }
        }
        if (maximum != null) {
            if (ModelUtils.isIntegerSchema(schema)) {
                target.setMaximum(String.valueOf(maximum.longValue()));
            } else {
                target.setMaximum(String.valueOf(maximum));
            }
            if (exclusiveMaximum != null) {
                target.setExclusiveMaximum(exclusiveMaximum);
            }
        }
    }

    private static void logWarnMessagesForIneffectiveValidations(Set<String> setValidations, Schema schema, Set<String> effectiveValidations) {
        setValidations.removeAll(effectiveValidations);
        setValidations.stream().forEach(validation -> LOGGER.warn("Validation '" + validation + "' has no effect on schema '" + schema.getType() + "'. Ignoring!"));
    }

    private static ObjectMapper getRightMapper(String data) {
        ObjectMapper mapper = data.trim().startsWith("{") ? JSON_MAPPER : YAML_MAPPER;
        return mapper;
    }

    public static JsonNode readWithInfo(String location, List<AuthorizationValue> auths) throws Exception {
        String data;
        if ((location = location.replaceAll("\\\\", "/")).toLowerCase(Locale.ROOT).startsWith("http")) {
            data = RemoteUrl.urlToString((String)location, auths);
        } else {
            String fileScheme = "file:";
            Path path = location.toLowerCase(Locale.ROOT).startsWith("file:") ? java.nio.file.Paths.get(URI.create(location)) : java.nio.file.Paths.get(location, new String[0]);
            data = Files.exists(path, new LinkOption[0]) ? FileUtils.readFileToString((File)path.toFile(), (String)"UTF-8") : ClasspathHelper.loadFileFromClasspath((String)location);
        }
        return ModelUtils.getRightMapper(data).readTree(data);
    }

    public static SemVer getOpenApiVersion(OpenAPI openAPI, String location, List<AuthorizationValue> auths) {
        String version;
        try {
            JsonNode document = ModelUtils.readWithInfo(location, auths);
            JsonNode value = document.findValue("swagger");
            if (value == null) {
                value = document.findValue("openapi");
            }
            version = value.asText();
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to read swagger/openapi attribute");
            version = openAPI.getOpenapi();
        }
        return new SemVer(version);
    }

    public static boolean isAllOf(Schema schema) {
        return !(!ModelUtils.hasAllOf(schema) || schema.getProperties() != null && !schema.getProperties().isEmpty() || schema.getOneOf() != null && !schema.getOneOf().isEmpty() || schema.getAnyOf() != null && !schema.getAnyOf().isEmpty());
    }

    public static boolean hasAllOf(Schema schema) {
        return schema != null && schema.getAllOf() != null && !schema.getAllOf().isEmpty();
    }

    public static boolean isAllOfWithProperties(Schema schema) {
        return !(!ModelUtils.hasAllOf(schema) || schema.getProperties() == null || schema.getProperties().isEmpty() || schema.getOneOf() != null && !schema.getOneOf().isEmpty() || schema.getAnyOf() != null && !schema.getAnyOf().isEmpty());
    }

    public static boolean isOneOf(Schema schema) {
        if (schema == null) {
            return false;
        }
        return !(!ModelUtils.hasOneOf(schema) || schema.getProperties() != null && !schema.getProperties().isEmpty() || schema.getAllOf() != null && !schema.getAllOf().isEmpty() || schema.getAnyOf() != null && !schema.getAnyOf().isEmpty());
    }

    public static boolean hasOneOf(Schema schema) {
        return schema != null && schema.getOneOf() != null && !schema.getOneOf().isEmpty();
    }

    public static boolean isAnyOf(Schema schema) {
        if (schema == null) {
            return false;
        }
        return !(!ModelUtils.hasAnyOf(schema) || schema.getProperties() != null && !schema.getProperties().isEmpty() || schema.getAllOf() != null && !schema.getAllOf().isEmpty() || schema.getOneOf() != null && !schema.getOneOf().isEmpty());
    }

    public static boolean hasAnyOf(Schema schema) {
        return schema != null && schema.getAnyOf() != null && !schema.getAnyOf().isEmpty();
    }

    public static String getType(Schema schema) {
        if (schema == null) {
            return null;
        }
        if (schema instanceof JsonSchema) {
            return String.valueOf(schema.getTypes().iterator().next());
        }
        return schema.getType();
    }

    public static boolean hasCommonAttributesDefined(Schema schema) {
        return schema.getNullable() != null || schema.getDefault() != null || schema.getMinimum() != null || schema.getMaximum() != null || schema.getExclusiveMaximum() != null || schema.getExclusiveMinimum() != null || schema.getMinLength() != null || schema.getMaxLength() != null || schema.getMinItems() != null || schema.getMaxItems() != null || schema.getReadOnly() != null || schema.getWriteOnly() != null || schema.getPattern() != null;
    }

    public static boolean isParent(Schema schema) {
        if (schema != null && schema.getDiscriminator() != null) {
            return true;
        }
        return ModelUtils.isExtensionParent(schema);
    }

    public static Schema cloneSchema(Schema schema, boolean specVersionGreaterThanOrEqualTo310) {
        Schema clone = AnnotationsUtils.clone((Schema)schema, (boolean)specVersionGreaterThanOrEqualTo310);
        if (schema.getType() != null) {
            clone.setType(schema.getType());
        }
        return clone;
    }

    private static final class SchemaValidations {
        public static Set<String> ARRAY_VALIDATIONS = new ValidationSetBuilder().withMinItems().withMaxItems().withUniqueItems().build();
        public static Set<String> OBJECT_VALIDATIONS = new ValidationSetBuilder().withMinProperties().withMaxProperties().build();
        public static Set<String> STRING_VALIDATIONS = new ValidationSetBuilder().withMinLength().withMaxLength().withPattern().build();
        public static Set<String> NUMERIC_VALIDATIONS = new ValidationSetBuilder().withMultipleOf().withMinimum().withMaximum().withExclusiveMinimum().withExclusiveMaximum().build();
        public static Set<String> ALL_VALIDATIONS = new HashSet<String>(ARRAY_VALIDATIONS);

        SchemaValidations() {
        }

        static {
            ALL_VALIDATIONS.addAll(OBJECT_VALIDATIONS);
            ALL_VALIDATIONS.addAll(STRING_VALIDATIONS);
            ALL_VALIDATIONS.addAll(NUMERIC_VALIDATIONS);
        }

        public static class ValidationSetBuilder {
            LinkedHashSet<String> validationSet = new LinkedHashSet();

            ValidationSetBuilder() {
            }

            public ValidationSetBuilder withMinItems() {
                this.validationSet.add("minItems");
                return this;
            }

            public ValidationSetBuilder withMaxItems() {
                this.validationSet.add("maxItems");
                return this;
            }

            public ValidationSetBuilder withUniqueItems() {
                this.validationSet.add("uniqueItems");
                return this;
            }

            public ValidationSetBuilder withMinProperties() {
                this.validationSet.add("minProperties");
                return this;
            }

            public ValidationSetBuilder withMaxProperties() {
                this.validationSet.add("maxProperties");
                return this;
            }

            public ValidationSetBuilder withMinLength() {
                this.validationSet.add("minLength");
                return this;
            }

            public ValidationSetBuilder withMaxLength() {
                this.validationSet.add("maxLength");
                return this;
            }

            public ValidationSetBuilder withPattern() {
                this.validationSet.add("pattern");
                return this;
            }

            public ValidationSetBuilder withMultipleOf() {
                this.validationSet.add("multipleOf");
                return this;
            }

            public ValidationSetBuilder withMinimum() {
                this.validationSet.add("minimum");
                return this;
            }

            public ValidationSetBuilder withMaximum() {
                this.validationSet.add("maximum");
                return this;
            }

            public ValidationSetBuilder withExclusiveMinimum() {
                this.validationSet.add("exclusiveMinimum");
                return this;
            }

            public ValidationSetBuilder withExclusiveMaximum() {
                this.validationSet.add("exclusiveMaximum");
                return this;
            }

            public LinkedHashSet<String> build() {
                return this.validationSet;
            }
        }
    }

    @FunctionalInterface
    private static interface OpenAPISchemaVisitor {
        public void visit(Schema var1, String var2);
    }
}

