/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwiftCombineClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(SwiftCombineClientCodegen.class);
    public static final String PROJECT_NAME = "projectName";
    public static final String MAP_FILE_BINARY_TO_DATA = "mapFileBinaryToData";
    protected String projectName = "OpenAPIClient";
    protected String privateFolder = "Sources/Private";
    protected String sourceFolder = "Sources";
    protected String transportFolder = "OpenAPITransport";
    protected List<String> notCodableTypes = Arrays.asList("Any", "AnyObject", "[String: Any]", "[String: [String: Any]]", "[Any]");
    protected boolean mapFileBinaryToData = true;
    protected boolean anyDecoderWasAdded = false;

    public SwiftCombineClientCodegen() {
        this.supportsMultipleInheritance = true;
        this.useOneOfInterfaces = true;
        this.supportsAdditionalPropertiesWithComposedSchema = true;
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.outputFolder = "generated-code" + File.separator + "swift";
        this.modelTemplateFiles.put("model.mustache", ".swift");
        this.apiTemplateFiles.put("api.mustache", ".swift");
        this.templateDir = "swift-combine";
        this.embeddedTemplateDir = "swift-combine";
        this.apiPackage = File.separator + "APIs";
        this.modelPackage = File.separator + "Models";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Int", "Int32", "Int64", "Float", "Double", "Bool", "Void", "String", "Data", "Date", "Character", "UUID", "URL", "AnyObject", "Any", "[String: Any]", "Decimal"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Data", "Date", "URL", "UUID", "Array", "Dictionary", "Set", "Any", "Empty", "AnyObject", "Decimal"));
        this.reservedWords = new HashSet<String>(Arrays.asList("associatedtype", "class", "deinit", "enum", "extension", "fileprivate", "func", "import", "init", "inout", "internal", "let", "open", "operator", "private", "protocol", "public", "static", "struct", "subscript", "typealias", "var", "break", "case", "continue", "default", "defer", "do", "else", "fallthrough", "for", "guard", "if", "in", "repeat", "return", "switch", "where", "while", "as", "Any", "catch", "false", "is", "nil", "rethrows", "super", "self", "Self", "throw", "throws", "true", "try", "_", "#available", "#colorLiteral", "#column", "#else", "#elseif", "#endif", "#file", "#fileLiteral", "#function", "#if", "#imageLiteral", "#line", "#selector", "#sourceLocation", "associativity", "convenience", "dynamic", "didSet", "final", "get", "infix", "indirect", "lazy", "left", "mutating", "none", "nonmutating", "optional", "override", "postfix", "precedence", "prefix", "Protocol", "required", "right", "set", "Type", "unowned", "weak", "willSet", "Bool", "Int", "Double", "Float", "Range", "ClosedRange", "Error", "Optional", "UInt", "UInt8", "UInt16", "UInt32", "UInt64", "Int8", "Int16", "Int32", "Int64", "Float80", "Float32", "Float64", "String", "Character", "Unicode", "StaticString", "Array", "Dictionary", "Set", "OptionSet", "CountableRange", "CountableClosedRange", "URL", "Data", "Codable", "Encodable", "Decodable", "Result", "Void", "AnyObject", "Class", "dynamicType", "COLUMN", "FILE", "FUNCTION", "LINE"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("Date", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "Character");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("Integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("ByteArray", "Data");
        this.typeMapping.put("UUID", "UUID");
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("decimal", "Decimal");
        this.typeMapping.put("object", "[String: Any]");
        this.typeMapping.put("AnyType", "Any");
        this.typeMapping.put("file", "Data");
        this.typeMapping.put("binary", "Data");
        this.instantiationTypes.put("array", "Array");
        this.instantiationTypes.put("list", "Array");
        this.importMapping = new HashMap();
        this.cliOptions.add(new CliOption(PROJECT_NAME, "Project name in Xcode"));
        this.cliOptions.add(new CliOption("apiNamePrefix", "Prefix that will be appended to all API names ('tags'). Default: empty string. e.g. Pet => Pet."));
        this.cliOptions.add(new CliOption(MAP_FILE_BINARY_TO_DATA, "Map File and Binary to Data (default: true)").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "swift-combine";
    }

    @Override
    public String getHelp() {
        return "Generates a Swift Combine client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.anyDecoderWasAdded = false;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("SWIFT_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable SWIFT_POST_PROCESS_FILE not defined so the Swift code may not be properly formatted. To define it, try 'export SWIFT_POST_PROCESS_FILE=/usr/local/bin/swiftformat' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.setProjectName((String)this.additionalProperties.get(PROJECT_NAME));
        } else {
            this.additionalProperties.put(PROJECT_NAME, this.projectName);
        }
        this.supportingFiles.add(new SupportingFile("Package.mustache", this.projectName, "Package.swift"));
        this.supportingFiles.add(new SupportingFile("OpenAPITransportPackage.mustache", this.transportFolder, "Package.swift"));
        this.supportingFiles.add(new SupportingFile("OpenAPITransport.mustache", this.transportFolder + File.separator + this.sourceFolder, "OpenAPITransport.swift"));
        this.supportingFiles.add(new SupportingFile("OpenISO8601DateFormatter.mustache", this.projectName + File.separator + this.privateFolder, "OpenISO8601DateFormatter.swift"));
        if (this.additionalProperties.containsKey(MAP_FILE_BINARY_TO_DATA)) {
            this.mapFileBinaryToData = this.convertPropertyToBooleanAndWriteBack(MAP_FILE_BINARY_TO_DATA);
        }
        this.additionalProperties.put(MAP_FILE_BINARY_TO_DATA, this.mapFileBinaryToData);
        if (this.mapFileBinaryToData) {
            this.typeMapping.put("file", "Data");
            this.typeMapping.put("binary", "Data");
        } else {
            this.typeMapping.put("file", "URL");
            this.typeMapping.put("binary", "URL");
        }
    }

    @Override
    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.projectName + File.separator + this.sourceFolder + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.projectName + File.separator + this.sourceFolder + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        Schema target;
        Schema schema = ModelUtils.unaliasSchema(this.openAPI, p, this.importMapping);
        Schema schema2 = target = ModelUtils.isGenerateAliasAsModel() ? p : schema;
        if (ModelUtils.isArraySchema(target)) {
            Schema<?> items = ModelUtils.getSchemaItems(schema);
            return ModelUtils.isSet(target) && ModelUtils.isObjectSchema(items) ? "Set<" + this.getTypeDeclaration(items) + ">" : "[" + this.getTypeDeclaration(items) + "]";
        }
        if (ModelUtils.isMapSchema(target)) {
            Schema inner = ModelUtils.getAdditionalProperties(target);
            if (inner == null) {
                this.LOGGER.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
                p.setAdditionalProperties((Object)inner);
            }
            return "[String: " + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isComposedSchema(target)) {
            List<Schema> schemas = ModelUtils.getInterfaces((Schema)((ComposedSchema)target));
            if (schemas.size() == 1) {
                return this.getTypeDeclaration(schemas.get(0));
            }
            super.getTypeDeclaration(target);
        }
        return super.getTypeDeclaration(target);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type) || this.defaultIncludes.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return "URL".equals(dataType);
    }

    @Override
    public boolean isDataTypeBinary(String dataType) {
        return "Data".equals(dataType);
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName((String)name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = (String)name + "_" + this.modelNameSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + (String)name;
        }
        if (this.isReservedWord((String)(name = StringUtils.camelize((String)name)))) {
            String modelName = "Model" + (String)name;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", name, (Object)modelName);
            return modelName;
        }
        if (((String)name).matches("^\\d.*")) {
            String modelName = "Model" + (String)name;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", name, (Object)modelName);
            return modelName;
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getEnum() != null && !p.getEnum().isEmpty() && p.getDefault() != null) {
            return "." + this.toEnumVarName(this.escapeText(String.valueOf(p.getDefault())), p.getType());
        }
        if (p.getDefault() != null) {
            if (ModelUtils.isIntegerSchema(p) || ModelUtils.isNumberSchema(p) || ModelUtils.isBooleanSchema(p)) {
                return p.getDefault().toString();
            }
            if (ModelUtils.isDateTimeSchema(p)) {
                Instant instant = ((OffsetDateTime)p.getDefault()).toInstant();
                long epochMicro = TimeUnit.SECONDS.toMicros(instant.getEpochSecond()) + (long)instant.get(ChronoField.MICRO_OF_SECOND);
                return "Date(timeIntervalSince1970: " + String.valueOf(epochMicro) + ".0 / 1_000_000)";
            }
            if (ModelUtils.isUUIDSchema(p)) {
                return "\"" + this.escapeText(String.valueOf(p.getDefault())) + "\"";
            }
            if (ModelUtils.isStringSchema(p)) {
                return "\"" + this.escapeText(String.valueOf(p.getDefault())) + "\"";
            }
        }
        return null;
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            return this.getSchemaType(ModelUtils.getAdditionalProperties(p));
        }
        if (ModelUtils.isArraySchema(p)) {
            String inner = this.getSchemaType(ModelUtils.getSchemaItems(p));
            return ModelUtils.isSet(p) ? "Set<" + inner + ">" : "[" + inner + "]";
        }
        return null;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultAPI";
        }
        return StringUtils.camelize(this.apiNamePrefix + "_" + name) + "API";
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(operationId = StringUtils.camelize(this.sanitizeName(operationId), CamelizeOption.LOWERCASE_FIRST_LETTER)))) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = StringUtils.camelize("call_" + operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn("{} (starting with a number) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.camelize(this.sanitizeName("call_" + operationId), CamelizeOption.LOWERCASE_FIRST_LETTER));
            operationId = StringUtils.camelize(this.sanitizeName("call_" + operationId), CamelizeOption.LOWERCASE_FIRST_LETTER);
        }
        return operationId;
    }

    @Override
    public String toVarName(String name) {
        if (((String)(name = this.sanitizeName((String)name))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord((String)(name = StringUtils.camelize((String)name, CamelizeOption.LOWERCASE_FIRST_LETTER)))) {
            name = this.escapeReservedWord((String)name);
        }
        if (((String)name).matches("^\\d.*")) {
            name = "_" + (String)name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName((String)name);
        if (((String)(name = ((String)name).replaceAll("-", "_"))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord((String)(name = StringUtils.camelize((String)name, CamelizeOption.LOWERCASE_FIRST_LETTER)))) {
            name = this.escapeReservedWord((String)name);
        }
        if (((String)name).matches("^\\d.*")) {
            name = "_" + (String)name;
        }
        return name;
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema) {
        CodegenModel m = super.fromModel(name, schema);
        m.optionalVars = m.optionalVars.stream().distinct().collect(Collectors.toList());
        Map allVarsMap = m.allVars.stream().collect(Collectors.toMap(CodegenProperty::getBaseName, Function.identity()));
        allVarsMap.keySet().removeAll(m.vars.stream().map(CodegenProperty::getBaseName).collect(Collectors.toSet()));
        allVarsMap.values().forEach(p -> {
            p.isInherited = true;
        });
        Stream.of(m.requiredVars, m.optionalVars).flatMap(Collection::stream).filter(p -> allVarsMap.containsKey(p.baseName)).forEach(p -> {
            p.isInherited = true;
        });
        return m;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("String".equals(datatype) || "[String]".equals(datatype) || "[String: String]".equals(datatype)) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return String.valueOf(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        String nameLowercase;
        if (this.enumNameMapping.containsKey(name)) {
            return (String)this.enumNameMapping.get(name);
        }
        if (name.length() == 0) {
            return "empty";
        }
        Pattern startWithNumberPattern = Pattern.compile("^\\d+");
        Matcher startWithNumberMatcher = startWithNumberPattern.matcher(name);
        if (startWithNumberMatcher.find()) {
            String startingNumbers = startWithNumberMatcher.group(0);
            String nameWithoutStartingNumbers = name.substring(startingNumbers.length());
            return "_" + startingNumbers + StringUtils.camelize(nameWithoutStartingNumbers, CamelizeOption.LOWERCASE_FIRST_LETTER);
        }
        if (this.getSymbolName(name) != null) {
            return StringUtils.camelize(WordUtils.capitalizeFully((String)this.getSymbolName(name).toUpperCase(Locale.ROOT)), CamelizeOption.LOWERCASE_FIRST_LETTER);
        }
        Boolean camelized = false;
        if (name.matches("[A-Z][a-z0-9]+[a-zA-Z0-9]*")) {
            name = StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER);
            camelized = true;
        }
        if (this.isReservedWord(nameLowercase = org.apache.commons.lang3.StringUtils.lowerCase((String)name))) {
            return this.escapeReservedWord(nameLowercase);
        }
        if ("Int".equals(datatype) || "Int32".equals(datatype) || "Int64".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            Object varName = "number" + StringUtils.camelize(name);
            varName = ((String)varName).replaceAll("-", "minus");
            varName = ((String)varName).replaceAll("\\+", "plus");
            varName = ((String)varName).replaceAll("\\.", "dot");
            return varName;
        }
        if (camelized.booleanValue()) {
            return name;
        }
        char[] separators = new char[]{'-', '_', ' ', ':', '(', ')'};
        return StringUtils.camelize(WordUtils.capitalizeFully((String)org.apache.commons.lang3.StringUtils.lowerCase((String)name), (char[])separators).replaceAll("[-_ :\\(\\)]", ""), CamelizeOption.LOWERCASE_FIRST_LETTER);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        if (this.enumNameMapping.containsKey(property.name)) {
            return (String)this.enumNameMapping.get(property.name);
        }
        Object enumName = this.toModelName(property.name);
        if (this.isReservedWord(property.datatypeWithEnum) || this.toVarName(property.name).equals(property.datatypeWithEnum)) {
            enumName = property.datatypeWithEnum + "Enum";
        }
        if (((String)enumName).matches("\\d.*")) {
            return "_" + (String)enumName;
        }
        return enumName;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        ModelsMap postProcessedModelsEnum = this.postProcessModelsEnum(objs);
        List models = (List)postProcessedModelsEnum.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean modelHasPropertyWithEscapedName = false;
            for (CodegenProperty prop : cm.allVars) {
                if (!prop.name.equals(prop.baseName)) {
                    prop.vendorExtensions.put("x-codegen-escaped-property-name", true);
                    modelHasPropertyWithEscapedName = true;
                }
                if (this.notCodableTypes.contains(prop.dataType) || this.notCodableTypes.contains(prop.baseType)) {
                    prop.vendorExtensions.put("x-swift-is-not-codable", true);
                }
                if (!modelHasPropertyWithEscapedName && !this.notCodableTypes.contains(prop.dataType) && !this.notCodableTypes.contains(prop.baseType)) continue;
                cm.vendorExtensions.put("x-swift-contains-not-codable", true);
                this.addAnyDecoderIfNeeded();
            }
            if (!modelHasPropertyWithEscapedName) continue;
            cm.vendorExtensions.put("x-codegen-has-escaped-property-names", true);
        }
        return postProcessedModelsEnum;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String swiftPostProcessFile = System.getenv("SWIFT_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)swiftPostProcessFile)) {
            return;
        }
        if ("swift".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = swiftPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        Map objectMap = (Map)objs.get("operations");
        HashMap<String, CodegenModel> modelMaps = ModelMap.toCodegenModelMap(allModels);
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            operation.allParams.forEach(cp -> this.addVendorExtensions((CodegenParameter)cp, operation, modelMaps));
            operation.queryParams.forEach(cp -> this.addVendorExtensions((CodegenParameter)cp, operation, modelMaps));
            operation.headerParams.forEach(cp -> this.addVendorExtensions((CodegenParameter)cp, operation, modelMaps));
            operation.bodyParams.forEach(cp -> this.addVendorExtensions((CodegenParameter)cp, operation, modelMaps));
            operation.formParams.forEach(cp -> this.addFormVendorExtensions((CodegenParameter)cp, operation, modelMaps));
            if (this.notCodableTypes.contains(operation.returnType) || this.notCodableTypes.contains(operation.returnBaseType)) {
                operation.vendorExtensions.put("x-swift-is-not-codable", true);
                this.addAnyDecoderIfNeeded();
            }
            List<CodegenResponse> responses = operation.responses;
            for (CodegenResponse response : responses) {
                if (response.is4xx || response.is5xx) {
                    response.vendorExtensions.put("x-swift-has-custom-error-type", true);
                    response.vendorExtensions.put("x-swift-custom-error-type", WordUtils.capitalize((String)operation.operationId) + "Error");
                    operation.vendorExtensions.put("x-swift-custom-error-type", WordUtils.capitalize((String)operation.operationId) + "Error");
                }
                response.vendorExtensions.put("x-swift-is-response-code-explicit", !response.code.contains("x"));
            }
        }
        return objs;
    }

    protected void addVendorExtensions(CodegenParameter cp, CodegenOperation operation, HashMap<String, CodegenModel> modelMaps) {
        CodegenModel model = modelMaps.get(cp.dataType);
        cp.vendorExtensions.put("x-swift-use-encoder", cp.isModel);
        if (cp.isArray && cp.items != null) {
            CodegenModel baseModel = modelMaps.get(cp.items.dataType);
            boolean isBaseTypeEnum = cp.items.isEnum || cp.isEnum || baseModel != null && baseModel.isEnum;
            cp.vendorExtensions.put("x-swift-is-base-type-enum", isBaseTypeEnum);
            boolean isBaseTypeUdid = cp.items.isUuid || cp.isUuid;
            cp.vendorExtensions.put("x-swift-is-base-type-udid", isBaseTypeUdid);
            boolean useEncoder = !isBaseTypeEnum && !cp.items.isString || baseModel != null && !baseModel.isString;
            cp.vendorExtensions.put("x-swift-use-encoder", useEncoder);
        }
        if (cp.isEnum || model != null && model.isEnum) {
            cp.vendorExtensions.put("x-swift-is-enum-type", true);
        }
        if (cp.isEnum) {
            String newDataType = WordUtils.capitalize((String)operation.operationId) + WordUtils.capitalize((String)cp.enumName);
            cp.vendorExtensions.put("x-swift-nested-enum-type", newDataType);
            if (cp.isArray) {
                cp.dataType = cp.uniqueItems ? "Set<" + newDataType + ">" : "[" + newDataType + "]";
            } else {
                cp.baseType = cp.dataType;
                cp.dataType = newDataType;
            }
        }
    }

    protected void addFormVendorExtensions(CodegenParameter cp, CodegenOperation operation, HashMap<String, CodegenModel> modelMaps) {
        this.addVendorExtensions(cp, operation, modelMaps);
        if (operation.isMultipart && cp.isArray && cp.items.isFile) {
            cp.vendorExtensions.put("x-swift-enumerate-multipart", true);
        }
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# swift combine generator is contributed by @dydus0x14 and @ptiz.          #");
        System.out.println("################################################################################");
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.SWIFT;
    }

    protected void addAnyDecoderIfNeeded() {
        if (!this.anyDecoderWasAdded) {
            this.supportingFiles.add(new SupportingFile("AnyDecodable.mustache", this.projectName + File.separator + this.privateFolder, "AnyDecodable.swift"));
            this.anyDecoderWasAdded = true;
        }
    }
}

