/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.github.curiousoddman.rgxgen.RgxGen;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenMediaType;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPythonCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractPythonCodegen.class);
    public static final String MAP_NUMBER_TO = "mapNumberTo";
    protected String packageName = "openapi_client";
    protected String packageVersion = "1.0.0";
    protected String projectName;
    protected boolean hasModelsToImport = Boolean.FALSE;
    protected String mapNumberTo = "Union[StrictFloat, StrictInt]";
    protected Map<Character, String> regexModifiers;
    private Map<String, String> schemaKeyToModelNameCache = new HashMap<String, String>();
    private HashMap<String, HashSet<String>> circularImports = new HashMap();
    private HashMap<String, CodegenModel> codegenModelMap = new HashMap();

    public AbstractPythonCodegen() {
        this.modifyFeatureSet(features -> features.securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)));
        this.setReservedWordsLowerCase(Arrays.asList("field", "all_params", "resource_path", "path_params", "query_params", "header_params", "form_params", "local_var_files", "body_params", "auth_settings", "property", "schema", "base64", "json", "date", "float", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self", "nonlocal", "None", "True", "False", "async", "await"));
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("list");
        this.languageSpecificPrimitives.add("dict");
        this.languageSpecificPrimitives.add("List");
        this.languageSpecificPrimitives.add("Dict");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("str");
        this.languageSpecificPrimitives.add("datetime");
        this.languageSpecificPrimitives.add("date");
        this.languageSpecificPrimitives.add("object");
        this.languageSpecificPrimitives.add("file");
        this.languageSpecificPrimitives.add("bytes");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("set", "list");
        this.typeMapping.put("map", "dict");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "str");
        this.typeMapping.put("date", "date");
        this.typeMapping.put("DateTime", "datetime");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("AnyType", "object");
        this.typeMapping.put("file", "file");
        this.typeMapping.put("binary", "str");
        this.typeMapping.put("ByteArray", "str");
        this.typeMapping.put("UUID", "str");
        this.typeMapping.put("URI", "str");
        this.typeMapping.put("null", "none_type");
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IGNORECASE");
        this.regexModifiers.put(Character.valueOf('l'), "LOCALE");
        this.regexModifiers.put(Character.valueOf('m'), "MULTILINE");
        this.regexModifiers.put(Character.valueOf('s'), "DOTALL");
        this.regexModifiers.put(Character.valueOf('u'), "UNICODE");
        this.regexModifiers.put(Character.valueOf('x'), "VERBOSE");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("PYTHON_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable PYTHON_POST_PROCESS_FILE not defined so the Python code may not be properly formatted. To define it, try 'export PYTHON_POST_PROCESS_FILE=\"/usr/local/bin/yapf -i\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                if (!Boolean.valueOf(p.getDefault().toString()).booleanValue()) {
                    return "False";
                }
                return "True";
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p)) {
                String defaultValue;
                if (p.getDefault() != null && (defaultValue = String.valueOf(p.getDefault())) != null) {
                    defaultValue = defaultValue.replace("\\", "\\\\").replace("'", "'");
                    if (Pattern.compile("\r\n|\r|\n").matcher(defaultValue).find()) {
                        return "'''" + defaultValue + "'''";
                    }
                    return "'" + defaultValue + "'";
                }
            } else if (ModelUtils.isArraySchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        name = this.sanitizeName(name);
        if ((name = name.replace("$", "")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase(Locale.ROOT);
        }
        name = StringUtils.underscore(name);
        if (this.isReservedWord(name = name.replaceAll("^_*", "")) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(pattern);
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        if ("callback".equals(name)) {
            return "param_callback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord((String)operationId)) {
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", operationId, (Object)StringUtils.underscore(this.sanitizeName("call_" + (String)operationId)));
            operationId = "call_" + (String)operationId;
        }
        if (((String)operationId).matches("^\\d.*")) {
            this.LOGGER.warn("{} (starting with a number) cannot be used as method name. Renamed to {}", operationId, (Object)StringUtils.underscore(this.sanitizeName("call_" + (String)operationId)));
            operationId = "call_" + (String)operationId;
        }
        return StringUtils.underscore(this.sanitizeName((String)operationId));
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("'''", "'_'_'");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String pythonPostProcessFile = System.getenv("PYTHON_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pythonPostProcessFile)) {
            return;
        }
        if ("py".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = pythonPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String toExampleValue(Schema schema) {
        return this.toExampleValueRecursive(schema, new ArrayList<Schema>(), 5);
    }

    private String toExampleValueRecursive(Schema schema, List<Schema> includedSchemas, int indentation) {
        boolean cycleFound;
        boolean bl = cycleFound = includedSchemas.stream().filter(s -> schema.equals(s)).count() > 1L;
        if (cycleFound) {
            return "";
        }
        Object indentationString = "";
        for (int i = 0; i < indentation; ++i) {
            indentationString = (String)indentationString + "    ";
        }
        Object example = null;
        if (schema.getExample() != null) {
            example = schema.getExample().toString();
        }
        if (ModelUtils.isNullType(schema) && null != example) {
            return "None";
        }
        if (ModelUtils.isBooleanSchema(schema) && null != example) {
            example = "false".equalsIgnoreCase((String)example) ? "False" : "True";
        }
        if (ModelUtils.isStringSchema(schema) && schema.getDefault() != null && !ModelUtils.isDateSchema(schema) && !ModelUtils.isDateTimeSchema(schema)) {
            example = String.valueOf(schema.getDefault());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)example) && !"null".equals(example)) {
            if (ModelUtils.isStringSchema(schema)) {
                example = "'" + (String)example + "'";
            }
            return example;
        }
        if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            example = schema.getEnum().get(0).toString();
            if (ModelUtils.isStringSchema(schema)) {
                example = "'" + this.escapeText((String)example) + "'";
            }
            if (null == example) {
                this.LOGGER.warn("Empty enum. Cannot built an example!");
            }
            return example;
        }
        if (null != schema.get$ref()) {
            Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
            String ref = ModelUtils.getSimpleRef(schema.get$ref());
            if (allDefinitions != null) {
                Schema refSchema = allDefinitions.get(ref);
                if (null == refSchema) {
                    return "None";
                }
                String refTitle = refSchema.getTitle();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)refTitle) || "null".equals(refTitle)) {
                    refSchema.setTitle(ref);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                    includedSchemas.add(schema);
                }
                return this.toExampleValueRecursive(refSchema, includedSchemas, indentation);
            }
            this.LOGGER.warn("allDefinitions not defined in toExampleValue!\n");
        }
        if (ModelUtils.isDateSchema(schema)) {
            example = "datetime.datetime.strptime('1975-12-30', '%Y-%m-%d').date()";
            return example;
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            example = "datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f')";
            return example;
        }
        if (ModelUtils.isBinarySchema(schema)) {
            example = "bytes(b'blah')";
            return example;
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            example = "YQ==";
        } else if (ModelUtils.isStringSchema(schema)) {
            if ("Number".equalsIgnoreCase(schema.getFormat())) {
                return "1";
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getPattern())) {
                String pattern = schema.getPattern();
                RgxGen rgxGen = new RgxGen((CharSequence)this.patternCorrection(pattern));
                Random random = new Random(18L);
                String sample = rgxGen.generate(random);
                Pattern valueExtractor = Pattern.compile("^/\\^?(.+?)\\$?/.?$");
                Matcher m = valueExtractor.matcher(sample);
                example = m.find() ? m.group(m.groupCount()) : sample;
            }
            if (example == null) {
                example = "";
            }
            int len = 0;
            if (null != schema.getMinLength()) {
                len = schema.getMinLength();
                if (len < 1) {
                    example = "";
                } else {
                    for (int i = 0; i < len; ++i) {
                        example = (String)example + i;
                    }
                }
            }
        } else if (ModelUtils.isIntegerSchema(schema)) {
            example = schema.getMinimum() != null ? schema.getMinimum().toString() : "56";
        } else if (ModelUtils.isNumberSchema(schema)) {
            example = schema.getMinimum() != null ? schema.getMinimum().toString() : "1.337";
        } else if (ModelUtils.isBooleanSchema(schema)) {
            example = "True";
        } else if (ModelUtils.isArraySchema(schema)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                includedSchemas.add(schema);
            }
            example = "[\n" + (String)indentationString + this.toExampleValueRecursive(ModelUtils.getSchemaItems(schema), includedSchemas, indentation + 1) + "\n" + (String)indentationString + "]";
        } else if (ModelUtils.isMapSchema(schema)) {
            Object additionalObject;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                includedSchemas.add(schema);
            }
            if ((additionalObject = schema.getAdditionalProperties()) instanceof Schema) {
                Schema additional = (Schema)additionalObject;
                Object theKey = "'key'";
                if (additional.getEnum() != null && !additional.getEnum().isEmpty()) {
                    theKey = additional.getEnum().get(0).toString();
                    if (ModelUtils.isStringSchema(additional)) {
                        theKey = "'" + this.escapeText((String)theKey) + "'";
                    }
                }
                example = "{\n" + (String)indentationString + (String)theKey + " : " + this.toExampleValueRecursive(additional, includedSchemas, indentation + 1) + "\n" + (String)indentationString + "}";
            } else {
                example = "{ }";
            }
        } else if (ModelUtils.isObjectSchema(schema)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)schema.getTitle())) {
                example = "None";
                return example;
            }
            String toExclude = null;
            if (schema.getDiscriminator() != null) {
                toExclude = schema.getDiscriminator().getPropertyName();
            }
            example = this.packageName + ".models." + StringUtils.underscore(schema.getTitle()) + "." + schema.getTitle() + "(";
            ArrayList<String> reqs = new ArrayList<String>();
            if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                for (Object toAdd : schema.getProperties().keySet()) {
                    reqs.add((String)toAdd);
                }
                Map properties = schema.getProperties();
                Set propkeys = null;
                if (properties != null) {
                    propkeys = properties.keySet();
                }
                if (toExclude != null && reqs.contains(toExclude)) {
                    reqs.remove(toExclude);
                }
                for (String toRemove : includedSchemas.stream().map(Schema::getTitle).collect(Collectors.toList())) {
                    if (!reqs.contains(toRemove)) continue;
                    reqs.remove(toRemove);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                    includedSchemas.add(schema);
                }
                if (null != schema.getRequired()) {
                    for (Object toAdd : schema.getRequired()) {
                        reqs.add((String)toAdd);
                    }
                }
                if (null != propkeys) {
                    for (String propname : propkeys) {
                        Schema schema2 = (Schema)properties.get(propname);
                        if (!reqs.contains(propname)) continue;
                        String refTitle = schema2.getTitle();
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)refTitle) || "null".equals(refTitle)) {
                            schema2.setTitle(propname);
                        }
                        example = (String)example + "\n" + (String)indentationString + StringUtils.underscore(propname) + " = " + this.toExampleValueRecursive(schema2, includedSchemas, indentation + 1) + ", ";
                    }
                }
            }
            example = (String)example + ")";
        } else {
            this.LOGGER.debug("Type {} not handled properly in toExampleValue", (Object)schema.getType());
        }
        if (ModelUtils.isStringSchema(schema)) {
            example = "'" + this.escapeText((String)example) + "'";
        }
        return example;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        Object example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equalsIgnoreCase(type) || "str".equalsIgnoreCase(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "'" + this.escapeText((String)example) + "'";
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("file".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "'" + this.escapeText((String)example) + "'";
        } else if ("Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "'" + this.escapeText((String)example) + "'";
        } else if ("DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "'" + this.escapeText((String)example) + "'";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = this.packageName + "." + type + "()";
        } else {
            this.LOGGER.debug("Type {} not handled properly in setParameterExampleValue", (Object)type);
        }
        if (example == null) {
            example = "None";
        } else if (Boolean.TRUE.equals(p.isArray)) {
            example = "[" + (String)example + "]";
        } else if (Boolean.TRUE.equals(p.isMap)) {
            example = "{'key': " + (String)example + "}";
        }
        p.example = example;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        Schema schema = parameter.getSchema();
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
        } else if (parameter.getExamples() != null && !parameter.getExamples().isEmpty()) {
            Example example = (Example)parameter.getExamples().values().iterator().next();
            if (example.getValue() != null) {
                codegenParameter.example = example.getValue().toString();
            }
        } else if (schema != null && schema.getExample() != null) {
            codegenParameter.example = schema.getExample().toString();
        }
        this.setParameterExampleValue(codegenParameter);
    }

    @Override
    public String sanitizeTag(String tag) {
        return this.sanitizeName(tag);
    }

    public String patternCorrection(String pattern) {
        boolean checkEnding;
        boolean bl = checkEnding = pattern.endsWith("/i") || pattern.endsWith("/g") || pattern.endsWith("/m");
        if (checkEnding) {
            pattern = pattern.substring(0, pattern.length() - 2);
        }
        if (pattern.endsWith("/")) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if (pattern.startsWith("/")) {
            pattern = pattern.substring(1);
        }
        return pattern;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.additionalProperties.put("packageName", this.packageName);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p = ModelUtils.unaliasSchema(this.openAPI, p))) {
            Schema<?> inner = ModelUtils.getSchemaItems(p);
            return this.getSchemaType(p) + "[" + this.getCollectionItemTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[str, " + this.getCollectionItemTypeDeclaration(inner) + "]";
        }
        String openAPIType = this.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return openAPIType;
        }
        return this.toModelName(openAPIType);
    }

    private String getCollectionItemTypeDeclaration(Schema inner) {
        Object innerDeclaration = this.getTypeDeclaration(inner);
        if (Boolean.TRUE.equals(inner.getNullable())) {
            innerDeclaration = "Optional[" + (String)innerDeclaration + "]";
        }
        return innerDeclaration;
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (openAPIType == null) {
            this.LOGGER.error("OpenAPI Type for {} is null. Default to UNKNOWN_OPENAPI_TYPE instead.", (Object)p.getName());
            openAPIType = "UNKNOWN_OPENAPI_TYPE";
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (type != null) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String name) {
        String camelizedName;
        if (this.modelNameMapping.containsKey(name)) {
            return (String)this.modelNameMapping.get(name);
        }
        if (this.schemaMapping.containsKey(name)) {
            return (String)this.schemaMapping.get(name);
        }
        String origName = name;
        if (this.schemaKeyToModelNameCache.containsKey(origName)) {
            return this.schemaKeyToModelNameCache.get(origName);
        }
        String sanitizedName = this.sanitizeName(name);
        sanitizedName = sanitizedName.replace("$", "");
        sanitizedName = sanitizedName.replaceAll("\\s+", "");
        Object nameWithPrefixSuffix = sanitizedName;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + (String)nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = (String)nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(camelizedName = StringUtils.camelize((String)nameWithPrefixSuffix))) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)camelizedName, (Object)modelName);
            this.schemaKeyToModelNameCache.put(origName, modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)camelizedName, (Object)modelName);
            this.schemaKeyToModelNameCache.put(origName, modelName);
            return modelName;
        }
        this.schemaKeyToModelNameCache.put(origName, camelizedName);
        return camelizedName;
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(AbstractPythonCodegen.dropDots(this.toModelName(name)));
    }

    @Override
    public String toModelTestFilename(String name) {
        return "test_" + this.toModelFilename(name);
    }

    @Override
    public String toApiFilename(String name) {
        return StringUtils.underscore(this.toApiName(name));
    }

    @Override
    public String toApiTestFilename(String name) {
        return "test_" + this.toApiFilename(name);
    }

    @Override
    public String toApiName(String name) {
        return super.toApiName(name);
    }

    @Override
    public String toApiVarName(String name) {
        return StringUtils.underscore(this.toApiName(name));
    }

    protected static String dropDots(String str) {
        return str.replaceAll("\\.", "_");
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.PYTHON;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> processed = super.postProcessAllModels(objs);
        for (Map.Entry<String, ModelsMap> entry : objs.entrySet()) {
            CodegenModel cm = ModelUtils.getModelByName(entry.getKey(), objs);
            this.codegenModelMap.put(cm.classname, ModelUtils.getModelByName(entry.getKey(), objs));
        }
        for (String string : this.codegenModelMap.keySet()) {
            this.createImportMapOfSet(string, this.codegenModelMap);
        }
        for (Map.Entry entry : processed.entrySet()) {
            entry.setValue(this.postProcessModelsMap((ModelsMap)entry.getValue()));
        }
        return processed;
    }

    private ModelsMap postProcessModelsMap(ModelsMap objs) {
        objs = this.postProcessModelsEnum(objs);
        TreeSet<String> modelImports = new TreeSet<String>();
        TreeSet<String> postponedModelImports = new TreeSet<String>();
        for (ModelMap m : objs.getModels()) {
            TreeSet<CallSite> modelsToImport;
            TreeSet<String> exampleImports = new TreeSet<String>();
            TreeSet<String> postponedExampleImports = new TreeSet<String>();
            ArrayList<String> readOnlyFields = new ArrayList<String>();
            this.hasModelsToImport = false;
            int property_count = 1;
            PythonImports moduleImports = new PythonImports();
            CodegenModel model = m.getModel();
            PydanticType pydantic = new PydanticType(modelImports, exampleImports, postponedModelImports, postponedExampleImports, moduleImports, model.classname);
            if (model.getComposedSchemas() != null && model.getComposedSchemas().getOneOf() != null && !model.getComposedSchemas().getOneOf().isEmpty()) {
                int index = 0;
                Iterator<CodegenProperty> oneOfs = model.getComposedSchemas().getOneOf();
                Iterator<Object> iterator = oneOfs.iterator();
                while (iterator.hasNext()) {
                    CodegenProperty oneOf = iterator.next();
                    if ("none_type".equals(oneOf.dataType)) {
                        oneOfs.remove(index);
                        break;
                    }
                    ++index;
                }
            }
            List<CodegenProperty> codegenProperties = null;
            if (!model.oneOf.isEmpty()) {
                codegenProperties = model.getComposedSchemas().getOneOf();
                moduleImports.add("typing", "Any");
                moduleImports.add("typing", "List");
                moduleImports.add("pydantic", "Field");
                moduleImports.add("pydantic", "StrictStr");
                moduleImports.add("pydantic", "ValidationError");
                moduleImports.add("pydantic", "field_validator");
            } else if (!model.anyOf.isEmpty()) {
                codegenProperties = model.getComposedSchemas().getAnyOf();
                moduleImports.add("pydantic", "Field");
                moduleImports.add("pydantic", "StrictStr");
                moduleImports.add("pydantic", "ValidationError");
                moduleImports.add("pydantic", "field_validator");
            } else {
                codegenProperties = model.vars;
                if (model.getDiscriminator() != null && model.getDiscriminator().getMappedModels() != null) {
                    moduleImports.add("typing", "Union");
                    moduleImports.add("importlib", "import_module");
                }
            }
            if (!model.allOf.isEmpty()) {
                for (CodegenProperty cp : model.allVars) {
                    if (cp.isPrimitiveType && !cp.isModel) continue;
                    if (cp.isArray || cp.isMap) {
                        modelImports.add(cp.items.dataType);
                        continue;
                    }
                    modelImports.add(cp.getDataType());
                }
            }
            if (model.oneOf.isEmpty() && model.anyOf.isEmpty() && !model.isEnum) {
                moduleImports.add("typing", "ClassVar");
                moduleImports.add("typing", "Dict");
                moduleImports.add("typing", "Any");
                if (this.disallowAdditionalPropertiesIfNotPresent || model.isAdditionalPropertiesTrue) {
                    moduleImports.add("typing", "List");
                }
            }
            if (!model.isEnum) {
                moduleImports.add("pydantic", "ConfigDict");
            }
            for (CodegenProperty cp : codegenProperties) {
                if (cp.isReadOnly) {
                    readOnlyFields.add(cp.name);
                }
                String typing = pydantic.generatePythonType(cp);
                cp.vendorExtensions.put("x-py-typing", typing);
                if (!model.oneOf.isEmpty()) {
                    cp.vendorExtensions.put("x-py-name", String.format(Locale.ROOT, "oneof_schema_%d_validator", property_count++));
                    continue;
                }
                if (model.anyOf.isEmpty()) continue;
                cp.vendorExtensions.put("x-py-name", String.format(Locale.ROOT, "anyof_schema_%d_validator", property_count++));
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model.parent)) {
                modelImports.add(model.parent);
            } else if (!model.isEnum) {
                moduleImports.add("pydantic", "BaseModel");
            }
            if (model.isEnum) {
                for (Map enumVars : (List)model.getAllowableValues().get("enumVars")) {
                    if (((Boolean)enumVars.get("isString")).booleanValue()) {
                        model.vendorExtensions.putIfAbsent("x-py-enum-type", "str");
                        enumVars.put("name", this.toEnumVariableName((String)enumVars.get("value"), "str"));
                        continue;
                    }
                    model.vendorExtensions.putIfAbsent("x-py-enum-type", "int");
                    enumVars.put("name", this.toEnumVariableName((String)enumVars.get("value"), "int"));
                }
            }
            model.getVendorExtensions().putIfAbsent("x-py-readonly", readOnlyFields);
            if (!modelImports.isEmpty() && !postponedModelImports.isEmpty()) {
                modelImports.removeAll(postponedModelImports);
            }
            if (!modelImports.isEmpty()) {
                modelsToImport = new TreeSet<CallSite>();
                for (String modelImport : modelImports) {
                    if (modelImport.equals(model.classname)) continue;
                    modelsToImport.add((CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(modelImport) + " import " + modelImport)));
                }
                if (!modelsToImport.isEmpty()) {
                    model.getVendorExtensions().putIfAbsent("x-py-model-imports", modelsToImport);
                }
            }
            if (!moduleImports.isEmpty()) {
                model.getVendorExtensions().putIfAbsent("x-py-other-imports", moduleImports.exports());
            }
            if (postponedModelImports.isEmpty()) continue;
            modelsToImport = new TreeSet();
            for (String modelImport : postponedModelImports) {
                if (modelImport.equals(model.classname)) continue;
                modelsToImport.add((CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(modelImport) + " import " + modelImport)));
            }
            model.getVendorExtensions().putIfAbsent("x-py-postponed-model-imports", modelsToImport);
        }
        return objs;
    }

    private PythonType getPydanticType(CodegenProperty cp, Set<String> modelImports, Set<String> exampleImports, Set<String> postponedModelImports, Set<String> postponedExampleImports, PythonImports moduleImports, String classname) {
        PydanticType pt = new PydanticType(modelImports, exampleImports, postponedModelImports, postponedExampleImports, moduleImports, classname);
        return pt.getType(cp);
    }

    public void setMapNumberTo(String mapNumberTo) {
        if (!("Union[StrictFloat, StrictInt]".equals(mapNumberTo) || "StrictFloat".equals(mapNumberTo) || "float".equals(mapNumberTo))) {
            throw new IllegalArgumentException("mapNumberTo value must be Union[StrictFloat, StrictInt], StrictFloat or float");
        }
        this.mapNumberTo = mapNumberTo;
    }

    public String toEnumVariableName(String name, String datatype) {
        if ("int".equals(datatype)) {
            return "NUMBER_" + ((String)name).replace("-", "MINUS_");
        }
        if (((String)(name = ((String)name).substring(1, ((String)name).length() - 1))).length() == 0) {
            return "EMPTY";
        }
        if (" ".equals(name)) {
            return "SPACE";
        }
        if ("_".equals(name)) {
            return "UNDERSCORE";
        }
        name = this.reservedWords.contains(name) ? ((String)name).toUpperCase(Locale.ROOT) : (name.chars().anyMatch(character -> this.specialCharReplacements.keySet().contains(String.valueOf((char)character))) ? StringUtils.underscore(StringUtils.escape((String)name, this.specialCharReplacements, Collections.singletonList("_"), "_")).toUpperCase(Locale.ROOT) : ((String)name).toUpperCase(Locale.ROOT));
        name = ((String)name).replace(" ", "_");
        name = ((String)name).replaceFirst("^_", "");
        if (((String)(name = ((String)name).replaceFirst("_$", ""))).matches("\\d.*")) {
            name = "ENUM_" + ((String)name).toUpperCase(Locale.ROOT);
        }
        return name;
    }

    void createImportMapOfSet(String modelName, Map<String, CodegenModel> codegenModelMap) {
        HashSet<String> imports = new HashSet<String>();
        this.circularImports.put(modelName, imports);
        CodegenModel cm = codegenModelMap.get(modelName);
        if (cm == null) {
            this.LOGGER.warn("Failed to lookup model in createImportMapOfSet: " + modelName);
            return;
        }
        List<CodegenProperty> codegenProperties = null;
        codegenProperties = cm.oneOf != null && !cm.oneOf.isEmpty() ? cm.getComposedSchemas().getOneOf() : (cm.anyOf != null && !cm.anyOf.isEmpty() ? cm.getComposedSchemas().getAnyOf() : cm.vars);
        for (CodegenProperty cp : codegenProperties) {
            String modelNameFromDataType = this.getModelNameFromDataType(cp);
            if (modelNameFromDataType == null) continue;
            imports.add(modelNameFromDataType);
            this.updateImportsFromCodegenModel(modelNameFromDataType, codegenModelMap.get(modelNameFromDataType), imports);
        }
    }

    private String getModelNameFromDataType(CodegenProperty cp) {
        if (cp.isArray) {
            return this.getModelNameFromDataType(cp.items);
        }
        if (cp.isMap) {
            return this.getModelNameFromDataType(cp.items);
        }
        if (!cp.isPrimitiveType || cp.isModel) {
            return cp.getDataType();
        }
        return null;
    }

    public void updateImportsFromCodegenModel(String modelName, CodegenModel cm, Set<String> imports) {
        if (cm == null) {
            this.LOGGER.warn("Failed to lookup model in createImportMapOfSet " + modelName);
            return;
        }
        List<CodegenProperty> codegenProperties = null;
        codegenProperties = cm.oneOf != null && !cm.oneOf.isEmpty() ? cm.getComposedSchemas().getOneOf() : (cm.anyOf != null && !cm.anyOf.isEmpty() ? cm.getComposedSchemas().getAnyOf() : cm.vars);
        for (CodegenProperty cp : codegenProperties) {
            String modelNameFromDataType = this.getModelNameFromDataType(cp);
            if (modelNameFromDataType == null || modelName.equals(modelNameFromDataType) || imports.contains(modelNameFromDataType)) continue;
            imports.add(modelNameFromDataType);
            this.updateImportsFromCodegenModel(modelNameFromDataType, this.codegenModelMap.get(modelNameFromDataType), imports);
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        HashMap<String, Object> item;
        this.hasModelsToImport = false;
        TreeSet<String> modelImports = new TreeSet<String>();
        TreeSet<String> postponedModelImports = new TreeSet<String>();
        PythonImports moduleImports = new PythonImports();
        OperationMap objectMap = objs.getOperations();
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation operation : operations) {
            ArrayList<CallSite> imports;
            TreeSet<String> exampleImports = new TreeSet<String>();
            TreeSet<String> postponedExampleImports = new TreeSet<String>();
            List<CodegenParameter> params = operation.allParams;
            for (CodegenParameter cp : params) {
                PydanticType pydantic = new PydanticType(modelImports, exampleImports, postponedModelImports, postponedExampleImports, moduleImports, null);
                String typing = pydantic.generatePythonType(cp);
                cp.vendorExtensions.put("x-py-typing", typing);
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operation.returnType)) {
                this.getPydanticType(operation.returnProperty, modelImports, exampleImports, postponedModelImports, postponedExampleImports, moduleImports, null);
            }
            if (!exampleImports.isEmpty()) {
                imports = new ArrayList<CallSite>();
                for (String exampleImport : exampleImports) {
                    imports.add((CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(exampleImport) + " import " + exampleImport)));
                }
                operation.vendorExtensions.put("x-py-example-import", imports);
            }
            if (!postponedExampleImports.isEmpty()) {
                imports = new ArrayList();
                for (String exampleImport : postponedExampleImports) {
                    imports.add((CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(exampleImport) + " import " + exampleImport)));
                }
                operation.vendorExtensions.put("x-py-example-import", imports);
            }
            this.handleConstantParams(operation);
        }
        ArrayList<Map<String, String>> newImports = new ArrayList<Map<String, String>>();
        for (String importLine : moduleImports.exports()) {
            item = new HashMap<String, Object>();
            item.put("import", importLine);
            newImports.add(item);
        }
        if (!modelImports.isEmpty()) {
            for (String modelImport : modelImports) {
                item = new HashMap();
                item.put("import", "from " + this.packageName + ".models." + StringUtils.underscore(modelImport) + " import " + modelImport);
                newImports.add(item);
            }
        }
        if (!postponedModelImports.isEmpty()) {
            for (String modelImport : postponedModelImports) {
                item = new HashMap();
                item.put("import", "from " + this.packageName + ".models." + StringUtils.underscore(modelImport) + " import " + modelImport);
                newImports.add(item);
            }
        }
        objs.setImports(newImports);
        return objs;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        this.postProcessPattern(property.pattern, property.vendorExtensions);
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "\\'");
            ArrayList<String> modifiers = new ArrayList<String>();
            for (char c : pattern.substring(i).toCharArray()) {
                if (!this.regexModifiers.containsKey(Character.valueOf(c))) continue;
                String modifier = this.regexModifiers.get(Character.valueOf(c));
                modifiers.add(modifier);
            }
            vendorExtensions.put("x-regex", regex.replace("\"", "\\\""));
            vendorExtensions.put("x-pattern", pattern.replace("\"", "\\\""));
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    @Override
    public String addRegularExpressionDelimiter(String pattern) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("(?<!\\\\)\\/", "\\\\/") + "/";
        }
        return pattern;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if ("int".equals(datatype) || "float".equals(datatype)) {
            return name;
        }
        return "'" + name + "'";
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return value;
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "str".equals(dataType);
    }

    class PydanticType {
        private Set<String> modelImports;
        private Set<String> exampleImports;
        private Set<String> postponedModelImports;
        private Set<String> postponedExampleImports;
        private PythonImports moduleImports;
        private String classname;

        public PydanticType(Set<String> modelImports, Set<String> exampleImports, Set<String> postponedModelImports, Set<String> postponedExampleImports, PythonImports moduleImports, String classname) {
            this.modelImports = modelImports;
            this.exampleImports = exampleImports;
            this.postponedModelImports = postponedModelImports;
            this.postponedExampleImports = postponedExampleImports;
            this.moduleImports = moduleImports;
            this.classname = classname;
        }

        private PythonType arrayType(IJsonSchemaValidationProperties cp) {
            PythonType pt = new PythonType();
            if (cp.getMaxItems() != null) {
                pt.constrain("max_length", cp.getMaxItems());
            }
            if (cp.getMinItems() != null) {
                pt.constrain("min_length", cp.getMinItems());
            }
            if (cp.getUniqueItems()) {
                pt.setType("List");
                this.moduleImports.add("typing", "List");
            } else {
                pt.setType("List");
                this.moduleImports.add("typing", "List");
            }
            pt.addTypeParam(this.collectionItemType(cp.getItems()));
            return pt;
        }

        private PythonType collectionItemType(CodegenProperty itemCp) {
            PythonType itemPt = this.getType(itemCp);
            if (itemCp != null && !itemPt.type.equals("Any") && itemCp.isNullable) {
                this.moduleImports.add("typing", "Optional");
                PythonType opt = new PythonType("Optional");
                opt.addTypeParam(itemPt);
                itemPt = opt;
            }
            return itemPt;
        }

        private PythonType stringType(IJsonSchemaValidationProperties cp) {
            if (cp.getHasValidation()) {
                PythonType pt = new PythonType("str");
                pt.constrain("strict", true);
                if (cp.getMaxLength() != null) {
                    pt.constrain("max_length", cp.getMaxLength());
                }
                if (cp.getMinLength() != null) {
                    pt.constrain("min_length", cp.getMinLength());
                }
                if (cp.getPattern() != null) {
                    this.moduleImports.add("pydantic", "field_validator");
                }
                return pt;
            }
            if ("password".equals(cp.getFormat())) {
                this.moduleImports.add("pydantic", "SecretStr");
                return new PythonType("SecretStr");
            }
            this.moduleImports.add("pydantic", "StrictStr");
            return new PythonType("StrictStr");
        }

        private PythonType mapType(IJsonSchemaValidationProperties cp) {
            this.moduleImports.add("typing", "Dict");
            PythonType pt = new PythonType("Dict");
            pt.addTypeParam(new PythonType("str"));
            pt.addTypeParam(this.collectionItemType(cp.getItems()));
            return pt;
        }

        private PythonType numberType(IJsonSchemaValidationProperties cp) {
            if (cp.getHasValidation()) {
                PythonType floatt = new PythonType("float");
                PythonType intt = new PythonType("int");
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        floatt.constrain("lt", cp.getMaximum(), false);
                        intt.constrain("lt", (int)Math.ceil(Double.valueOf(cp.getMaximum())));
                    } else {
                        floatt.constrain("le", cp.getMaximum(), false);
                        intt.constrain("le", (int)Math.floor(Double.valueOf(cp.getMaximum())));
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        floatt.constrain("gt", cp.getMinimum(), false);
                        intt.constrain("gt", (int)Math.floor(Double.valueOf(cp.getMinimum())));
                    } else {
                        floatt.constrain("ge", cp.getMinimum(), false);
                        intt.constrain("ge", (int)Math.ceil(Double.valueOf(cp.getMinimum())));
                    }
                }
                if (cp.getMultipleOf() != null) {
                    floatt.constrain("multiple_of", cp.getMultipleOf());
                }
                if ("Union[StrictFloat, StrictInt]".equals(AbstractPythonCodegen.this.mapNumberTo)) {
                    floatt.constrain("strict", true);
                    intt.constrain("strict", true);
                    this.moduleImports.add("typing", "Union");
                    PythonType pt = new PythonType("Union");
                    pt.addTypeParam(floatt);
                    pt.addTypeParam(intt);
                    return pt;
                }
                if ("StrictFloat".equals(AbstractPythonCodegen.this.mapNumberTo)) {
                    floatt.constrain("strict", true);
                    return floatt;
                }
                return floatt;
            }
            if ("Union[StrictFloat, StrictInt]".equals(AbstractPythonCodegen.this.mapNumberTo)) {
                this.moduleImports.add("typing", "Union");
                this.moduleImports.add("pydantic", "StrictFloat");
                this.moduleImports.add("pydantic", "StrictInt");
                PythonType pt = new PythonType("Union");
                pt.addTypeParam(new PythonType("StrictFloat"));
                pt.addTypeParam(new PythonType("StrictInt"));
                return pt;
            }
            if ("StrictFloat".equals(AbstractPythonCodegen.this.mapNumberTo)) {
                this.moduleImports.add("pydantic", "StrictFloat");
                return new PythonType("StrictFloat");
            }
            return new PythonType("float");
        }

        private PythonType intType(IJsonSchemaValidationProperties cp) {
            if (cp.getHasValidation()) {
                PythonType pt = new PythonType("int");
                pt.constrain("strict", true);
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        pt.constrain("lt", cp.getMaximum(), false);
                    } else {
                        pt.constrain("le", cp.getMaximum(), false);
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        pt.constrain("gt", cp.getMinimum(), false);
                    } else {
                        pt.constrain("ge", cp.getMinimum(), false);
                    }
                }
                if (cp.getMultipleOf() != null) {
                    pt.constrain("multiple_of", cp.getMultipleOf());
                }
                return pt;
            }
            this.moduleImports.add("pydantic", "StrictInt");
            return new PythonType("StrictInt");
        }

        private PythonType binaryType(IJsonSchemaValidationProperties cp) {
            if (cp.getHasValidation()) {
                PythonType bytest = new PythonType("bytes");
                PythonType strt = new PythonType("str");
                bytest.constrain("strict", true);
                strt.constrain("strict", true);
                if (cp.getMaxLength() != null) {
                    bytest.constrain("max_length", cp.getMaxLength());
                    strt.constrain("max_length", cp.getMaxLength());
                }
                if (cp.getMinLength() != null) {
                    bytest.constrain("min_length", cp.getMinLength());
                    strt.constrain("min_length", cp.getMinLength());
                }
                if (cp.getPattern() != null) {
                    this.moduleImports.add("pydantic", "field_validator");
                }
                this.moduleImports.add("typing", "Union");
                PythonType pt = new PythonType("Union");
                pt.addTypeParam(bytest);
                pt.addTypeParam(strt);
                return pt;
            }
            this.moduleImports.add("pydantic", "StrictBytes");
            this.moduleImports.add("pydantic", "StrictStr");
            this.moduleImports.add("typing", "Union");
            PythonType pt = new PythonType("Union");
            pt.addTypeParam(new PythonType("StrictBytes"));
            pt.addTypeParam(new PythonType("StrictStr"));
            return pt;
        }

        private PythonType boolType(IJsonSchemaValidationProperties cp) {
            this.moduleImports.add("pydantic", "StrictBool");
            return new PythonType("StrictBool");
        }

        private PythonType decimalType(IJsonSchemaValidationProperties cp) {
            PythonType pt = new PythonType("Decimal");
            this.moduleImports.add("decimal", "Decimal");
            if (cp.getHasValidation()) {
                pt.constrain("strict", true);
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        pt.constrain("gt", cp.getMaximum(), false);
                    } else {
                        pt.constrain("ge", cp.getMaximum(), false);
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        pt.constrain("lt", cp.getMinimum(), false);
                    } else {
                        pt.constrain("le", cp.getMinimum(), false);
                    }
                }
                if (cp.getMultipleOf() != null) {
                    pt.constrain("multiple_of", cp.getMultipleOf());
                }
            }
            return pt;
        }

        private PythonType anyType(IJsonSchemaValidationProperties cp) {
            this.moduleImports.add("typing", "Any");
            return new PythonType("Any");
        }

        private PythonType dateType(IJsonSchemaValidationProperties cp) {
            if (cp.getIsDate()) {
                this.moduleImports.add("datetime", "date");
            }
            if (cp.getIsDateTime()) {
                this.moduleImports.add("datetime", "datetime");
            }
            return new PythonType(cp.getDataType());
        }

        private PythonType uuidType(IJsonSchemaValidationProperties cp) {
            return new PythonType(cp.getDataType());
        }

        private PythonType modelType(IJsonSchemaValidationProperties cp) {
            AbstractPythonCodegen.this.hasModelsToImport = true;
            this.modelImports.add(cp.getDataType());
            this.exampleImports.add(cp.getDataType());
            return new PythonType(cp.getDataType());
        }

        private PythonType fromCommon(IJsonSchemaValidationProperties cp) {
            if (cp == null) {
                AbstractPythonCodegen.this.LOGGER.warn("Codegen property is null (e.g. map/dict of undefined type). Default to typing.Any.");
                this.moduleImports.add("typing", "Any");
                return new PythonType("Any");
            }
            if (cp.getIsEnum()) {
                this.moduleImports.add("pydantic", "field_validator");
            }
            if (cp.getIsArray()) {
                return this.arrayType(cp);
            }
            if (cp.getIsMap() || cp.getIsFreeFormObject()) {
                return this.mapType(cp);
            }
            if (cp.getIsString()) {
                return this.stringType(cp);
            }
            if (cp.getIsNumber() || cp.getIsFloat() || cp.getIsDouble()) {
                return this.numberType(cp);
            }
            if (cp.getIsInteger() || cp.getIsLong() || cp.getIsShort() || cp.getIsUnboundedInteger()) {
                return this.intType(cp);
            }
            if (cp.getIsBinary() || cp.getIsByteArray()) {
                return this.binaryType(cp);
            }
            if (cp.getIsBoolean()) {
                return this.boolType(cp);
            }
            if (cp.getIsDecimal()) {
                return this.decimalType(cp);
            }
            if (cp.getIsAnyType()) {
                return this.anyType(cp);
            }
            if (cp.getIsDate() || cp.getIsDateTime()) {
                return this.dateType(cp);
            }
            if (cp.getIsUuid()) {
                return this.uuidType(cp);
            }
            return null;
        }

        public String generatePythonType(CodegenProperty cp) {
            PythonType pt = this.getType(cp);
            return this.finalizeType(cp, pt);
        }

        private PythonType getType(CodegenProperty cp) {
            PythonType result = this.fromCommon(cp);
            if (result == null) {
                if (!cp.isPrimitiveType || cp.isModel) {
                    if (this.classname == null) {
                        AbstractPythonCodegen.this.hasModelsToImport = true;
                        this.modelImports.add(cp.getDataType());
                        this.exampleImports.add(cp.getDataType());
                    } else if (AbstractPythonCodegen.this.circularImports.containsKey(cp.getDataType())) {
                        if (AbstractPythonCodegen.this.circularImports.get(cp.getDataType()).contains(this.classname)) {
                            AbstractPythonCodegen.this.hasModelsToImport = true;
                            this.postponedModelImports.add(cp.getDataType());
                            this.postponedExampleImports.add(cp.getDataType());
                            AbstractPythonCodegen.this.LOGGER.debug("Skipped importing {} in {} due to circular import.", (Object)cp.getDataType(), (Object)this.classname);
                        } else {
                            AbstractPythonCodegen.this.hasModelsToImport = true;
                            this.modelImports.add(cp.getDataType());
                            this.exampleImports.add(cp.getDataType());
                        }
                    } else {
                        AbstractPythonCodegen.this.LOGGER.error("Failed to look up {} from the imports (map of set) of models.", (Object)cp.getDataType());
                    }
                    result = new PythonType(cp.getDataType());
                } else {
                    throw new RuntimeException("Error! Codegen Property not yet supported in getPydanticType: " + cp);
                }
            }
            return result;
        }

        private String finalizeType(CodegenProperty cp, PythonType pt) {
            if (!cp.required || cp.isNullable) {
                this.moduleImports.add("typing", "Optional");
                PythonType opt = new PythonType("Optional");
                opt.addTypeParam(pt);
                pt = opt;
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cp.description)) {
                pt.annotate("description", cp.description);
            }
            if (cp.baseName != null && !cp.baseName.equals(cp.name)) {
                pt.annotate("alias", cp.baseName);
            }
            if (!cp.required) {
                if (cp.defaultValue == null) {
                    pt.setDefaultValue("None");
                } else if (cp.isArray || cp.isMap) {
                    pt.setDefaultValue("None");
                } else {
                    pt.setDefaultValue(cp.defaultValue);
                }
            }
            String typeConstraint = pt.asTypeConstraint(this.moduleImports);
            String typeValue = pt.asTypeValue(this.moduleImports);
            if (typeValue == null) {
                return typeConstraint;
            }
            return typeConstraint + " = " + typeValue;
        }

        public String generatePythonType(CodegenParameter cp) {
            PythonType pt = this.getType(cp);
            return this.finalizeType(cp, pt);
        }

        private PythonType getType(CodegenParameter cp) {
            PythonType result = this.fromCommon(cp);
            if (result == null) {
                if (!cp.isPrimitiveType) {
                    AbstractPythonCodegen.this.hasModelsToImport = true;
                    this.modelImports.add(cp.getDataType());
                    this.exampleImports.add(cp.getDataType());
                    result = new PythonType(cp.getDataType());
                } else {
                    if (cp.getContent() != null) {
                        LinkedHashMap<String, CodegenMediaType> contents = cp.getContent();
                        for (String key : contents.keySet()) {
                            CodegenMediaType cmt = contents.get(key);
                            if (cmt == null) continue;
                            return AbstractPythonCodegen.this.getPydanticType(cmt.getSchema(), this.modelImports, this.exampleImports, this.postponedModelImports, this.postponedExampleImports, this.moduleImports, this.classname);
                        }
                        throw new RuntimeException("Error! Failed to process getPydanticType when getting the content: " + cp);
                    }
                    throw new RuntimeException("Error! Codegen Parameter not yet supported in getPydanticType: " + cp);
                }
            }
            return result;
        }

        private String finalizeType(CodegenParameter cp, PythonType pt) {
            if (!cp.required || cp.isNullable) {
                this.moduleImports.add("typing", "Optional");
                PythonType opt = new PythonType("Optional");
                opt.addTypeParam(pt);
                pt = opt;
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cp.description)) {
                pt.annotate("description", cp.description);
            }
            return pt.asTypeConstraintWithAnnotations(this.moduleImports);
        }
    }

    class PythonImports {
        private Map<String, Set<String>> imports = new HashMap<String, Set<String>>();

        private void add(String from, String what) {
            Set<String> allImportsFrom = this.imports.get(from);
            if (allImportsFrom == null) {
                allImportsFrom = new TreeSet<String>();
            }
            allImportsFrom.add(what);
            this.imports.put(from, allImportsFrom);
        }

        public Set<String> exports() {
            TreeSet<String> results = new TreeSet<String>();
            for (Map.Entry<String, Set<String>> entry : this.imports.entrySet()) {
                String importLine = String.format(Locale.ROOT, "from %s import %s", entry.getKey(), org.apache.commons.lang3.StringUtils.join((Iterable)entry.getValue(), (String)", "));
                results.add(importLine);
            }
            return results;
        }

        public boolean isEmpty() {
            return this.imports.isEmpty();
        }
    }

    class PythonType {
        private String type;
        private List<PythonType> typeParams;
        private Map<String, Object> annotations;
        private Map<String, Object> constraints;
        private String defaultValue;

        public PythonType() {
            this(null);
        }

        public PythonType(String type) {
            this.setType(type);
            this.defaultValue = null;
            this.typeParams = new ArrayList<PythonType>();
            this.annotations = new HashMap<String, Object>();
            this.constraints = new HashMap<String, Object>();
        }

        public PythonType setType(String type) {
            this.type = type;
            return this;
        }

        public PythonType setDefaultValue(boolean value) {
            this.defaultValue = value ? "True" : "False";
            return this;
        }

        public PythonType setDefaultValue(Object value) {
            this.defaultValue = value.toString();
            return this;
        }

        public PythonType constrain(String name, String value) {
            return this.constrain(name, value, true);
        }

        public PythonType constrain(String name, String value, boolean quote) {
            if (quote) {
                value = "\"" + (String)value + "\"";
            }
            this.constraints.put(name, value);
            return this;
        }

        public PythonType constrain(String name, boolean value) {
            if (value) {
                this.constraints.put(name, "True");
            } else {
                this.constraints.put(name, "False");
            }
            return this;
        }

        public PythonType constrain(String name, Object value) {
            this.constraints.put(name, value);
            return this;
        }

        public PythonType annotate(String name, String value) {
            return this.annotate(name, value, true);
        }

        public PythonType annotate(String name, String value, boolean quote) {
            if (quote) {
                value = "\"" + (String)value + "\"";
            }
            this.annotations.put(name, value);
            return this;
        }

        public PythonType annotate(String name, boolean value) {
            if (value) {
                this.annotations.put(name, "True");
            } else {
                this.annotations.put(name, "False");
            }
            return this;
        }

        public PythonType annotate(String name, Object value) {
            this.annotations.put(name, value);
            return this;
        }

        public PythonType addTypeParam(PythonType typeParam) {
            this.typeParams.add(typeParam);
            return this;
        }

        public String asTypeConstraint(PythonImports imports) {
            return this.asTypeConstraint(imports, false);
        }

        public String asTypeConstraintWithAnnotations(PythonImports imports) {
            return this.asTypeConstraint(imports, true);
        }

        private String asTypeConstraint(PythonImports imports, boolean withAnnotations) {
            String ans;
            Object typeParam = "";
            if (this.typeParams.size() > 0) {
                ArrayList<String> types = new ArrayList<String>();
                for (PythonType t : this.typeParams) {
                    types.add(t.asTypeConstraint(imports));
                }
                typeParam = "[" + org.apache.commons.lang3.StringUtils.join(types, (String)", ") + "]";
            }
            String currentType = this.type + (String)typeParam;
            ArrayList<CallSite> fieldParams = new ArrayList<CallSite>();
            for (Map.Entry<String, Object> entry : this.constraints.entrySet()) {
                ans = entry.getKey() + "=";
                ans = ans + entry.getValue().toString();
                fieldParams.add((CallSite)((Object)ans));
            }
            if (withAnnotations) {
                for (Map.Entry<String, Object> entry : this.annotations.entrySet()) {
                    ans = entry.getKey() + "=";
                    ans = ans + entry.getValue().toString();
                    fieldParams.add((CallSite)((Object)ans));
                }
            }
            if (fieldParams.size() > 0) {
                imports.add("pydantic", "Field");
                imports.add("typing_extensions", "Annotated");
                currentType = "Annotated[" + currentType + ", Field(" + org.apache.commons.lang3.StringUtils.join(fieldParams, (String)", ") + ")]";
            }
            return currentType;
        }

        @Nullable
        public String asTypeValue(PythonImports imports) {
            String defaultValue = this.defaultValue;
            if (this.annotations.size() > 0) {
                Object typeValue = "";
                ArrayList<CallSite> ants = new ArrayList<CallSite>();
                if (defaultValue != null) {
                    ants.add((CallSite)((Object)("default=" + defaultValue)));
                }
                for (Map.Entry<String, Object> entry : this.annotations.entrySet()) {
                    String ans = entry.getKey() + "=";
                    ans = ans + entry.getValue().toString();
                    ants.add((CallSite)((Object)ans));
                }
                imports.add("pydantic", "Field");
                typeValue = "Field(" + org.apache.commons.lang3.StringUtils.join(ants, (String)", ") + ")";
                return typeValue;
            }
            return defaultValue;
        }
    }
}

