/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.java.extension.ObjectModelAnnotation;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.wikitty.generator.WikittyTagValue;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyDTOGenerator
extends ObjectModelTransformerToJava
implements WikittyTagValue {
    private static final Log log = LogFactory.getLog(WikittyDTOGenerator.class);
    protected Map<ObjectModelClass, ObjectModelClass> processedClasses = new HashMap<ObjectModelClass, ObjectModelClass>();
    protected Pattern toStringTagValuePattern = Pattern.compile("\\{(([^|}])*)(?:\\|([^}]*))?\\}");
    protected Map<String, String> attributeToGetterName = new HashMap<String, String>();
    protected List<ObjectModelClass> entitiesWithInheritedOperations = new ArrayList<ObjectModelClass>();

    public void transformFromModel(ObjectModel model) {
        ArrayList<ObjectModelClass> modelBoth = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!WikittyTransformerUtil.isBusinessEntity(clazz) && !WikittyTransformerUtil.isMetaExtension(clazz)) continue;
            log.info((Object)("will treate class " + clazz.getQualifiedName()));
            modelBoth.add(clazz);
        }
        for (ObjectModelClass clazz : modelBoth) {
            ObjectModelClass abstractClass = this.createClass(this.businessEntityToDTOName(clazz), clazz.getPackageName());
            this.processedClasses.put(clazz, abstractClass);
            this.addInterface((ObjectModelClassifier)abstractClass, clazz.getQualifiedName());
        }
        for (ObjectModelClass clazz : modelBoth) {
            if (WikittyTransformerUtil.isMetaExtension(clazz)) {
                this.addMetaExtensionOperations(clazz, this.processedClasses.get(clazz));
                continue;
            }
            if (!WikittyTransformerUtil.isBusinessEntity(clazz)) continue;
            this.addOperations(clazz, this.processedClasses.get(clazz));
        }
        for (ObjectModelClass clazz : modelBoth) {
            if (!WikittyTransformerUtil.isBusinessEntity(clazz)) continue;
            this.addInheritedOperations(clazz, this.processedClasses.get(clazz));
        }
        for (ObjectModelClass clazz : modelBoth) {
            ObjectModelClass abstractClassForThisEntity = this.processedClasses.get(clazz);
            this.addConstructors(abstractClassForThisEntity);
            this.addToString(clazz, abstractClassForThisEntity);
            this.addBusinessEntityMethods(clazz, abstractClassForThisEntity);
            this.addModelOperations(clazz, abstractClassForThisEntity);
        }
        this.processedClasses.clear();
    }

    protected void addSerialVersionUID(ObjectModelClass clazz) {
        Random random = new Random();
        Long serialVersionUIDs = random.nextLong();
        this.addConstant((ObjectModelClassifier)clazz, "serialVersionUID", "long", serialVersionUIDs.toString() + "L", ObjectModelModifier.PRIVATE);
    }

    protected void addConstructors(ObjectModelClass clazz) {
        ObjectModelOperation constructor = this.addConstructor(clazz, ObjectModelModifier.PUBLIC);
        this.setOperationBody(constructor, "\n");
        constructor = this.addConstructor(clazz, ObjectModelModifier.PUBLIC);
        this.addParameter(constructor, "String", "wikittyId");
        this.setOperationBody(constructor, "\n        this.wikittyId=wikittyId;\n");
    }

    protected void addOperations(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            String getterName;
            if (!attribute.isNavigable()) continue;
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeObjectType = WikittyTransformerUtil.generateResultObjectType(attribute, false);
            String attributeName = attribute.getName();
            this.addImport((ObjectModelClassifier)abstractClass, attribute.getType());
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                String attributeTypeCollectionStrict = WikittyTransformerUtil.generateResultType(attribute, true);
                String attributeTypeCollectionGeneric = "Collection<" + attributeType + ">";
                String attributeTypeVarargs = attributeType + "...";
                String attributeObjectTypeCollectionStrict = WikittyTransformerUtil.generateResultObjectType(attribute, true);
                String attributeObjectTypeCollectionGeneric = "Collection<" + attributeObjectType + ">";
                String attributeObjectTypeVarargs = attributeObjectType + "...";
                String attributeTypeCollectionStrictImpl = null;
                String collectionType = WikittyTransformerUtil.getCollectionTypeName(attribute);
                if (Set.class.getSimpleName().equals(collectionType)) {
                    this.addImport((ObjectModelClassifier)abstractClass, Set.class);
                    this.addImport((ObjectModelClassifier)abstractClass, LinkedHashSet.class);
                    attributeTypeCollectionStrictImpl = "LinkedHashSet<String>";
                }
                if (List.class.getSimpleName().equals(collectionType)) {
                    this.addImport((ObjectModelClassifier)abstractClass, List.class);
                    this.addImport((ObjectModelClassifier)abstractClass, ArrayList.class);
                    attributeTypeCollectionStrictImpl = "ArrayList<String>";
                }
                ObjectModelAttribute modelAttribute = this.addAttribute((ObjectModelClassifier)abstractClass, attributeName + " = new " + attributeTypeCollectionStrictImpl + "()", attributeTypeCollectionStrict);
                ObjectModelAnnotation annotation = this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)modelAttribute, "WikittyField");
                this.addAnnotationParameter((ObjectModelClassifier)abstractClass, annotation, "fqn", businessEntity.getName() + "." + attributeName);
                this.addImport((ObjectModelClassifier)abstractClass, "org.nuiton.wikitty.entities.WikittyField");
                getterName = "get" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeTypeCollectionStrict, new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getter, "Override");
                String getterBody = "\n        return " + attributeName + ";\n" + "";
                this.setOperationBody(getter, getterBody);
                getterName = "set" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClass, getterName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setter, "Override");
                this.addParameter(setter, attributeTypeCollectionStrict, attributeName);
                String setterBody = "\n        if (" + attributeName + " == null){\n" + "            this." + attributeName + " = new " + attributeTypeCollectionStrictImpl + "();\n" + "        } else {\n" + "            // make copy to prevent modification of source collection\n" + "            this." + attributeName + "=new " + attributeTypeCollectionStrictImpl + "(" + attributeName + ");\n" + "        }\n" + "        modificationCount++;\n" + "";
                this.setOperationBody(setter, setterBody);
                String addAllName = "addAll" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation addAll = this.addOperation((ObjectModelClassifier)abstractClass, addAllName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)addAll, "Override");
                this.addParameter(addAll, attributeTypeCollectionGeneric, attributeName);
                String addAllBody = "\n        if (this." + attributeName + " == null){\n" + "            this." + attributeName + " = new " + attributeTypeCollectionStrictImpl + "();\n" + "        }\n" + "        this." + attributeName + ".addAll(" + attributeName + ");\n" + "        modificationCount++;\n" + "";
                this.setOperationBody(addAll, addAllBody);
                String addName = "add" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)abstractClass, addName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)adder, "Override");
                this.addParameter(adder, attributeTypeVarargs, "element");
                String adderBody = "\n        if (this." + attributeName + " == null){\n" + "            this." + attributeName + " = new " + attributeTypeCollectionStrictImpl + "();\n" + "        }\n" + "        for (" + attributeType + " v : element) {\n" + "            this." + attributeName + ".add(v);\n" + "        }\n" + "        modificationCount++;\n" + "";
                this.setOperationBody(adder, adderBody);
                String removeName = "remove" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)abstractClass, removeName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)remover, "Override");
                this.addParameter(remover, attributeTypeVarargs, "element");
                String removerBody = "\n        if (this." + attributeName + " != null) {\n" + "            for (" + attributeType + " v : element) {\n" + "                " + attributeName + ".remove(element);\n" + "            }\n" + "            modificationCount++;\n" + "        }\n" + "";
                this.setOperationBody(remover, removerBody);
                String clearName = "clear" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation clear = this.addOperation((ObjectModelClassifier)abstractClass, clearName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)clear, "Override");
                String clearBody = "\n        if (this." + attributeName + " != null) {\n" + "            " + attributeName + ".clear();\n" + "            modificationCount++;\n" + "        }\n" + "";
                this.setOperationBody(clear, clearBody);
                if (attributeObjectType != null) {
                    getterName = "get" + StringUtils.capitalize((String)attributeName);
                    ObjectModelOperation getterObject = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeObjectTypeCollectionStrict, new ObjectModelModifier[0]);
                    this.addParameter(getterObject, "boolean", "exceptionIfNotLoaded");
                    this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getterObject, "Override");
                    String getterObjectBody = "\n        if (exceptionIfNotLoaded) {\n            throw new WikittyException(\"Preload is not implemented in DTO\");\n        } else {\n            return null;\n        }\n";
                    this.setOperationBody(getterObject, getterObjectBody);
                    getterName = "set" + StringUtils.capitalize((String)attributeName);
                    ObjectModelOperation setterObject = this.addOperation((ObjectModelClassifier)abstractClass, getterName + "Entity", "void", new ObjectModelModifier[0]);
                    this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setterObject, "Override");
                    this.addParameter(setterObject, attributeObjectTypeCollectionGeneric, attributeName);
                    String setterObjectBody = "\n        " + attributeTypeCollectionStrictImpl + " tmp = new " + attributeTypeCollectionStrictImpl + "();\n" + "        for (" + attributeObjectType + " e : " + attributeName + ") {\n" + "            tmp.add(e.getWikittyId());\n" + "        }\n" + "        " + getterName + "(tmp);\n" + "";
                    this.setOperationBody(setterObject, setterObjectBody);
                    String addAllNameObject = "addAll" + StringUtils.capitalize((String)attributeName);
                    ObjectModelOperation addAllObject = this.addOperation((ObjectModelClassifier)abstractClass, addAllNameObject + "Entity", "void", new ObjectModelModifier[0]);
                    this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)addAllObject, "Override");
                    this.addParameter(addAllObject, attributeObjectTypeCollectionGeneric, attributeName);
                    String addAllObjectBody = "\n        " + attributeTypeCollectionStrictImpl + " tmp = new " + attributeTypeCollectionStrictImpl + "();\n" + "        for (" + attributeObjectType + " e : " + attributeName + ") {\n" + "            tmp.add(e.getWikittyId());\n" + "        }\n" + "        " + addAllNameObject + "(tmp);\n" + "";
                    this.setOperationBody(addAllObject, addAllObjectBody);
                    String addNameObject = "add" + StringUtils.capitalize((String)attributeName);
                    ObjectModelOperation adderObject = this.addOperation((ObjectModelClassifier)abstractClass, addNameObject, "void", new ObjectModelModifier[0]);
                    this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)adderObject, "Override");
                    this.addParameter(adderObject, attributeObjectTypeVarargs, "element");
                    String adderObjectBody = "\n        String[] tmp = new String[element.length];\n        for (int i=0; i<element.length; i++) {\n            tmp[i] = element[i].getWikittyId();\n        }\n        " + addNameObject + "(tmp);\n" + "";
                    this.setOperationBody(adderObject, adderObjectBody);
                    String removeNameObject = "remove" + StringUtils.capitalize((String)attributeName);
                    ObjectModelOperation removerObject = this.addOperation((ObjectModelClassifier)abstractClass, removeNameObject, "void", new ObjectModelModifier[0]);
                    this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)removerObject, "Override");
                    this.addParameter(removerObject, attributeObjectTypeVarargs, "element");
                    String removerObjectBody = "\n        String[] tmp = new String[element.length];\n        for (int i=0; i<element.length; i++) {\n            tmp[i] = element[i].getWikittyId();\n        }\n        " + removeNameObject + "(tmp);\n" + "";
                    this.setOperationBody(removerObject, removerObjectBody);
                }
            } else {
                this.addImport((ObjectModelClassifier)abstractClass, attribute.getType());
                ObjectModelAttribute modelAttribute = this.addAttribute((ObjectModelClassifier)abstractClass, attributeName, attributeType);
                ObjectModelAnnotation annotation = this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)modelAttribute, "WikittyField");
                this.addAnnotationParameter((ObjectModelClassifier)abstractClass, annotation, "fqn", businessEntity.getName() + "." + attributeName);
                this.addImport((ObjectModelClassifier)abstractClass, "org.nuiton.wikitty.entities.WikittyField");
                getterName = "get" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeType, new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getter, "Override");
                this.setOperationBody(getter, "\n        return " + attributeName + ";\n" + "");
                String setterName = "set" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClass, setterName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setter, "Override");
                this.addParameter(setter, attributeType, attributeName);
                this.setOperationBody(setter, "\n        this." + attributeName + "=" + attributeName + ";\n" + "        modificationCount++;\n" + "");
                if (attributeObjectType != null) {
                    getterName = "get" + StringUtils.capitalize((String)attributeName);
                    ObjectModelOperation getterObject = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeObjectType, new ObjectModelModifier[0]);
                    this.addParameter(getterObject, "boolean", "exceptionIfNotLoaded");
                    this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getterObject, "Override");
                    this.setOperationBody(getterObject, "\n        if (exceptionIfNotLoaded) {\n            throw new WikittyException(\"Preload is not implemented in DTO\");\n        } else {\n            return null;\n        }\n");
                    String setterNameObject = "set" + StringUtils.capitalize((String)attributeName);
                    ObjectModelOperation setterObject = this.addOperation((ObjectModelClassifier)abstractClass, setterNameObject, "void", new ObjectModelModifier[0]);
                    this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setterObject, "Override");
                    this.addParameter(setterObject, attributeObjectType, attributeName);
                    this.setOperationBody(setterObject, "\n        " + setterNameObject + "(" + attributeName + ".getWikittyId());\n" + "");
                }
            }
            this.attributeToGetterName.put(businessEntity.getName() + "." + attributeName, getterName);
        }
    }

    protected void addInheritedOperations(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        for (ObjectModelClass superClass : businessEntity.getSuperclasses()) {
            this.addInheritedOperations(superClass, abstractClass);
            if (!WikittyTransformerUtil.isBusinessEntity(superClass)) continue;
            this.addOperations(superClass, abstractClass);
        }
        this.entitiesWithInheritedOperations.add(businessEntity);
    }

    protected void addToString(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        String toStringOperationBody;
        if (businessEntity.hasTagValue("toString")) {
            String toStringPattern = businessEntity.getTagValue("toString");
            Matcher matcher = this.toStringTagValuePattern.matcher(toStringPattern);
            while (matcher.find()) {
                String wholeMatch = matcher.group(0);
                String variableName = matcher.group(1);
                String defaultValue = matcher.group(3);
                if (defaultValue == null) {
                    defaultValue = "";
                }
                if (this.attributeToGetterName.containsKey(variableName)) {
                    String getterName = this.attributeToGetterName.get(variableName);
                    toStringPattern = toStringPattern.replace(wholeMatch, "\"\n             + " + getterName + "().toString() +\n" + "             \"");
                    continue;
                }
                log.warn((Object)("no field " + variableName + " in " + businessEntity.getQualifiedName()));
                toStringPattern = toStringPattern.replace(wholeMatch, defaultValue);
            }
            toStringOperationBody = "\n        return \"" + toStringPattern + "\";\n" + "";
        } else {
            toStringOperationBody = "\n        return \"dto:\"+getWikittyId()+\":\"+getWikittyVersion();\n";
        }
        ObjectModelOperation toString = this.addOperation((ObjectModelClassifier)abstractClass, "toString", "String", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)toString, "Override");
        this.setOperationBody(toString, toStringOperationBody);
    }

    protected void addMetaExtensionOperations(ObjectModelClass metaExtension, ObjectModelClass abstractClassForThisMetaExtension) {
        this.addOperations(metaExtension, abstractClassForThisMetaExtension);
    }

    protected String businessEntityToDTOName(ObjectModelClass clazz) {
        return clazz.getName() + "DTO";
    }

    protected void addBusinessEntityMethods(ObjectModelClass entity, ObjectModelClass dtoClass) {
        String entityName = entity.getName();
        String dtoClassName = this.businessEntityToDTOName(entity);
        this.addAttribute((ObjectModelClassifier)dtoClass, "wikittyId", "String");
        this.addAttribute((ObjectModelClassifier)dtoClass, "modificationCount = 0", "int");
        ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)dtoClass, "getWikittyId", "String", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getter, "Override");
        this.setOperationBody(getter, "\n        return wikittyId;\n");
        ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)dtoClass, "setWikittyId", "void", new ObjectModelModifier[0]);
        this.addParameter(setter, "String", "wikittyId");
        this.setOperationBody(setter, "\n        this.wikittyId=wikittyId;\n");
        this.addAttribute((ObjectModelClassifier)dtoClass, "wikittyVersion", "String");
        ObjectModelOperation getWikittyVersion = this.addOperation((ObjectModelClassifier)dtoClass, "getWikittyVersion", "String", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getWikittyVersion, "Override");
        this.setOperationBody(getWikittyVersion, "\n        String result = wikittyVersion;\n        if (modificationCount > 0) {\n            result += \".\" + modificationCount;\n        }\n        return result;\n");
        ObjectModelOperation setWikittyVersion = this.addOperation((ObjectModelClassifier)dtoClass, "setWikittyVersion", "void", new ObjectModelModifier[0]);
        this.addParameter(setWikittyVersion, "String", "wikittyVersion");
        this.setOperationBody(setWikittyVersion, "\n        this.wikittyVersion=wikittyVersion;\n        modificationCount=0;\n");
        this.addImport((ObjectModelClassifier)dtoClass, PropertyChangeListener.class);
        this.addImport((ObjectModelClassifier)dtoClass, Collection.class);
        ObjectModelOperation addPropertyChangeListener = this.addOperation((ObjectModelClassifier)dtoClass, "addPropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)addPropertyChangeListener, "Override");
        this.addParameter(addPropertyChangeListener, "PropertyChangeListener", "listener");
        this.setOperationBody(addPropertyChangeListener, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation removePropertyChangeListener = this.addOperation((ObjectModelClassifier)dtoClass, "removePropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)removePropertyChangeListener, "Override");
        this.addParameter(removePropertyChangeListener, "PropertyChangeListener", "listener");
        this.setOperationBody(removePropertyChangeListener, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation addPropertyChangeListener2 = this.addOperation((ObjectModelClassifier)dtoClass, "addPropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)addPropertyChangeListener2, "Override");
        this.addParameter(addPropertyChangeListener2, "String", "property");
        this.addParameter(addPropertyChangeListener2, "PropertyChangeListener", "listener");
        this.setOperationBody(addPropertyChangeListener2, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation removePropertyChangeListener2 = this.addOperation((ObjectModelClassifier)dtoClass, "removePropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)removePropertyChangeListener2, "Override");
        this.addParameter(removePropertyChangeListener2, "String", "property");
        this.addParameter(removePropertyChangeListener2, "PropertyChangeListener", "listener");
        this.setOperationBody(removePropertyChangeListener2, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation getExtensionFields = this.addOperation((ObjectModelClassifier)dtoClass, "getExtensionFields", "Collection<String>", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getExtensionFields, "Override");
        this.addParameter(getExtensionFields, "String", "ext");
        this.setOperationBody(getExtensionFields, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation getExtensionNames = this.addOperation((ObjectModelClassifier)dtoClass, "getExtensionNames", "Collection<String>", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getExtensionNames, "Override");
        this.setOperationBody(getExtensionNames, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation getStaticExtensionNames = this.addOperation((ObjectModelClassifier)dtoClass, "getStaticExtensionNames", "Collection<String>", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getStaticExtensionNames, "Override");
        this.setOperationBody(getStaticExtensionNames, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation getField = this.addOperation((ObjectModelClassifier)dtoClass, "getField", "Object", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getField, "Override");
        this.addParameter(getField, "String", "ext");
        this.addParameter(getField, "String", "fieldName");
        this.setOperationBody(getField, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation getFieldAsObject = this.addOperation((ObjectModelClassifier)dtoClass, "getFieldAsObject", "Object", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getFieldAsObject, "Override");
        this.addParameter(getFieldAsObject, "String", "ext");
        this.addParameter(getFieldAsObject, "String", "fieldName");
        this.setOperationBody(getFieldAsObject, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation setField = this.addOperation((ObjectModelClassifier)dtoClass, "setField", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)setField, "Override");
        this.addParameter(setField, "String", "ext");
        this.addParameter(setField, "String", "fieldName");
        this.addParameter(setField, "Object", "value");
        this.setOperationBody(setField, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation copyFrom = this.addOperation((ObjectModelClassifier)dtoClass, "copyFrom", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)copyFrom, "Override");
        this.addParameter(copyFrom, "BusinessEntity", "source");
        String copyFromBody = "\n        if (!(source instanceof " + entityName + ")){\n" + "            throw new WikittyException(\"Can't copy source object \" + source +\n" + "                    \". They are not of the same type\");\n" + "        }\n" + "\n" + "        " + entityName + " sourceCopy = (" + entityName + ")source;\n" + "";
        copyFromBody = this.addCopyFromAttributes(entity, copyFromBody);
        copyFromBody = copyFromBody + "\n        setWikittyVersion(sourceCopy.getWikittyVersion());\n";
        this.addImport((ObjectModelClassifier)dtoClass, "org.nuiton.wikitty.WikittyException");
        this.addImport((ObjectModelClassifier)dtoClass, "org.nuiton.wikitty.entities.BusinessEntity");
        this.setOperationBody(copyFrom, copyFromBody);
    }

    protected String addCopyFromAttributes(ObjectModelClass businessEntity, String methodBody) {
        for (ObjectModelClass superClass : businessEntity.getSuperclasses()) {
            if (!WikittyTransformerUtil.isBusinessEntity(superClass)) continue;
            methodBody = this.addCopyFromAttributes(superClass, methodBody);
        }
        methodBody = this.copyFromAttributesOfClass(businessEntity, methodBody);
        return methodBody;
    }

    protected String copyFromAttributesOfClass(ObjectModelClass businessEntity, String methodBody) {
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeName = attribute.getName();
            String attributeTypeInSetImpl = null;
            String attributeTypeInSet = null;
            String collectionType = WikittyTransformerUtil.getCollectionTypeName(attribute);
            if (Set.class.getSimpleName().equals(collectionType)) {
                attributeTypeInSet = "Set<String>";
                attributeTypeInSetImpl = "LinkedHashSet<String>";
            }
            if (List.class.getSimpleName().equals(collectionType)) {
                attributeTypeInSet = "List<String>";
                attributeTypeInSetImpl = "ArrayList<String>";
            }
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            String capitalizedAttributeName = StringUtils.capitalize((String)attributeName);
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                methodBody = methodBody + "\n        " + attributeTypeInSet + " " + attributeName + " = sourceCopy.get" + capitalizedAttributeName + "();\n" + "        if (" + attributeName + " != null){\n" + "            set" + capitalizedAttributeName + "(new " + attributeTypeInSetImpl + "(" + attributeName + "));\n" + "        }\n" + "";
                continue;
            }
            methodBody = methodBody + "\n        set" + capitalizedAttributeName + "(sourceCopy.get" + capitalizedAttributeName + "());\n" + "";
        }
        return methodBody;
    }

    protected void addModelOperations(ObjectModelClass businessEntity, ObjectModelClass dtoClass) {
        Collection operations = businessEntity.getOperations();
        for (ObjectModelOperation operation : operations) {
            ObjectModelOperation dtoOperation = this.addOperation((ObjectModelClassifier)dtoClass, operation.getName(), operation.getReturnType(), new ObjectModelModifier[0]);
            Collection parameters = operation.getParameters();
            for (ObjectModelParameter parameter : parameters) {
                this.addParameter(dtoOperation, parameter.getType(), parameter.getName());
            }
            this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)dtoOperation, "Override");
            this.setOperationBody(dtoOperation, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        }
    }
}

