/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons.importexport;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.importexport.ImportExportMethod;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.PagedResult;

public class ImportExportCSV
implements ImportExportMethod {
    private static Log log = LogFactory.getLog(ImportExportCSV.class);
    protected static final String FIELD_WIKITTY_ID = "Wikitty.Id";
    protected static final String FIELD_WIKITTY_EXT = "Wikitty.Ext";
    protected Pattern queryPattern = Pattern.compile("^((\\w+)\\.(\\w+))=(\"(.+)\"|([^\"]+))$");

    @Override
    public void importReader(WikittyClient client, Reader reader) throws Exception {
        String[] currentLine;
        int wikittyIdIndex = -1;
        int wikittyExtIndex = -1;
        CSVReader csvReader = new CSVReader(reader);
        String[] header = csvReader.readNext();
        String[] ext = new String[header.length];
        String[] fieldsName = new String[header.length];
        for (int i = 0; i < header.length; ++i) {
            if (FIELD_WIKITTY_ID.equalsIgnoreCase(header[i])) {
                wikittyIdIndex = i;
                continue;
            }
            if (FIELD_WIKITTY_EXT.equalsIgnoreCase(header[i])) {
                wikittyExtIndex = i;
                continue;
            }
            ext[i] = header[i].substring(0, header[i].indexOf("."));
            fieldsName[i] = header[i].substring(header[i].indexOf(".") + 1);
        }
        while ((currentLine = csvReader.readNext()) != null) {
            String extensionList;
            String wikittyId;
            if (currentLine.length == 1) continue;
            WikittyImpl currentWikitty = null;
            if (wikittyIdIndex != -1 && StringUtils.isNotBlank((CharSequence)(wikittyId = currentLine[wikittyIdIndex]))) {
                currentWikitty = new WikittyImpl(wikittyId);
            }
            if (currentWikitty == null) {
                currentWikitty = new WikittyImpl();
            }
            if (wikittyExtIndex != -1 && StringUtils.isNotBlank((CharSequence)(extensionList = currentLine[wikittyExtIndex]))) {
                String[] extensions;
                for (String extension : extensions = extensionList.split(",")) {
                    String extName = extension.trim();
                    this.addMissingExtension(client, currentWikitty, extName);
                }
            }
            for (int i = 0; i < header.length; ++i) {
                if (i == wikittyIdIndex || i == wikittyExtIndex) continue;
                String extName = ext[i];
                String fieldName = fieldsName[i];
                String value = currentLine[i];
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                this.addMissingExtension(client, currentWikitty, extName);
                value = this.convertLinkValues(client, value);
                FieldType fieldType = currentWikitty.getFieldType(extName + "." + fieldName);
                if (fieldType.isCollection()) {
                    String[] multiplesValues;
                    for (String multiplesValue : multiplesValues = StringUtil.split((String)value)) {
                        if (multiplesValue.startsWith("(") && multiplesValue.endsWith(")")) {
                            multiplesValue = multiplesValue.substring(1, multiplesValue.length() - 1);
                        }
                        if (fieldType.getType().equals((Object)WikittyTypes.WIKITTY)) {
                            Wikitty wikitty = client.restore(multiplesValue, new String[0]);
                            if (wikitty == null) continue;
                            currentWikitty.addToField(extName, fieldName, multiplesValue);
                            continue;
                        }
                        Object v = WikittyUtil.fromStringForExport(fieldType, multiplesValue);
                        currentWikitty.addToField(extName, fieldName, v);
                    }
                    continue;
                }
                if (fieldType.getType().equals((Object)WikittyTypes.WIKITTY)) {
                    Wikitty wikitty = client.restore(value, new String[0]);
                    if (wikitty == null) continue;
                    currentWikitty.setField(extName, fieldName, value);
                    continue;
                }
                Object v = WikittyUtil.fromStringForExport(fieldType, value);
                currentWikitty.setField(extName, fieldName, v);
            }
            client.getWikittyService().store(client.getSecurityToken(), Collections.singleton(currentWikitty), true);
        }
    }

    @Override
    public void importReader(String securityToken, Reader reader, WikittyService ws) throws Exception {
        WikittyClient client = new WikittyClient(null, ws, securityToken);
        this.importReader(client, reader);
    }

    protected void addMissingExtension(WikittyClient client, Wikitty currentWikitty, String extName) {
        if (!currentWikitty.hasExtension(extName)) {
            WikittyExtension extension = client.restoreExtensionLastVersion(extName);
            if (extension != null) {
                List<String> requires = extension.getRequires();
                if (requires != null && !requires.isEmpty()) {
                    for (String require : requires) {
                        String localRequire = require.trim();
                        this.addMissingExtension(client, currentWikitty, localRequire);
                    }
                }
                currentWikitty.addExtension(extension);
            } else {
                throw new WikittyException("Extension " + extName + " does not exist");
            }
        }
    }

    protected String convertLinkValues(WikittyClient client, String value) {
        boolean correctQueries;
        String resultValue;
        String originalValue;
        block7: {
            originalValue = value;
            resultValue = "";
            String separator = "";
            correctQueries = true;
            try {
                String[] queries;
                for (String queryString : queries = StringUtil.split((String)value, (String)",")) {
                    Matcher m = this.queryPattern.matcher(queryString.trim());
                    if (m.find()) {
                        WikittyQuery query;
                        Wikitty wikitty;
                        String fqField = m.group(1);
                        String fValue = m.group(5);
                        if (fValue == null) {
                            fValue = m.group(6);
                        }
                        if ((wikitty = client.findByQuery(Wikitty.class, query = ((WikittyQueryMaker)new WikittyQueryMaker().eq(fqField, (Object)fValue)).end())) == null) {
                            correctQueries = false;
                            continue;
                        }
                        resultValue = resultValue + separator + wikitty.getWikittyId();
                        separator = ",";
                        continue;
                    }
                    correctQueries = false;
                }
            }
            catch (StringIndexOutOfBoundsException eee) {
                if (!log.isTraceEnabled()) break block7;
                log.trace((Object)"Can't split field on , skipping");
            }
        }
        if (!correctQueries || StringUtils.isEmpty((CharSequence)resultValue)) {
            resultValue = originalValue;
        }
        return resultValue;
    }

    @Override
    public void exportWriter(WikittyClient client, Writer writer, WikittyQueryResult<Wikitty> pagedResult) throws Exception {
        CSVWriter csvWriter = new CSVWriter(writer);
        LinkedList<String> extensionHeader = new LinkedList<String>();
        extensionHeader.add(FIELD_WIKITTY_ID);
        extensionHeader.add(FIELD_WIKITTY_EXT);
        for (org.nuiton.wikitty.query.FacetTopic topic : pagedResult.getTopic(Element.EXTENSION)) {
            String extName = topic.getTopicName();
            WikittyExtension extension = client.restoreExtensionLastVersion(extName);
            String ext = WikittyExtension.computeName(extName);
            for (String fieldName : extension.getFieldNames()) {
                extensionHeader.add(ext + "." + fieldName);
            }
        }
        csvWriter.writeNext(extensionHeader.toArray(new String[extensionHeader.size()]));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting wikitty : " + pagedResult.getAll().size() + " results"));
        }
        List<Wikitty> wikitties = pagedResult.getAll();
        for (Wikitty w : wikitties) {
            String extNames;
            String[] wikittyField = new String[extensionHeader.size()];
            wikittyField[extensionHeader.indexOf((Object)FIELD_WIKITTY_ID)] = w.getWikittyId();
            Collection<String> extNamesCollection = w.getExtensionNames();
            wikittyField[extensionHeader.indexOf((Object)FIELD_WIKITTY_EXT)] = extNames = StringUtils.join(extNamesCollection, (char)',');
            for (String fieldName : w.fieldNames()) {
                String currentField = "";
                FieldType type = w.getFieldType(fieldName);
                if (type.isCollection()) {
                    Object fqField = w.getFqField(fieldName);
                    if (fqField != null) {
                        String separator = "";
                        for (Object o : (Collection)fqField) {
                            String fqFieldValue = WikittyUtil.toStringForExport(type, o);
                            currentField = currentField + separator + "(" + fqFieldValue + ")";
                            separator = ",";
                        }
                    }
                } else {
                    String fqFieldValue;
                    currentField = fqFieldValue = WikittyUtil.toStringForExport(type, w.getFqField(fieldName));
                }
                wikittyField[extensionHeader.indexOf((Object)fieldName)] = currentField;
            }
            csvWriter.writeNext(wikittyField);
        }
        csvWriter.close();
    }

    @Override
    public void exportWriter(String securityToken, Writer writer, WikittyService ws, PagedResult<Wikitty> pagedResult) throws Exception {
        WikittyClient client = new WikittyClient(null, ws, securityToken);
        HashMap<String, List<org.nuiton.wikitty.query.FacetTopic>> facet = new HashMap<String, List<org.nuiton.wikitty.query.FacetTopic>>();
        for (Map.Entry<String, List<FacetTopic>> e : pagedResult.getFacets().entrySet()) {
            String facetName = e.getKey();
            ArrayList<org.nuiton.wikitty.query.FacetTopic> topics = new ArrayList<org.nuiton.wikitty.query.FacetTopic>();
            if (org.nuiton.wikitty.search.operators.Element.ELT_EXTENSION.equals(facetName)) {
                facet.put(Element.EXTENSION.getValue(), topics);
            } else {
                facet.put(facetName, topics);
            }
            for (FacetTopic f : e.getValue()) {
                topics.add(new org.nuiton.wikitty.query.FacetTopic(f.getFacetName(), f.getTopicName(), f.getCount()));
            }
        }
        WikittyQueryResult<Wikitty> queryResult = new WikittyQueryResult<Wikitty>(pagedResult.getCriteriaName(), pagedResult.getFirstIndice(), pagedResult.getNumFound(), pagedResult.getQueryString(), facet, pagedResult.getAll(), 0L, 0L);
        this.exportWriter(client, writer, queryResult);
    }
}

