/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.ElementField;
import org.nuiton.wikitty.query.FacetQuery;
import org.nuiton.wikitty.query.FacetSortType;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.WikittyQueryVisitorCopy;
import org.nuiton.wikitty.query.WikittyQueryVisitorToString;
import org.nuiton.wikitty.query.conditions.Condition;

public class WikittyQuery
implements Serializable {
    private static Log log = LogFactory.getLog(WikittyQuery.class);
    private static final long serialVersionUID = 1L;
    public static final int MAX = Integer.MAX_VALUE;
    protected String name;
    protected Condition condition;
    protected int offset = 0;
    protected int limit = 100;
    protected int facetMinCount = 1;
    protected int facetLimit = 100;
    protected FacetSortType facetSort = FacetSortType.count;
    protected List<FacetQuery> facetQuery;
    protected List<Element> facetField;
    protected boolean facetExtension = false;
    protected List<Element> sortAscending;
    protected List<Element> sortDescending;
    protected int wikittyFieldSearchDepth = 0;

    public WikittyQuery() {
    }

    public WikittyQuery(Condition condition) {
        this.setCondition(condition);
    }

    public WikittyQuery copy() {
        WikittyQueryVisitorCopy v = new WikittyQueryVisitorCopy();
        this.accept(v);
        return v.getQuery();
    }

    public String toString() {
        WikittyQueryVisitorToString v = new WikittyQueryVisitorToString();
        this.accept(v);
        String result = v.getText();
        return result;
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == null) {
            result = false;
        } else if (ObjectUtils.equals(this.getClass(), o.getClass())) {
            WikittyQuery other = (WikittyQuery)o;
            result = ObjectUtils.equals((Object)this.getName(), (Object)other.getName()) && ObjectUtils.equals((Object)this.getOffset(), (Object)other.getOffset()) && ObjectUtils.equals((Object)this.getLimit(), (Object)other.getLimit()) && ObjectUtils.equals((Object)this.isFacetExtension(), (Object)other.isFacetExtension()) && ObjectUtils.equals(this.getFacetField(), other.getFacetField()) && ObjectUtils.equals(this.getSortAscending(), other.getSortAscending()) && ObjectUtils.equals(this.getSortDescending(), other.getSortDescending()) && ObjectUtils.equals((Object)this.getFacetLimit(), (Object)other.getFacetLimit()) && ObjectUtils.equals((Object)((Object)this.getFacetSort()), (Object)((Object)other.getFacetSort())) && ObjectUtils.equals((Object)this.getFacetMinCount(), (Object)other.getFacetMinCount()) && ObjectUtils.equals(this.getFacetQuery(), other.getFacetQuery()) && ObjectUtils.equals((Object)this.getCondition(), (Object)other.getCondition()) && ObjectUtils.equals((Object)this.getWikittyFieldSearchDepth(), (Object)other.getWikittyFieldSearchDepth());
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        return result;
    }

    public WikittyQuery(String name) {
        this.name = name;
    }

    public WikittyQuery(String name, Condition condition) {
        this.name = name;
        this.setCondition(condition);
    }

    public void accept(WikittyQueryVisitor visitor) {
        boolean walk = visitor.visitEnter(this);
        if (walk && this.condition != null) {
            this.condition.accept(visitor);
        }
        visitor.visitLeave(this, walk);
    }

    public String getName() {
        return this.name;
    }

    public WikittyQuery setName(String name) {
        this.name = name;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public WikittyQuery setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    @Deprecated
    public int getFirst() {
        return this.offset;
    }

    @Deprecated
    public WikittyQuery setFirst(int first) {
        this.offset = first;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public WikittyQuery setLimit(int count) {
        if (count < 0) {
            count = Integer.MAX_VALUE;
        }
        this.limit = count;
        return this;
    }

    public int getFacetMinCount() {
        return this.facetMinCount;
    }

    public WikittyQuery setFacetMinCount(int facetMinCount) {
        this.facetMinCount = facetMinCount;
        return this;
    }

    public int getFacetLimit() {
        return this.facetLimit;
    }

    public WikittyQuery setFacetLimit(int facetLimit) {
        this.facetLimit = facetLimit;
        return this;
    }

    public void setFacetSort(FacetSortType facetSort) {
        this.facetSort = facetSort;
    }

    public FacetSortType getFacetSort() {
        return this.facetSort;
    }

    public List<FacetQuery> getFacetQuery() {
        if (this.facetQuery == null) {
            this.facetQuery = new LinkedList<FacetQuery>();
        }
        return this.facetQuery;
    }

    public WikittyQuery addFacetQuery(FacetQuery facetQuery) {
        this.getFacetQuery().add(facetQuery);
        return this;
    }

    public WikittyQuery addFacetQuery(String name, Condition condition) {
        this.getFacetQuery().add(new FacetQuery(name, condition));
        return this;
    }

    public WikittyQuery setFacetQuery(FacetQuery ... facetQuery) {
        this.facetQuery = new LinkedList<FacetQuery>(Arrays.asList(facetQuery));
        return this;
    }

    public List<Element> getFacetField() {
        if (this.facetField == null) {
            this.facetField = new LinkedList<Element>();
        }
        return this.facetField;
    }

    public WikittyQuery addFacetField(Element field) {
        this.getFacetField().add(field);
        return this;
    }

    public WikittyQuery setFacetField(Element ... facetField) {
        this.facetField = new LinkedList<Element>(Arrays.asList(facetField));
        return this;
    }

    public WikittyQuery setFacetField(List<Element> facetField) {
        this.facetField = facetField;
        return this;
    }

    public boolean isFacetExtension() {
        return this.facetExtension;
    }

    public WikittyQuery setFacetExtension(boolean facetExtension) {
        this.facetExtension = facetExtension;
        return this;
    }

    public List<Element> getSortAscending() {
        if (this.sortAscending == null) {
            this.sortAscending = new LinkedList<Element>();
        }
        return this.sortAscending;
    }

    public WikittyQuery addSortAscending(ElementField ... field) {
        this.getSortAscending().addAll(Arrays.asList(field));
        return this;
    }

    public WikittyQuery setSortAscending(Element ... sortAscending) {
        this.sortAscending = new LinkedList<Element>(Arrays.asList(sortAscending));
        return this;
    }

    public WikittyQuery setSortAscending(List<Element> sortAscending) {
        this.sortAscending = sortAscending;
        return this;
    }

    public List<Element> getSortDescending() {
        if (this.sortDescending == null) {
            this.sortDescending = new LinkedList<Element>();
        }
        return this.sortDescending;
    }

    public WikittyQuery addSortDescending(Element ... field) {
        this.getSortDescending().addAll(Arrays.asList(field));
        return this;
    }

    public WikittyQuery setSortDescending(Element ... sortDescending) {
        this.sortDescending = new LinkedList<Element>(Arrays.asList(sortDescending));
        return this;
    }

    public WikittyQuery setSortDescending(List<Element> sortDescending) {
        this.sortDescending = sortDescending;
        return this;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public WikittyQuery setCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public int getWikittyFieldSearchDepth() {
        return this.wikittyFieldSearchDepth;
    }

    public WikittyQuery setWikittyFieldSearchDepth(int wikittyFieldSearchDepth) {
        this.wikittyFieldSearchDepth = wikittyFieldSearchDepth;
        return this;
    }
}

