/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.ScriptEvaluator;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyHookHelper;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyServiceDelegator;

public class WikittyServiceHook
extends WikittyServiceDelegator {
    private static Log log = LogFactory.getLog(WikittyServiceHook.class);
    public static final String PRE_STORE = "pre-store";
    public static final String POST_STORE = "post-store";
    public static final String PRE_STORE_EXTENSION = "pre-storeExtension";
    public static final String POST_STORE_EXTENSION = "post-storeExtension";
    public static final String PRE_DELETE = "pre-delete";
    public static final String POST_DELETE = "post-delete";
    public static final String PRE_DELETE_EXTENSION = "pre-deleteExtension";
    public static final String POST_DELETE_EXTENSION = "post-deleteExtension";
    public static final String PRE_DELETE_TREE = "pre-deleteTree";
    public static final String POST_DELETE_TREE = "post-deleteTree";
    public static final String PRE_CLEAR = "pre-clear";
    public static final String POST_CLEAR = "post-clear";
    public static final String PRE_LOGIN = "pre-login";
    public static final String POST_LOGIN = "post-login";
    public static final String PRE_LOGOUT = "pre-logout";
    public static final String POST_LOGOUT = "post-logout";
    public static final String PRE_REPLAY = "pre-replay";
    public static final String POST_REPLAY = "post-replay";
    public static final String PRE_SYNC_SEARCH_ENGINE = "pre-syncSearchEngine";
    public static final String POST_SYNC_SEARCH_ENGINE = "post-syncSearchEngine";

    public WikittyServiceHook(ApplicationConfig config, WikittyService ws) {
        super(ws);
    }

    protected Collection<Wikitty> getHook(String securityToken, String actionName) {
        WikittyQuery query = new WikittyQueryMaker().and().exteq("WikittyHook").eq("WikittyHook.actionToHook", (Object)actionName).end();
        WikittyQueryResult<String> ids = this.getDelegate().findAllByQuery(securityToken, Collections.singletonList(query)).get(0);
        List<Wikitty> result = this.getDelegate().restore(securityToken, ids.getAll());
        return result;
    }

    protected Map<String, Object> callHook(String securityToken, String actionName, Map<String, Object> args, WikittyEvent event) {
        Collection<Wikitty> hooks = this.getHook(securityToken, actionName);
        WikittyService ws = this.getDelegate();
        args.put("actionName", actionName);
        args.put("ws", ws);
        args.put("event", event);
        for (Wikitty hook : hooks) {
            String hookName = WikittyHookHelper.getName(hook);
            String mimetype = WikittyHookHelper.getMimetype(hook);
            String script = WikittyHookHelper.getScript(hook);
            args.put("hook", hook);
            args = ScriptEvaluator.exec(null, hookName, script, mimetype, args);
        }
        return args;
    }

    @Override
    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        Map<String, Object> args = new HashMap<String, Object>();
        args.put("securityToken", securityToken);
        args.put("wikitties", wikitties);
        args.put("force", force);
        args = this.callHook(securityToken, PRE_STORE, args, null);
        securityToken = (String)args.get("securityToken");
        wikitties = (Collection)args.get("wikitties");
        force = (Boolean)args.get("force");
        WikittyEvent result = super.store(securityToken, wikitties, force);
        this.callHook(securityToken, POST_STORE, args, result);
        return result;
    }

    @Override
    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        Map<String, Object> args = new HashMap<String, Object>();
        args.put("securityToken", securityToken);
        args.put("exts", exts);
        args = this.callHook(securityToken, PRE_STORE_EXTENSION, args, null);
        securityToken = (String)args.get("securityToken");
        exts = (Collection)args.get("exts");
        WikittyEvent result = super.storeExtension(securityToken, exts);
        this.callHook(securityToken, POST_STORE_EXTENSION, args, result);
        return result;
    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        Map<String, Object> args = new HashMap<String, Object>();
        args.put("securityToken", securityToken);
        args.put("ids", ids);
        args = this.callHook(securityToken, PRE_DELETE, args, null);
        securityToken = (String)args.get("securityToken");
        ids = (Collection)args.get("ids");
        WikittyEvent result = super.delete(securityToken, ids);
        this.callHook(securityToken, POST_DELETE, args, result);
        return result;
    }

    @Override
    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        Map<String, Object> args = new HashMap<String, Object>();
        args.put("securityToken", securityToken);
        args.put("extNames", extNames);
        args = this.callHook(securityToken, PRE_DELETE_EXTENSION, args, null);
        securityToken = (String)args.get("securityToken");
        extNames = (Collection)args.get("extNames");
        WikittyEvent result = super.deleteExtension(securityToken, extNames);
        this.callHook(securityToken, POST_DELETE_EXTENSION, args, result);
        return result;
    }

    @Override
    public WikittyEvent deleteTree(String securityToken, String wikittyId) {
        Map<String, Object> args = new HashMap<String, Object>();
        args.put("securityToken", securityToken);
        args.put("wikittyId", wikittyId);
        args = this.callHook(securityToken, PRE_DELETE_TREE, args, null);
        securityToken = (String)args.get("securityToken");
        wikittyId = (String)args.get("wikittyId");
        WikittyEvent result = super.deleteTree(securityToken, wikittyId);
        this.callHook(securityToken, POST_DELETE_TREE, args, result);
        return result;
    }

    @Override
    public WikittyEvent clear(String securityToken) {
        Map<String, Object> args = new HashMap<String, Object>();
        args.put("securityToken", securityToken);
        args = this.callHook(securityToken, PRE_CLEAR, args, null);
        securityToken = (String)args.get("securityToken");
        WikittyEvent result = super.clear(securityToken);
        this.callHook(securityToken, POST_CLEAR, args, result);
        return result;
    }

    @Override
    public String login(String login, String password) {
        Map<String, Object> args = new HashMap<String, Object>();
        args.put("login", login);
        args.put("password", password);
        args = this.callHook(null, PRE_LOGIN, args, null);
        login = (String)args.get("login");
        password = (String)args.get("password");
        String result = super.login(login, password);
        this.callHook(null, POST_LOGIN, args, null);
        return result;
    }

    @Override
    public void logout(String securityToken) {
        Map<String, Object> args = new HashMap<String, Object>();
        args.put("securityToken", securityToken);
        args = this.callHook(securityToken, PRE_LOGOUT, args, null);
        securityToken = (String)args.get("securityToken");
        super.logout(securityToken);
        this.callHook(securityToken, POST_LOGOUT, args, null);
    }

    @Override
    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        Map<String, Object> args = new HashMap<String, Object>();
        args.put("securityToken", securityToken);
        args.put("events", events);
        args.put("force", force);
        args = this.callHook(securityToken, PRE_REPLAY, args, null);
        securityToken = (String)args.get("securityToken");
        events = (List)args.get("events");
        force = (Boolean)args.get("force");
        WikittyEvent result = super.replay(securityToken, events, force);
        this.callHook(securityToken, POST_REPLAY, args, result);
        return result;
    }

    @Override
    public void syncSearchEngine(String securityToken) {
        Map<String, Object> args = new HashMap<String, Object>();
        args.put("securityToken", securityToken);
        args = this.callHook(securityToken, PRE_SYNC_SEARCH_ENGINE, args, null);
        securityToken = (String)args.get("securityToken");
        super.syncSearchEngine(securityToken);
        this.callHook(securityToken, POST_SYNC_SEARCH_ENGINE, args, null);
    }
}

