/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.services.WikittyServiceAuthenticationAbstract;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittyServiceAuthentication
extends WikittyServiceAuthenticationAbstract {
    private static Log log = LogFactory.getLog(WikittyServiceAuthentication.class);
    private static final TimeLog timeLog = new TimeLog(WikittyServiceAuthentication.class);

    public WikittyServiceAuthentication(ApplicationConfig config, WikittyService ws) {
        super(config, ws);
        if (config != null) {
            long timeToLogInfo = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SECURITY_TIME_TO_LOG_INFO.getKey());
            long timeToLogWarn = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SECURITY_TIME_TO_LOG_WARN.getKey());
            timeLog.setTimeToLogInfo(timeToLogInfo);
            timeLog.setTimeToLogWarn(timeToLogWarn);
        }
    }

    @Override
    public String login(String login, String password) {
        long start = TimeLog.getTime();
        WikittyQuery criteria = new WikittyQueryMaker().eq("WikittyUser.login", (Object)login).end();
        String userId = this.getDelegate().findByQuery(null, Collections.singletonList(criteria)).get(0);
        if (userId == null) {
            throw new SecurityException(String.format("no such account '%s'", login));
        }
        Wikitty user = WikittyServiceEnhanced.restore(this.getDelegate(), null, userId);
        if (!WikittyUserHelper.getPassword(user).equals(password)) {
            throw new SecurityException("bad login or password");
        }
        String tokenId = this.getToken(user);
        timeLog.log(start, "login");
        return tokenId;
    }
}

