/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.test.Product;
import org.nuiton.wikitty.test.ProductDocumentationAbstract;
import org.nuiton.wikitty.test.ProductDocumentationHelper;
import org.nuiton.wikitty.test.ProductHelper;
import org.nuiton.wikitty.test.ProductPictureAbstract;
import org.nuiton.wikitty.test.ProductPictureHelper;

public abstract class ProductAbstract
extends BusinessEntityImpl
implements Product {
    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionProduct;
    private static final long serialVersionUID = 3559029221323138148L;

    @Override
    public String getName() {
        String value = ProductHelper.getName(this.getWikitty());
        return value;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.getName();
        ProductHelper.setName(this.getWikitty(), name);
        this.getPropertyChangeSupport().firePropertyChange("name", oldValue, this.getName());
    }

    @Override
    public int getPriceFromProduct() {
        int value = ProductHelper.getPrice(this.getWikitty());
        return value;
    }

    @Override
    public void setPriceFromProduct(int price) {
        int oldValue = this.getPriceFromProduct();
        ProductHelper.setPrice(this.getWikitty(), price);
        this.getPropertyChangeSupport().firePropertyChange("price", oldValue, this.getPriceFromProduct());
    }

    @Override
    public Set<String> getColors() {
        Set<String> result = ProductHelper.getColors(this.getWikitty());
        return result;
    }

    @Override
    public void setColors(Set<String> colors) {
        Set<String> oldValue = this.getColors();
        ProductHelper.setColors(this.getWikitty(), colors);
        this.getPropertyChangeSupport().firePropertyChange("colors", oldValue, this.getColors());
    }

    @Override
    public void addAllColors(Collection<String> colors) {
        Set<String> oldValue = this.getColors();
        ProductHelper.addAllColors(this.getWikitty(), colors);
        this.getPropertyChangeSupport().firePropertyChange("colors", oldValue, this.getColors());
    }

    @Override
    public void addColors(String ... element) {
        Set<String> oldValue = this.getColors();
        ProductHelper.addColors(this.getWikitty(), element);
        this.getPropertyChangeSupport().firePropertyChange("colors", oldValue, this.getColors());
    }

    @Override
    public void removeColors(String ... element) {
        Set<String> oldValue = this.getColors();
        ProductHelper.removeColors(this.getWikitty(), element);
        this.getPropertyChangeSupport().firePropertyChange("colors", oldValue, this.getColors());
    }

    @Override
    public void clearColors() {
        ProductHelper.clearColors(this.getWikitty());
        this.getPropertyChangeSupport().firePropertyChange("colors", null, this.getColors());
    }

    @Override
    public Date getDate() {
        Date value = ProductHelper.getDate(this.getWikitty());
        return value;
    }

    @Override
    public void setDate(Date date) {
        Date oldValue = this.getDate();
        ProductHelper.setDate(this.getWikitty(), date);
        this.getPropertyChangeSupport().firePropertyChange("date", oldValue, this.getDate());
    }

    @Override
    public String getCategory() {
        String value = ProductHelper.getCategory(this.getWikitty());
        return value;
    }

    @Override
    public void setCategory(String category) {
        String oldValue = this.getCategory();
        ProductHelper.setCategory(this.getWikitty(), category);
        this.getPropertyChangeSupport().firePropertyChange("category", oldValue, this.getCategory());
    }

    @Override
    public String getPicture() {
        String value = ProductPictureHelper.getPicture(this.getWikitty());
        return value;
    }

    @Override
    public void setPicture(String picture) {
        String oldValue = this.getPicture();
        ProductPictureHelper.setPicture(this.getWikitty(), picture);
        this.getPropertyChangeSupport().firePropertyChange("picture", oldValue, this.getPicture());
    }

    @Override
    public int getPicturePrice() {
        int value = ProductPictureHelper.getPicturePrice(this.getWikitty());
        return value;
    }

    @Override
    public void setPicturePrice(int price) {
        int oldValue = this.getPicturePrice();
        ProductPictureHelper.setPicturePrice(this.getWikitty(), price);
        this.getPropertyChangeSupport().firePropertyChange("price", oldValue, this.getPicturePrice());
    }

    @Override
    public String getDocumentation() {
        String value = ProductDocumentationHelper.getDocumentation(this.getWikitty());
        return value;
    }

    @Override
    public void setDocumentation(String documentation) {
        String oldValue = this.getDocumentation();
        ProductDocumentationHelper.setDocumentation(this.getWikitty(), documentation);
        this.getPropertyChangeSupport().firePropertyChange("documentation", oldValue, this.getDocumentation());
    }

    @Override
    public int getPrice() {
        int value = ProductDocumentationHelper.getPrice(this.getWikitty());
        return value;
    }

    @Override
    public void setPrice(int price) {
        int oldValue = this.getPrice();
        ProductDocumentationHelper.setPrice(this.getWikitty(), price);
        this.getPropertyChangeSupport().firePropertyChange("price", oldValue, this.getPrice());
    }

    public ProductAbstract() {
    }

    public ProductAbstract(Wikitty wikitty) {
        super(wikitty);
    }

    public ProductAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
    }

    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    public String toString() {
        return ProductHelper.toString(this.getWikitty());
    }

    static {
        extensionProduct = new WikittyExtension("Product", "3.0", WikittyUtil.tagValuesToMap((String)" alternativeName.Product.price=\"priceFromProduct\" version=\"3.0\""), "ProductPicture,ProductDocumentation", WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name unique=\"true\"", "Numeric price unique=\"true\"", "String colors[0-*] unique=\"true\"", "Date date unique=\"true\"", "Wikitty category[0-1] unique=\"true\""}));
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.addAll(ProductPictureAbstract.extensions);
        exts.addAll(ProductDocumentationAbstract.extensions);
        exts.add(extensionProduct);
        extensions = Collections.unmodifiableList(exts);
    }
}

