/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.conditions;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.ObjectUtils;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.Element;
import org.nuiton.wikitty.query.conditions.TerminalOperator;

public abstract class TerminalBinaryOperator
extends TerminalOperator {
    private static final long serialVersionUID = 1L;
    protected Element element;
    protected ConditionValue value;

    public TerminalBinaryOperator(Element element) {
        this(element, (ConditionValue)null);
    }

    public TerminalBinaryOperator(Element element, String value) {
        this(element, new ConditionValueString(value));
    }

    public TerminalBinaryOperator(Element element, ConditionValue value) {
        this.element = element;
        this.value = value;
    }

    @Override
    public boolean waitCondition() {
        boolean result = this.value == null;
        return result;
    }

    @Override
    public Condition addCondition(Condition c) {
        if (this.waitCondition()) {
            if (!(c instanceof ConditionValue)) {
                throw new WikittyException("Only ConditionValue can be add to TerminalBinaryOperator, but you try to add: " + ClassUtils.getShortCanonicalName((Object)c, (String)"null"));
            }
        } else {
            throw new WikittyException(String.format("Operator (%s) has already value", this.getClass().getSimpleName()));
        }
        this.value = (ConditionValue)c;
        return this;
    }

    @Override
    public void accept(WikittyQueryVisitor visitor) {
        boolean walk = visitor.visitEnter(this);
        if (walk) {
            this.value.accept(visitor);
        }
        visitor.visitLeave(this, walk);
    }

    public Element getElement() {
        return this.element;
    }

    public ConditionValue getValue() {
        return this.value;
    }

    @Override
    boolean equalsDeep(Object other) {
        TerminalBinaryOperator op = (TerminalBinaryOperator)other;
        boolean result = ObjectUtils.equals((Object)this.getElement(), (Object)op.getElement()) && ObjectUtils.equals((Object)this.getValue(), (Object)op.getValue());
        return result;
    }
}

