package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class HorseAbstract extends BusinessEntityImpl implements Horse {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionHorse;

    @Override
    public int getLegs() {
int value = HorseHelper.getLegs(getWikitty());
return value;
}

    @Override
    public void setLegs(int legs) {
int oldValue = getLegs();
HorseHelper.setLegs(getWikitty(), legs);
getPropertyChangeSupport().firePropertyChange(Horse.FIELD_HORSE_LEGS, oldValue, getLegs());
}

    @Override
    public String getColor() {
String value = HorseHelper.getColor(getWikitty());
return value;
}

    @Override
    public void setColor(String color) {
String oldValue = getColor();
HorseHelper.setColor(getWikitty(), color);
getPropertyChangeSupport().firePropertyChange(Horse.FIELD_HORSE_COLOR, oldValue, getColor());
}

    public HorseAbstract() {
        super();
}

    public HorseAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public HorseAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionHorse = new WikittyExtension(EXT_HORSE,
                "1.0", // version
                WikittyUtil.tagValuesToMap(""), // tag/values
                Animal.EXT_ANIMAL,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "Numeric legs unique=\"true\"", 
                                             "String color unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(AnimalAbstract.extensions); 
        // current after requires ones

        exts.add(extensionHorse);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return HorseHelper.toString(getWikitty());
}

} //HorseAbstract
