/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ObjectUtil;
import org.nuiton.wikitty.WikittyService;

public class WikittyServiceFactory {
    private static Log log = LogFactory.getLog(WikittyServiceFactory.class);

    public static WikittyService buildWikittyService(ApplicationConfig config) {
        String prefix = "wikitty.";
        WikittyService result = WikittyServiceFactory.buildWikittyService(config, prefix);
        return result;
    }

    public static WikittyService buildWikittyServiceTransaction(ApplicationConfig config) {
        String prefix = "wikitty.transaction.";
        WikittyService result = WikittyServiceFactory.buildWikittyService(config, prefix);
        return result;
    }

    public static WikittyService buildWikittyService(ApplicationConfig config, String prefix) {
        WikittyService result = null;
        List<Class> layers = WikittyServiceFactory.getComponents(config, prefix, WikittyService.class);
        HashSet<Object> comp = new HashSet<Object>();
        for (Class clazz : layers) {
            comp.clear();
            comp.add(result);
            comp.add(config);
            List<Class> comps = WikittyServiceFactory.getComponents(config, prefix, clazz);
            if (comps != null) {
                comp.addAll(comps);
            }
            result = (WikittyService)ObjectUtil.newInstance((Class)clazz, comp, (boolean)true);
        }
        return result;
    }

    protected static List<Class> getComponents(ApplicationConfig config, String prefix, Class clazz) {
        String key = prefix + clazz.getSimpleName() + ".components";
        List result = config.getOptionAsList(key).getOptionAsClass();
        return result;
    }
}

