/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;

public class BusinessEntityImpl
implements BusinessEntity {
    private static final long serialVersionUID = -4399752739887114180L;
    protected transient PropertyChangeSupport propertyChangeSupport;
    protected WikittyExtension extensionForMetaExtension;
    protected Wikitty wikitty;

    public BusinessEntityImpl(Wikitty wi) {
        this.setWikitty(wi);
    }

    public BusinessEntityImpl() {
        this(new WikittyImpl());
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    @Override
    public String getWikittyId() {
        String result = this.getWikitty().getWikittyId();
        return result;
    }

    @Override
    public String getWikittyVersion() {
        String result = this.getWikitty().getWikittyVersion();
        return result;
    }

    @Override
    public void setWikittyVersion(String version) {
        this.getWikitty().setWikittyVersion(version);
    }

    public void setWikitty(Wikitty wikitty) {
        if (wikitty != null) {
            for (WikittyExtension ext : this.getStaticExtensions()) {
                if (wikitty.getExtensions().contains(ext)) continue;
                wikitty.addExtension(ext);
            }
        }
        this.wikitty = wikitty;
    }

    public Wikitty getWikitty() {
        return this.wikitty;
    }

    @Override
    public void copyFrom(BusinessEntity source) {
        try {
            WikittyUtil.copyBean(source, this);
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't copy source object %s", source), eee);
        }
    }

    @Override
    public Collection<String> getExtensionNames() {
        Collection<String> result = this.getWikitty().getExtensionNames();
        return result;
    }

    @Override
    public Collection<String> getExtensionFields(String ext) {
        Collection<String> result = this.getWikitty().getExtension(ext).getFieldNames();
        return result;
    }

    public FieldType getFieldType(String ext, String fieldName) {
        FieldType result = this.getWikitty().getExtension(ext).getFieldType(fieldName);
        return result;
    }

    @Override
    public Object getFieldAsObject(String ext, String fieldName) {
        Object result = this.getWikitty().getFieldAsObject(ext, fieldName);
        return result;
    }

    @Override
    public Object getField(String ext, String fieldName) {
        return this.getFieldAsObject(ext, fieldName);
    }

    @Override
    public void setField(String ext, String fieldName, Object value) {
        this.getWikitty().setField(ext, fieldName, value);
    }

    public Collection<WikittyExtension> getStaticExtensions() {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getStaticExtensionNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (WikittyExtension ext : this.getStaticExtensions()) {
            result.add(ext.getName());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!BusinessEntityImpl.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        BusinessEntityImpl w = (BusinessEntityImpl)obj;
        return this.getWikittyId().equals(w.getWikittyId());
    }

    public int hashCode() {
        return this.getWikittyId().hashCode();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
    }
}

