/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.FieldTypeConstaintChecker;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyTreeNodeHelper;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.query.WikittyQueryResultTreeNode;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyExtensionMigration;
import org.nuiton.wikitty.services.WikittyExtensionMigrationRegistry;
import org.nuiton.wikitty.services.WikittyExtensionMigrationRename;
import org.nuiton.wikitty.services.WikittyListener;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittyExtensionStorage;
import org.nuiton.wikitty.storage.WikittySearchEngine;
import org.nuiton.wikitty.storage.WikittyStorage;

public class WikittyServiceStorage
implements WikittyService {
    private static final Log log = LogFactory.getLog(WikittyServiceStorage.class);
    private static final TimeLog timeLog = new TimeLog(WikittyServiceStorage.class);
    protected WikittyExtensionMigration defaultExtensionMigration = new WikittyExtensionMigrationRename();
    protected FieldTypeConstaintChecker constraintChecker = new FieldTypeConstaintChecker(this);
    protected ApplicationConfig config;
    protected WikittySearchEngine searchEngine;
    protected WikittyExtensionStorage extensionStorage;
    protected WikittyStorage wikittyStorage;

    protected WikittyServiceStorage(ApplicationConfig config) {
        this.config = config;
    }

    public WikittyServiceStorage(ApplicationConfig config, WikittyExtensionStorage extensionStorage, WikittyStorage wikittyStorage, WikittySearchEngine searchEngine) {
        this.config = config;
        this.extensionStorage = extensionStorage;
        this.wikittyStorage = wikittyStorage;
        this.searchEngine = searchEngine;
    }

    public WikittySearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public WikittyExtensionStorage getExtensionStorage() {
        return this.extensionStorage;
    }

    public WikittyStorage getWikittyStorage() {
        return this.wikittyStorage;
    }

    @Override
    public void addWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("Can't add listener on " + WikittyServiceStorage.class.getName());
    }

    @Override
    public void removeWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("Can't remove listener on " + WikittyServiceStorage.class.getName());
    }

    @Override
    public String login(String login, String password) {
        log.warn((Object)"login asked, but there is no security service");
        return null;
    }

    @Override
    public void logout(String securityToken) {
        log.warn((Object)"logout asked, but there is no security service");
    }

    @Override
    public String getToken(String user) {
        log.warn((Object)"getToken asked, but there is no security service");
        return null;
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return true;
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return true;
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        return true;
    }

    protected void checkConstraint(Collection<Wikitty> wikitties) {
        for (Wikitty w : wikitties) {
            for (WikittyExtension ext : w.getExtensions()) {
                for (String fieldName : ext.getFieldNames()) {
                    String fqfield = WikittyUtil.getFQFieldName(ext.getName(), fieldName);
                    FieldType type = ext.getFieldType(fieldName);
                    Object value = w.getFqField(fqfield);
                    LinkedList<String> errors = new LinkedList<String>();
                    if (this.constraintChecker.isValid(fqfield, type, value = this.constraintChecker.checkDefault(w, fqfield, type, value), errors)) continue;
                    throw new WikittyException(String.format("Field constraint error %s", StringUtils.join(errors, (String)"\n")));
                }
            }
        }
    }

    @Override
    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        wikitties = new LinkedHashSet<Wikitty>(wikitties);
        wikitties.removeAll(Collections.singletonList(null));
        this.checkConstraint(wikitties);
        LinkedHashSet<WikittyExtension> allExtensions = new LinkedHashSet<WikittyExtension>();
        for (Wikitty w : wikitties) {
            allExtensions.addAll(w.getExtensions());
        }
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            WikittyEvent extUpdate = this.getExtensionStorage().store(tx, allExtensions);
            WikittyEvent wikUpdate = this.getWikittyStorage().store(tx, wikitties, force);
            this.getSearchEngine().store(tx, wikitties, force);
            WikittyEvent result = new WikittyEvent(this);
            result.add(extUpdate);
            result.add(wikUpdate);
            WikittyEvent wikittyEvent = result;
            return wikittyEvent;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't store wikitty", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            List<String> result;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            List<String> list = result = this.getExtensionStorage().getAllExtensionIds(tx);
            return list;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't retrieve all extension's ids", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            List<String> result;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            List<String> list = result = this.getExtensionStorage().getAllExtensionsRequires(tx, extensionName);
            return list;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException(String.format("Can't retrieve all required extension for %s", extensionName), eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    protected void checkExtension(Collection<WikittyExtension> exts) {
        for (WikittyExtension ext : exts) {
            if (WikittyUtil.versionGreaterThan("0", ext.getVersion())) {
                throw new WikittyException(String.format("Invalide extension version %s", ext.getVersion()));
            }
            if (!ext.getName().matches("\\w+")) {
                throw new WikittyException(String.format("Invalide extension name %s", ext.getName()));
            }
            for (String fieldName : ext.getFieldNames()) {
                if (fieldName.matches("\\w+")) continue;
                throw new WikittyException(String.format("Invalide extension field name '%s' for extension '%s'", fieldName, ext.getName()));
            }
        }
    }

    @Override
    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            WikittyEvent result;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            this.checkExtension(exts);
            WikittyEvent wikittyEvent = result = this.getExtensionStorage().store(tx, exts);
            return wikittyEvent;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't store extensions", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            WikittyEvent result;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            for (String name : extNames) {
                WikittyQuery query = ((WikittyQueryMaker)new WikittyQueryMaker().exteq(name)).end();
                query.setLimit(0);
                WikittyQueryResult<Map<String, Object>> wikittyWithExt = this.findAllByQuery(securityToken, Collections.singletonList(query)).get(0);
                int numFound = wikittyWithExt.getTotalResult();
                if (numFound <= 0) continue;
                throw new WikittyException(String.format("Can't delete %s extension, this extension is in used by %s wikitty", name, numFound));
            }
            WikittyEvent wikittyEvent = result = this.getExtensionStorage().delete(tx, extNames);
            return wikittyEvent;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't delete extensions", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String extensionId) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            WikittyExtension result;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            String name = WikittyExtension.computeName(extensionId);
            String version = WikittyExtension.computeVersion(extensionId);
            WikittyExtension wikittyExtension = result = this.getExtensionStorage().restore(tx, name, version);
            return wikittyExtension;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't restore extensions", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            WikittyExtension result;
            String version;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            if ((version = this.getExtensionStorage().getLastVersion(tx, name)) == null) {
                if (txBeginHere) {
                    tx.commit();
                }
                WikittyExtension wikittyExtension = null;
                return wikittyExtension;
            }
            WikittyExtension wikittyExtension = result = this.getExtensionStorage().restore(tx, name, version);
            return wikittyExtension;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't restore extensions", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public List<WikittyExtension> restoreExtensionAndDependenciesLastVesion(String securityToken, Collection<String> extensionNames) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            ArrayList<WikittyExtension> result = new ArrayList<WikittyExtension>();
            for (String extName : extensionNames) {
                WikittyExtension ext = this.restoreExtensionLastVersion(securityToken, extName);
                if (ext == null) continue;
                List<String> requires = ext.getRequires();
                if (CollectionUtils.isNotEmpty(requires)) {
                    List<WikittyExtension> dependencies = this.restoreExtensionAndDependenciesLastVesion(securityToken, requires);
                    result.addAll(dependencies);
                }
                result.add(ext);
            }
            ArrayList<WikittyExtension> arrayList = result;
            return arrayList;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't restore extensions", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    protected Wikitty restore(String securityToken, String id) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (id == null) {
                Wikitty wikitty = null;
                return wikitty;
            }
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            if (!this.getWikittyStorage().exists(tx, id)) {
                Wikitty wikitty = null;
                return wikitty;
            }
            if (this.getWikittyStorage().isDeleted(tx, id)) {
                Wikitty wikitty = null;
                return wikitty;
            }
            Wikitty result = this.getWikittyStorage().restore(tx, id, new String[0]);
            if (result != null) {
                result = this.upgradeData(securityToken, result);
            }
            Wikitty wikitty = result;
            return wikitty;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't store extensions", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        ArrayList<Wikitty> result = new ArrayList<Wikitty>();
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            for (String id : ids) {
                Wikitty w = this.restore(securityToken, id);
                result.add(w);
            }
            ArrayList<Wikitty> i$ = result;
            return i$;
        }
        catch (WikittyException ex) {
            if (tx != null) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null) {
                tx.rollback();
            }
            throw new WikittyException("Can't restore wikitty", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    protected LinkedHashSet<WikittyExtension> getExtension(Collection<String> extNames, LinkedHashSet<WikittyExtension> exts) {
        for (String name : extNames) {
            WikittyExtension ext = this.restoreExtensionLastVersion(null, name);
            List<String> requires = ext.getRequires();
            if (CollectionUtils.isNotEmpty(requires)) {
                this.getExtension(requires, exts);
            }
            exts.add(ext);
        }
        return exts;
    }

    protected WikittyExtensionMigration getMigration(String extensionName) {
        WikittyExtensionMigration result = null;
        WikittyExtensionMigrationRegistry registry = (WikittyExtensionMigrationRegistry)this.config.getObject(WikittyExtensionMigrationRegistry.class);
        result = registry.get(extensionName);
        if (result == null) {
            result = WikittyExtensionMigration.migrationRegistry.get(extensionName);
        }
        if (result == null) {
            result = this.defaultExtensionMigration;
        }
        return result;
    }

    protected Wikitty upgradeData(String securityToken, Wikitty wikitty) {
        Wikitty result = wikitty;
        LinkedHashSet<WikittyExtension> newExt = this.getExtension(wikitty.getExtensionNames(), new LinkedHashSet<WikittyExtension>());
        Collection diff = CollectionUtils.disjunction(wikitty.getExtensions(), newExt);
        if (!diff.isEmpty()) {
            String wikittyId = wikitty.getWikittyId();
            String wikittyVersion = wikitty.getWikittyVersion();
            result = new WikittyImpl(wikittyId);
            result.setWikittyVersion(wikittyVersion);
            result.addExtension(newExt);
            Collection<WikittyExtension> extensions = wikitty.getExtensions();
            for (WikittyExtension extension : extensions) {
                String extensionName = extension.getName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("extensionName=" + extensionName));
                }
                WikittyExtension currentExtension = extension;
                String currentExtensionVersion = currentExtension.getVersion();
                WikittyExtension lastExtension = result.getExtension(extensionName);
                String lastExtensionVersion = lastExtension.getVersion();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Migrate extension '%s' from '%s' to '%s'", extensionName, currentExtensionVersion, lastExtensionVersion));
                }
                WikittyExtensionMigration migration = this.getMigration(extensionName);
                result = migration.migrate(this, wikitty, result, currentExtension, lastExtension);
            }
            WikittyClient wc = new WikittyClient(this.config, this, securityToken);
            result = wc.store(result);
        }
        return result;
    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) throws WikittyException {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            LinkedHashSet<Wikitty> storedWikitties = new LinkedHashSet<Wikitty>();
            LinkedHashSet<String> idSet = new LinkedHashSet<String>(ids);
            Iterator i = idSet.iterator();
            while (i.hasNext()) {
                Wikitty treeNode;
                String id = (String)i.next();
                if (!this.getWikittyStorage().exists(tx, id)) {
                    i.remove();
                    continue;
                }
                if (this.getWikittyStorage().isDeleted(tx, id)) {
                    i.remove();
                    continue;
                }
                WikittyQuery query = ((WikittyQueryMaker)new WikittyQueryMaker().eq("WikittyTreeNode.parent", (Object)id)).end();
                List<String> wikittyNodesId = this.findAllByQuery(securityToken, Collections.singletonList(query)).get(0).convertMapToSimpleString().getAll();
                for (String wikittyNodeId : wikittyNodesId) {
                    if (idSet.contains(wikittyNodeId)) continue;
                    treeNode = this.restore(securityToken, wikittyNodeId);
                    WikittyTreeNodeHelper.setParent(treeNode, (String)null);
                    storedWikitties.add(treeNode);
                }
                query = ((WikittyQueryMaker)new WikittyQueryMaker().eq("WikittyTreeNode.attachment", (Object)id)).end();
                wikittyNodesId = this.findAllByQuery(securityToken, Collections.singletonList(query)).get(0).convertMapToSimpleString().getAll();
                for (String wikittyNodeId : wikittyNodesId) {
                    if (idSet.contains(wikittyNodeId)) continue;
                    treeNode = this.restore(securityToken, wikittyNodeId);
                    WikittyTreeNodeHelper.removeAttachment(treeNode, id);
                    storedWikitties.add(treeNode);
                }
            }
            WikittyEvent eventDelete = this.getWikittyStorage().delete(tx, idSet);
            this.getSearchEngine().delete(tx, idSet);
            WikittyEvent eventStore = this.store(securityToken, storedWikitties, false);
            WikittyEvent result = new WikittyEvent(this);
            result.add(eventDelete);
            result.add(eventStore);
            WikittyEvent wikittyEvent = result;
            return wikittyEvent;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't delete wikitty", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public WikittyEvent clear(String securityToken) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            this.getSearchEngine().clear(tx);
            WikittyEvent eventWik = this.getWikittyStorage().clear(tx);
            WikittyEvent eventExt = this.getExtensionStorage().clear(tx);
            WikittyEvent result = new WikittyEvent(this);
            result.add(eventWik);
            result.add(eventExt);
            WikittyEvent wikittyEvent = result;
            return wikittyEvent;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't clear all data", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public List<PagedResult<String>> findAllByCriteria(String securityToken, List<Criteria> criteria) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            ArrayList<PagedResult<String>> result = new ArrayList<PagedResult<String>>(criteria.size());
            for (Criteria c : criteria) {
                if (c == null) {
                    result.add(null);
                    continue;
                }
                PagedResult<String> searchResult = this.getSearchEngine().findAllByCriteria(tx, c);
                result.add(searchResult);
            }
            if (criteria.size() != result.size()) {
                log.error((Object)String.format("Criteria input list (%s) has not same size that result list (%s)", criteria.size(), result.size()));
            }
            ArrayList<PagedResult<String>> arrayList = result;
            return arrayList;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Error during find", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public List<String> findByCriteria(String securityToken, List<Criteria> criteria) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            ArrayList<String> result = new ArrayList<String>(criteria.size());
            ArrayList<Criteria> criteriaLimit = new ArrayList<Criteria>(criteria.size());
            for (Criteria c : criteria) {
                Criteria cLimit = Search.query(c).criteria().setFirstIndex(0).setEndIndex(1);
                criteriaLimit.add(cLimit);
            }
            List<PagedResult<String>> idsList = this.findAllByCriteria(securityToken, criteriaLimit);
            for (PagedResult<String> ids : idsList) {
                if (ids.size() > 0) {
                    result.add(ids.getFirst());
                    continue;
                }
                result.add(null);
            }
            if (criteria.size() != result.size()) {
                log.error((Object)String.format("Criteria input list (%s) has not same size that result list (%s)", criteria.size(), result.size()));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Error during find", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public List<WikittyQueryResult<Map<String, Object>>> findAllByQuery(String securityToken, List<WikittyQuery> queries) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            ArrayList<WikittyQueryResult<Map<String, Object>>> result = new ArrayList<WikittyQueryResult<Map<String, Object>>>(queries.size());
            for (WikittyQuery c : queries) {
                if (c == null) {
                    result.add(null);
                    continue;
                }
                try {
                    long startTime = System.nanoTime();
                    WikittyQueryResult<Map<String, Object>> searchResult = this.getSearchEngine().findAllByQuery(tx, c);
                    long estimatedTime = System.nanoTime() - startTime;
                    searchResult.setTimeQuery(estimatedTime);
                    result.add(searchResult);
                }
                catch (Exception eee) {
                    throw new WikittyException(String.format("Can't evaluate query '%s'", c), eee);
                }
            }
            if (queries.size() != result.size()) {
                log.error((Object)String.format("Query input list (%s) has not same size that result list (%s)", queries.size(), result.size()));
            }
            ArrayList<WikittyQueryResult<Map<String, Object>>> arrayList = result;
            return arrayList;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Error during find", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public List<Map<String, Object>> findByQuery(String securityToken, List<WikittyQuery> queries) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(queries.size());
            ArrayList<WikittyQuery> queriesLimited = new ArrayList<WikittyQuery>(queries.size());
            for (WikittyQuery c : queries) {
                WikittyQuery cLimit = c.copy().setOffset(0).setLimit(1);
                queriesLimited.add(cLimit);
            }
            List<WikittyQueryResult<Map<String, Object>>> idsList = this.findAllByQuery(securityToken, queriesLimited);
            for (WikittyQueryResult<Map<String, Object>> ids : idsList) {
                if (ids.size() > 0) {
                    result.add(ids.peek());
                    continue;
                }
                result.add(null);
            }
            if (queries.size() != result.size()) {
                log.error((Object)String.format("Query input list (%s) has not same size that result list (%s)", queries.size(), result.size()));
            }
            ArrayList<Map<String, Object>> arrayList = result;
            return arrayList;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Error during find", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public WikittyEvent deleteTree(String securityToken, String thesaurusId) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            WikittyEvent result;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            List<String> allTreeNodeId = this.getRecursiveTreeNodeId(securityToken, thesaurusId);
            WikittyEvent wikittyEvent = result = this.delete(securityToken, allTreeNodeId);
            return wikittyEvent;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't delete tree", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    protected List<String> getRecursiveTreeNodeId(String securityToken, String treeNodeId) {
        WikittyQuery query = ((WikittyQueryMaker)new WikittyQueryMaker().eq("WikittyTreeNode.parent", (Object)treeNodeId)).end();
        WikittyQueryResult<String> childTreeNodeIds = this.findAllByQuery(securityToken, Collections.singletonList(query)).get(0).convertMapToSimpleString();
        ArrayList<String> treeNodeIds = new ArrayList<String>();
        treeNodeIds.add(treeNodeId);
        for (String childTreeNodeId : childTreeNodeIds) {
            List<String> subTreeNodeIds = this.getRecursiveTreeNodeId(securityToken, childTreeNodeId);
            treeNodeIds.addAll(subTreeNodeIds);
        }
        return treeNodeIds;
    }

    @Override
    public TreeNodeResult<String> findTreeNode(String securityToken, String wikittyId, int depth, boolean count, Criteria filter) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            TreeNodeResult<String> result = null;
            Wikitty w = this.restore(securityToken, wikittyId);
            if (w != null) {
                result = this.getSearchEngine().findAllChildrenCount(tx, wikittyId, depth, count, filter);
            }
            TreeNodeResult<String> treeNodeResult = result;
            return treeNodeResult;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't restore children", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public WikittyQueryResultTreeNode<String> findTreeNode(String securityToken, String wikittyId, int depth, boolean count, WikittyQuery filter) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            WikittyQueryResultTreeNode<String> result = null;
            Wikitty w = this.restore(securityToken, wikittyId);
            if (w != null) {
                result = this.getSearchEngine().findAllChildrenCount(tx, wikittyId, depth, count, filter);
            }
            WikittyQueryResultTreeNode<String> wikittyQueryResultTreeNode = result;
            return wikittyQueryResultTreeNode;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't restore children", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void syncSearchEngine(final String securityToken) {
        final WikittyTransaction tx = WikittyTransaction.get();
        if (tx.isStarted()) {
            throw new WikittyException("Transaction must be not started for syncSearchEngine method");
        }
        boolean txBeginHere = false;
        try {
            log.info((Object)"Reindexation started");
            int numberForCommit = 1000;
            final WikittySearchEngine searchEngine = this.getSearchEngine();
            final ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>(1000);
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            searchEngine.clear(tx);
            if (txBeginHere) {
                tx.commit();
            }
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            WikittyStorage.DataStatistic stat = this.getWikittyStorage().getDataStatistic(tx);
            final long max = stat.getActiveWikitties();
            if (txBeginHere) {
                tx.commit();
            }
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            log.info((Object)"Reindexation 0%");
            this.getWikittyStorage().scanWikitties(tx, new WikittyStorage.Scanner(){
                long lastPurcent = -1L;
                long current = 0L;
                int count = 0;
                long startLoadStoreCommit = TimeLog.getTime();

                @Override
                public void scan(String wikittyId) {
                    Wikitty wikitty = WikittyServiceStorage.this.restore(securityToken, wikittyId);
                    Date deleteDate = wikitty.getDeleteDate();
                    if (deleteDate == null) {
                        ++this.current;
                        ++this.count;
                        wikitties.add(wikitty);
                        if (this.count == 1000) {
                            long purcent;
                            long startStore = TimeLog.getTime();
                            searchEngine.store(tx, wikitties, true);
                            tx.commit();
                            this.count = 0;
                            wikitties.clear();
                            tx.begin();
                            timeLog.log(startStore, "StoreAndCommit", String.format("nb %s", 1000));
                            this.startLoadStoreCommit = timeLog.log(this.startLoadStoreCommit, "LoadAndStoreAndCommit", String.format("nb %s", 1000));
                            if (max > 0L && (purcent = this.current * 100L / max) / 10L > this.lastPurcent) {
                                this.lastPurcent = purcent / 10L;
                                log.info((Object)String.format("Reindexation %s%%", purcent));
                            }
                        }
                    }
                }
            });
            searchEngine.store(tx, wikitties, true);
            log.info((Object)"Reindexation finished");
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't sync searchable index with data", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        boolean mustClear = false;
        LinkedHashMap<String, Wikitty> toAddWikitty = new LinkedHashMap<String, Wikitty>();
        LinkedHashMap toRemoveWikitty = new LinkedHashMap();
        LinkedHashSet<WikittyExtension> toAddExt = new LinkedHashSet<WikittyExtension>();
        LinkedHashSet<String> toDeleteExt = new LinkedHashSet<String>();
        for (WikittyEvent e : events) {
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.CLEAR_WIKITTY) || e.getType().contains((Object)WikittyEvent.WikittyEventType.CLEAR_EXTENSION)) {
                mustClear = true;
                toAddWikitty.clear();
                toRemoveWikitty.clear();
                toAddExt.clear();
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.PUT_WIKITTY)) {
                for (Wikitty wikitty : e.getWikitties().values()) {
                    toAddWikitty.put(wikitty.getWikittyId(), wikitty);
                }
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.REMOVE_WIKITTY)) {
                for (Map.Entry entry : e.getRemoveDate().entrySet()) {
                    toAddWikitty.remove(entry.getKey());
                    toRemoveWikitty.put(entry.getKey(), entry.getValue());
                }
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.PUT_EXTENSION)) {
                for (WikittyExtension wikittyExtension : e.getExtensions().values()) {
                    toAddExt.add(wikittyExtension);
                }
            }
            if (!e.getType().contains((Object)WikittyEvent.WikittyEventType.REMOVE_EXTENSION)) continue;
            for (String string : e.getDeletedExtensions()) {
                toDeleteExt.add(string);
            }
        }
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            WikittyEvent result = new WikittyEvent(this);
            if (mustClear) {
                WikittyEvent wikittyEvent = this.clear(securityToken);
                result.add(wikittyEvent);
            }
            WikittyEvent wikittyEvent = this.storeExtension(securityToken, toAddExt);
            result.add(wikittyEvent);
            WikittyEvent eventDeleteExtension = this.deleteExtension(securityToken, toDeleteExt);
            result.add(eventDeleteExtension);
            WikittyEvent eventStoreWikitty = this.store(securityToken, toAddWikitty.values(), force);
            result.add(eventStoreWikitty);
            WikittyEvent eventDeleteWikitty = this.delete(securityToken, toRemoveWikitty.keySet());
            result.add(eventDeleteWikitty);
            WikittyEvent wikittyEvent2 = result;
            return wikittyEvent2;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't replay data", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public boolean exists(String securityToken, String wikittyId) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            boolean result;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            boolean bl = result = this.getWikittyStorage().exists(tx, wikittyId);
            return bl;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't test existance", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }

    @Override
    public boolean isDeleted(String securityToken, String wikittyId) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            boolean result;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            boolean bl = result = this.getWikittyStorage().isDeleted(tx, wikittyId);
            return bl;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't test existance", eee);
        }
        finally {
            if (txBeginHere && tx != null && tx.isStarted()) {
                tx.commit();
            }
        }
    }
}

