/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons.importexport;

import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.addons.WikittyImportExportService;
import org.nuiton.wikitty.addons.importexport.ImportExportMethod;
import org.nuiton.wikitty.services.WikittyServiceTransaction;

public class ImportTask
implements Runnable {
    private static Log log = LogFactory.getLog(ImportTask.class);
    protected ApplicationConfig config;
    protected WikittyService ws;
    protected WikittyImportExportService.FORMAT format;
    protected Reader reader;
    protected ImportExportMethod importerExporter;
    protected String securityToken;

    public ImportTask(String securityToken, ApplicationConfig config, WikittyService ws, WikittyImportExportService.FORMAT format, Reader reader) {
        this.config = config;
        this.securityToken = securityToken;
        this.ws = ws;
        this.format = format;
        this.reader = reader;
    }

    @Override
    public void run() {
        WikittyServiceTransaction tx = new WikittyServiceTransaction(this.config, this.ws);
        tx.setAutoCommit(1000);
        try {
            long time = 0L;
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis();
                log.info((Object)("Import in (ms)" + time));
            }
            ImportExportMethod importer = this.format.ieporter();
            importer.importReader(this.securityToken, this.reader, tx);
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis() - time;
                log.info((Object)("Import in (ms)" + time));
            }
            tx.commit(this.securityToken);
        }
        catch (Exception eee) {
            tx.rollback(this.securityToken);
            throw new WikittyException("Error during import task", eee);
        }
    }
}

