/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyServiceDelegator.java 646 2010-12-22 17:50:50Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.3/wikitty-api/src/main/java/org/nuiton/wikitty/services/WikittyServiceDelegator.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.services;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTree;

/**
 * Wikitty service delegator.
 * 
 * @author chatellier
 * @version $Revision: 646 $
 * 
 * Last update : $Date: 2010-12-22 18:50:50 +0100 (mer., 22 déc. 2010) $
 * By : $Author: bpoussin $
 */
public class WikittyServiceDelegator implements WikittyService {

    /** Delegated wikitty service. */
    protected WikittyService delegate;

    public WikittyServiceDelegator() {
    }

    public WikittyServiceDelegator(WikittyService delegate) {
        setDelegate(delegate);
    }

    /**
     * Get delegated service.
     * 
     * @return delegate service
     */
    public WikittyService getDelegate() {
        return delegate;
    }

    /**
     * Set delegated service.
     * 
     * @param delegate delegate
     */
    public void setDelegate(WikittyService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addWikittyServiceListener(WikittyListener listener,
            ServiceListenerType type) {
        delegate.addWikittyServiceListener(listener, type);
    }

    @Override
    public void removeWikittyServiceListener(WikittyListener listener,
            ServiceListenerType type) {
        delegate.removeWikittyServiceListener(listener, type);
    }

    @Override
    public String login(String login, String password) {
        return delegate.login(login, password);
    }

    @Override
    public void logout(String securityToken) {
        delegate.logout(securityToken);
    }

    @Override
    public WikittyEvent clear(String securityToken) {
        return delegate.clear(securityToken);
    }

    @Override
    public WikittyEvent replay(
            String securityToken, List<WikittyEvent> events, boolean force) {
        return delegate.replay(securityToken, events, force);
    }

    @Override
    public WikittyEvent store(
            String securityToken, Collection<Wikitty> wikitties, boolean force) {
        return delegate.store(securityToken, wikitties, force);
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        return delegate.getAllExtensionIds(securityToken);
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken,
            String extensionName) {
        return delegate.getAllExtensionsRequires(securityToken, extensionName);
    }

    @Override
    public WikittyEvent storeExtension(String securityToken,
            Collection<WikittyExtension> exts) {
        return delegate.storeExtension(securityToken, exts);
    }

    @Override
    public WikittyEvent deleteExtension(
            String securityToken, Collection<String> extNames) {
        return delegate.deleteExtension(securityToken, extNames);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String id) {
        return delegate.restoreExtension(securityToken, id);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(
            String securityToken, String name) {
        return delegate.restoreExtensionLastVersion(securityToken, name);
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> id) {
        return delegate.restore(securityToken, id);
    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        return delegate.delete(securityToken, ids);
    }

    @Override
    public PagedResult<String> findAllByCriteria(
            String securityToken, Criteria criteria) {
        return delegate.findAllByCriteria(securityToken, criteria);
    }

    @Override
    public String findByCriteria(String securityToken, Criteria criteria) {
        return delegate.findByCriteria(securityToken, criteria);
    }

    @Override
    public WikittyTree restoreTree(String securityToken, String wikittyId) {
        return delegate.restoreTree(securityToken, wikittyId);
    }
    
    @Override
    public WikittyEvent deleteTree(String securityToken, String wikittyId) {
        return delegate.deleteTree(securityToken, wikittyId);
    }

    @Override
    public Entry<String, Integer> restoreNode(String securityToken,
            String wikittyId, Criteria filter) {
        return delegate.restoreNode(securityToken, wikittyId, filter);
    }

    @Override
    public Map<String, Integer> restoreChildren(String securityToken,
            String wikittyId, Criteria filter) {
        return delegate.restoreChildren(securityToken, wikittyId, filter);
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId,
            String version) {
        return delegate.restoreVersion(securityToken, wikittyId, version);
    }

    @Override
    public void syncSearchEngine(String securityToken) {
        delegate.syncSearchEngine(securityToken);
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return delegate.canWrite(securityToken, wikitty);
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return delegate.canDelete(securityToken, wikittyId);
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        return delegate.canRead(securityToken, wikittyId);
    }

    @Override
    public boolean exists(String securityToken, String wikittyId) {
        return delegate.exists(securityToken, wikittyId);
    }

    @Override
    public boolean isDeleted(String securityToken, String wikittyId) {
        return delegate.isDeleted(securityToken, wikittyId);
    }
}
