/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: Wikitty.java 588 2010-12-09 23:30:35Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.3/wikitty-api/src/main/java/org/nuiton/wikitty/entities/Wikitty.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface Wikitty extends Cloneable, Serializable {

    void addPropertyChangeListener(PropertyChangeListener listener);

    void removePropertyChangeListener(PropertyChangeListener listener);

    void addPropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    void removePropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    /**
     * Replace all field of current wikitty with field found in w.
     * This two wikitty must have same id
     * @param w wikitty where we take information
     */
    void replaceWith(Wikitty w);

    /**
     * Replace all field of current wikitty with field found in w.
     * This two wikitty must have same id if force is false
     * @param w wikitty where we take information
     */
    void replaceWith(Wikitty w, boolean force);

    String getId();

    boolean isDeleted();

    Date getDeleteDate();

    /**
     * Server only used
     * @param delete
     */
    void setDeleteDate(Date delete);

    void addExtension(WikittyExtension ext);

    void addExtension(List<WikittyExtension> exts);

    /** check that the wikitty has a metaExtension about a given extension.
     * @param metaExtensionName the metaExtension to be checked
     * @param extensionName an extension already added to the wikitty
     * @since 2.2.0
     */
    boolean hasMetaExtension(String metaExtensionName,
                             String extensionName);

    /** add a meta-extension about the given extension to this wikitty.
     * @param metaExtension the metaExtension to add
     * @param extension an extension already added to the wikitty
     * @since 2.1
     */
    void addMetaExtension(WikittyExtension metaExtension,
                          WikittyExtension extension);


    /** add a meta-extension on the given extension to this wikitty.
     * @param metaExtension the metaExtension to add
     * @param extensionFqn the name of the extension already added to the wikitty
     * @since 2.1
     */
    void addMetaExtension(WikittyExtension metaExtension, String extensionFqn);

    boolean hasExtension(String extName);

    boolean hasField(String extName, String fieldName);

    WikittyExtension getExtension(String ext);

    Collection<String> getExtensionNames();

    Collection<WikittyExtension> getExtensions();

    Collection<WikittyExtension> getExtensionDependencies(String ext,
            boolean recursively);

    /**
     * return field type for the given fieldName.
     * @param fqfieldName fully qualified fieldName extension.fieldname
     * @return field type
     */
    FieldType getFieldType(String fqfieldName);

    void setField(String ext, String fieldName, Object value);

    Object getFieldAsObject(String ext, String fieldName);

    byte[] getFieldAsBytes(String ext, String fieldName);

    boolean getFieldAsBoolean(String ext, String fieldName);

    BigDecimal getFieldAsBigDecimal(String ext, String fieldName);

    int getFieldAsInt(String ext, String fieldName);

    long getFieldAsLong(String ext, String fieldName);

    float getFieldAsFloat(String ext, String fieldName);

    double getFieldAsDouble(String ext, String fieldName);

    String getFieldAsString(String ext, String fieldName);

    Date getFieldAsDate(String ext, String fieldName);

    /**
     * return wikitty id and not wikitty objet because this method can be call
     * on server or client side and it's better to keep conversion between id
     * and objet to the caller
     * @param ext extension name where this field must to be
     * @param fieldName the field name
     * @return id of wikitty object or null
     * @throws org.nuiton.wikitty.WikittyException
     */
    String getFieldAsWikitty(String ext, String fieldName);

    /**
     * If object is a set, it is automatically transform to list.
     * @param <E>
     * @param clazz
     * @return unmodifiable list
     */
    <E> List<E> getFieldAsList(String ext, String fieldName,
            final Class<E> clazz);

    /**
     *
     * @param <E>
     * @param clazz
     * @return unmodifiable list
     */
    <E> Set<E> getFieldAsSet(String ext, String fieldName, final Class<E> clazz);

    void addToField(String ext, String fieldName, Object value);

    void removeFromField(String ext, String fieldName, Object value);

    void clearField(String ext, String fieldName);

    /**
     * Add an element in a field
     * @param fqFieldName the fully qualified name of a collection field
     * @param value the value to be added to the collection
     * @since 2.2.0
     */
    void addToField(String fqFieldName, Object value);

    /**
     * Remove an element from a field
     * @param fqFieldName the fully qualified name of a collection field
     * @param value the value to be removed to the collection
     * @since 2.2.0
     */
    void removeFromField(String fqFieldName, Object value);

    /**
     * Clear a field
     * @param fqFieldName the fully qualified name of a collection field
     * @since 2.2.0
     */
    void clearField(String fqFieldName);

    Set<String> fieldNames();

    /** get the value of and field given its fqn */
    Object getFqField(String fqFieldName);

    String getVersion();

    /**
     * Server only used
     * @param version
     */
    void setVersion(String version);

    /**
     * get the field modified after wikitty was restored
     * @return a set of fully qualified field names
     * @since 2.2.0
     */
    Set<String> getDirty();

    /** clear the lists of modified field since last restore. */
    void clearDirty();


    /** set the value of a field given is fqn.
     * @param fieldName fqn (ex: extensionName.fieldName)
     * @param value new value
     */
    void setFqField(String fieldName, Object value);

    boolean isEmpty();

    /**
     * @see Object#clone()
     */
    Wikitty clone() throws CloneNotSupportedException;

}