/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  class WikittyTreeNodeHelper {

    /**
     * WikittyTreeNodeHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyTreeNodeHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME, name);
        return oldValue;
}

    /**
     * getAttachment :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getAttachment(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, String.class);
        return result;
}

    /**
     * setAttachment :
     * @param wikitty 
     * @param attachment 
     */

    public static void setAttachment(Wikitty wikitty, Set<String> attachment) {
        clearAttachment(wikitty);
        addAllAttachment(wikitty, attachment);
}

    /**
     * addAllAttachment :
     * @param wikitty 
     * @param attachment 
     */

    public static void addAllAttachment(Wikitty wikitty, Set<String> attachment) {
        if(attachment != null){
            for (String id:attachment){
                addAttachment(wikitty, id);
            }
        }
}

    /**
     * addAttachment :
     * @param wikitty 
     * @param element 
     */

    public static void addAttachment(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, element);
}

    /**
     * removeAttachment :
     * @param wikitty 
     * @param element 
     */

    public static void removeAttachment(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, element);
}

    /**
     * clearAttachment :
     * @param wikitty 
     */

    public static void clearAttachment(Wikitty wikitty) {
        wikitty.clearField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT);
}

    /**
     * getParent :
     * @param wikitty 
     * @return String 
     */

    public static String getParent(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT);
        return value;
}

    /**
     * setParent :
     * @param wikitty 
     * @param parent 
     * @return String 
     */

    public static String setParent(Wikitty wikitty, String parent) {
        String oldValue = getParent(wikitty);
        wikitty.setField(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT, parent);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME);
            Object f2 = w2.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT);
            Object f2 = w2.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT);
            Object f2 = w2.getFieldAsObject(WikittyTreeNode.EXT_WIKITTYTREENODE, WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyTreeNode.EXT_WIKITTYTREENODE);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyTreeNodeAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //WikittyTreeNodeHelper
