/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class WikittyTokenAbstract extends BusinessEntityImpl implements WikittyToken {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyToken;
    /**
     * getUser :
     * @return String 
     */

    @Override
    public String getUser() {
        String value = WikittyTokenHelper.getUser(getWikitty());
        return value;
}

    /**
     * setUser :
     * @param user 
     */

    @Override
    public void setUser(String user) {
        String oldValue = getUser();
        WikittyTokenHelper.setUser(getWikitty(), user);
        getPropertyChangeSupport().firePropertyChange(WikittyToken.FIELD_WIKITTYTOKEN_USER, oldValue, getUser());
}

    /**
     * getDate :
     * @return Date 
     */

    @Override
    public Date getDate() {
        Date value = WikittyTokenHelper.getDate(getWikitty());
        return value;
}

    /**
     * setDate :
     * @param date 
     */

    @Override
    public void setDate(Date date) {
        Date oldValue = getDate();
        WikittyTokenHelper.setDate(getWikitty(), date);
        getPropertyChangeSupport().firePropertyChange(WikittyToken.FIELD_WIKITTYTOKEN_DATE, oldValue, getDate());
}

    /**
     * WikittyTokenAbstract :
     */

    public WikittyTokenAbstract() {
        super();
}

    /**
     * WikittyTokenAbstract :
     * @param wikitty 
     */

    public WikittyTokenAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyTokenAbstract :
     * @param businessEntityImpl 
     */

    public WikittyTokenAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyToken =
                new WikittyExtension(EXT_WIKITTYTOKEN,
                                     "2.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Wikitty user unique=\"true\"", 
                                             "Date date unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyToken);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyTokenAbstract
