/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.conform;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.RunWith;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:META-INF/spring/wikitty-test.xml"})
public abstract class AbstractTestConformance {
    public static final String EXTNAME = "wikittyExt";
    public static final String EXTREQUIRED = "wikittyRequired";
    public static final String EXTREQUIRES = "wikittyRequires";
    protected static final Log log = LogFactory.getLog(AbstractTestConformance.class);
    public static final WikittyExtension EXT_REQUIRED = AbstractTestConformance.createExtension("wikittyRequired", null, new FieldType[0]);
    public static final WikittyExtension EXT_REQUIRES = AbstractTestConformance.createExtension("wikittyRequires", "wikittyRequired", new FieldType[0]);
    public static final WikittyExtension EXT_TEST = AbstractTestConformance.createExtension("wikittyExt", null, AbstractTestConformance.createType(FieldType.TYPE.STRING, 0, 1), AbstractTestConformance.createType(FieldType.TYPE.NUMERIC, 1, 1), AbstractTestConformance.createType(FieldType.TYPE.DATE, 1, 1));
    @Autowired
    protected WikittyService ws;

    public WikittyService getWikittyService() {
        return this.ws;
    }

    public void setWikittyService(WikittyService wikittyService) {
        this.ws = wikittyService;
    }

    protected static FieldType createType(FieldType.TYPE type, int lower, int upper) {
        FieldType fieldType = new FieldType(type, lower, upper);
        return fieldType;
    }

    protected static Wikitty createBasicWikitty() {
        return AbstractTestConformance.createWikitty(EXT_TEST);
    }

    protected static Wikitty createWikitty(WikittyExtension ... extensions) {
        WikittyImpl w = new WikittyImpl();
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
        return w;
    }

    protected static WikittyExtension createExtension(String extName, String requires, FieldType ... types) {
        LinkedHashMap<String, FieldType> fieldsMap = new LinkedHashMap<String, FieldType>();
        for (int i = 0; i < types.length; ++i) {
            fieldsMap.put("fieldName" + i, types[i]);
        }
        return new WikittyExtension(extName, "1", requires, fieldsMap);
    }

    public static String format(String dateTestFormat) {
        try {
            return WikittyUtil.formatDate((Date)(dateTestFormat == null || dateTestFormat.isEmpty() ? new Date() : AbstractTestConformance.parse(dateTestFormat)));
        }
        catch (ParseException e) {
            Assert.fail((String)("Error format date : " + dateTestFormat));
            e.printStackTrace();
            return null;
        }
    }

    public static Date parse(String dateAsString) {
        try {
            return WikittyUtil.parseDate((String)dateAsString);
        }
        catch (ParseException e) {
            Assert.fail((String)("Error parsing date : " + dateAsString));
            e.printStackTrace();
            return null;
        }
    }

    protected static ArrayList<Wikitty> createSampleWikitty(WikittyService ws) {
        String[] wValues;
        ArrayList<Wikitty> result = new ArrayList<Wikitty>();
        for (String wValue : wValues = new String[]{"fieldName0 = table,fieldName1 = 003300,fieldName2 = " + AbstractTestConformance.format("23/01/1982"), "fieldName0 = chaise,fieldName1 = 113311,fieldName2 = " + AbstractTestConformance.format("26/09/2009"), "fieldName0 = bureau,fieldName1 = 223322,fieldName2 = " + AbstractTestConformance.format("25/12/2029")}) {
            Wikitty w = AbstractTestConformance.createWikitty(wValue, EXTNAME, EXT_TEST);
            result.add(w);
        }
        ws.store(null, result);
        return result;
    }

    public static Wikitty createWikitty(String values, String defaultExtName, WikittyExtension ... exts) {
        WikittyImpl w = new WikittyImpl();
        for (WikittyExtension ext : exts) {
            w.addExtension(ext);
        }
        for (Map.Entry<String, String> keyValuePair : AbstractTestConformance.getKeyPairs(values)) {
            String[] s = keyValuePair.getKey().split("\\.");
            String fieldName = null;
            String extName = null;
            if (s.length > 1) {
                fieldName = s[1].trim();
                extName = s[0].trim();
            } else {
                fieldName = s[0].trim();
                extName = defaultExtName;
            }
            w.setField(extName, fieldName, (Object)keyValuePair.getValue());
        }
        return w;
    }

    protected static Iterable<Map.Entry<String, String>> getKeyPairs(String values) {
        LinkedHashMap<String, String> keyPairs = new LinkedHashMap<String, String>();
        for (String keyValuePair : values.split(",")) {
            String[] l = keyValuePair.split("=");
            String key = l[0].trim();
            String value = l.length > 1 ? l[1].trim() : null;
            keyPairs.put(key, value);
        }
        return keyPairs.entrySet();
    }
}

