package org.nuiton.wikitty;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.Status;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/***
 * Manage JTA transaction. You can store some information during execution.
 */
public class WikittyTransaction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyTransaction.class);

    /** permet d'attacher n'importe quoi a une transaction */
    protected Map<Object, Object> tagValues;

    /** cache static utilise par le WikittyServiceCached */
    transient protected WikittyCache cache = null;

    public WikittyTransaction() {
        tagValues = new HashMap<Object, Object>();
    }

    /**
     * Visibilite 'default' car est uilise par WikittyServiceCached qui est dans
     * le meme package et a priori seulement lui en a besoin
     * 
     * @return
     */
    WikittyCache getCache() {
       if (cache == null) {
           cache = new WikittyCache();
        }
        return cache;
    }

    public Object getTagValue(Object tag) {
        return tagValues.get(tag);
    }

    public void setTagValue(Object tag, Object value) {
        tagValues.put(tag, value);
    }

    public UserTransaction getUserTransaction() {
        return com.arjuna.ats.jta.UserTransaction.userTransaction();
    }

    public TransactionManager getTransactionManager() {
        return com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    public void begin() {
        UserTransaction userTransaction = getUserTransaction();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Begin transaction");
            }
            userTransaction.setTransactionTimeout(3600); // FIXME: jru 20100115 error in service if call during lot of times
            userTransaction.begin();
        } catch (Exception eee) {
            throw new WikittyException("Error on begin JTA transaction", eee);
        }
    }

    public void commit() {
        UserTransaction userTransaction = getUserTransaction();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Commit transaction");
            }
            userTransaction.commit();
        } catch (Exception eee) {
            throw new WikittyException("Error on commit JTA transaction", eee);
        }
    }

    public void rollback() {
        UserTransaction userTransaction = getUserTransaction();
        try {
            if(userTransaction.getStatus() != Status.STATUS_NO_TRANSACTION
                    && userTransaction.getStatus() != Status.STATUS_UNKNOWN) {
                if (log.isDebugEnabled()) {
                    log.debug("Rollback transaction");
                }
                userTransaction.rollback();
            }
        } catch (Exception eee) {
            throw new WikittyException("Error on roolback JTA transaction", eee);
        }
    }
}
