package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  class TreeNodeHelper {

    /**
     * TreeNodeHelper :
     * utility class all provided methods are accessible the static way
     */

    private TreeNodeHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_NAME, name);
        return oldValue;
}

    /**
     * getAttachment :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getAttachment(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_ATTACHMENT, String.class);
        return result;
}

    /**
     * addAttachment :
     * @param wikitty 
     * @param element 
     */

    public static void addAttachment(Wikitty wikitty, String element) {
        wikitty.addToField(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_ATTACHMENT, element);
}

    /**
     * removeAttachment :
     * @param wikitty 
     * @param element 
     */

    public static void removeAttachment(Wikitty wikitty, String element) {
        wikitty.removeFromField(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_ATTACHMENT, element);
}

    /**
     * clearAttachment :
     * @param wikitty 
     */

    public static void clearAttachment(Wikitty wikitty) {
        wikitty.clearField(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_ATTACHMENT);
}

    /**
     * getParent :
     * @param wikitty 
     * @return String 
     */

    public static String getParent(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_PARENT);
        return value;
}

    /**
     * setParent :
     * @param wikitty 
     * @param parent 
     * @return String 
     */

    public static String setParent(Wikitty wikitty, String parent) {
        String oldValue = getParent(wikitty);
        wikitty.setField(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_PARENT, parent);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_NAME);
            Object f2 = w2.getFieldAsObject(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_ATTACHMENT);
            Object f2 = w2.getFieldAsObject(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_ATTACHMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_PARENT);
            Object f2 = w2.getFieldAsObject(TreeNode.EXT_TREENODE, TreeNode.FIELD_TREENODE_PARENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(TreeNode.EXT_TREENODE);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : TreeNodeAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //TreeNodeHelper
