/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.memory;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.wikitty.ExtensionFactory;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyServiceInMemory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.api.AbstractTestApi;

public class InMemoryStorageTest
extends AbstractTestApi {
    protected WikittyServiceInMemory wikittyService;
    protected static DateFormat dateFormater = new SimpleDateFormat("dd/MM/yyyy");

    @Before
    public void init() throws Exception {
        this.wikittyService = new WikittyServiceInMemory();
    }

    @Test
    public void testFilePersistance() throws Exception {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        tmp.mkdirs();
        File tempPersistFile = File.createTempFile(InMemoryStorageTest.class.getName(), ".tmp");
        tempPersistFile.delete();
        tempPersistFile.deleteOnExit();
        this.wikittyService = new WikittyServiceInMemory(tempPersistFile);
        String extName = "MyExtName";
        WikittyExtension ext = ExtensionFactory.create((String)"MyExtName", (String)"1").addField("fieldName0", FieldType.TYPE.NUMERIC).addField("fieldName1", FieldType.TYPE.NUMERIC).addField("fieldName2", FieldType.TYPE.DATE).extension();
        Date date = dateFormater.parse("30/01/2009");
        Wikitty w = this.createWikitty("MyExtName.fieldName0 = 123,MyExtName.fieldName1 = 12.3,MyExtName.fieldName2 = " + WikittyUtil.formatDate((Date)date), ext);
        String id = w.getId();
        this.wikittyService.store(null, w);
        this.wikittyService.saveToPersistenceFile();
        this.wikittyService = new WikittyServiceInMemory(tempPersistFile);
        w = this.wikittyService.restore(null, id);
        Assert.assertTrue((boolean)w.hasField(extName, "fieldName0"));
        Assert.assertEquals((int)123, (int)w.getFieldAsInt(extName, "fieldName0"));
        Assert.assertTrue((boolean)w.hasField(extName, "fieldName1"));
        Assert.assertEquals((Object)Float.valueOf(12.3f), (Object)Float.valueOf(w.getFieldAsFloat(extName, "fieldName1")));
        Assert.assertTrue((boolean)w.hasField(extName, "fieldName2"));
        Assert.assertEquals((Object)date, (Object)w.getFieldAsDate(extName, "fieldName2"));
    }

    private Wikitty createWikitty(String wDef, WikittyExtension ... exts) {
        WikittyImpl w = new WikittyImpl();
        w.addExtension(Arrays.asList(exts));
        for (String line : wDef.split(",")) {
            int eqIdx = line.indexOf(61);
            String value = line.substring(eqIdx + 1).trim();
            String key = eqIdx >= 0 ? line.substring(0, eqIdx) : "";
            int dotIdx = key.indexOf(46);
            String fieldName = key.substring(dotIdx + 1).trim();
            String extName = dotIdx >= 0 ? key.substring(0, dotIdx) : "";
            w.setField(extName, fieldName, (Object)value);
        }
        return w;
    }

    @Test
    public void testRequire() throws Exception {
        WikittyExtension extension = new WikittyExtension("Extension", "1", null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"String value"}));
        WikittyExtension extension1 = new WikittyExtension("Extension1", "1", "Extension", WikittyUtil.buildFieldMapExtension((String[])new String[]{"String value"}));
        WikittyExtension extension11 = new WikittyExtension("Extension11", "1", "Extension1", WikittyUtil.buildFieldMapExtension((String[])new String[]{"String value"}));
        WikittyExtension extension2 = new WikittyExtension("Extension2", "1", "Extension", WikittyUtil.buildFieldMapExtension((String[])new String[]{"String value"}));
        Wikitty wikitty = this.createWikitty("Extension.value = 123", extension, extension1, extension11, extension2);
        Collection result = wikitty.getExtensionDependencies("Extension", true);
        Assert.assertEquals((int)3, (int)result.size());
        result = wikitty.getExtensionDependencies("Extension", false);
        Assert.assertEquals((int)2, (int)result.size());
        result = wikitty.getExtensionDependencies("Extension1", true);
        Assert.assertEquals((int)1, (int)result.size());
        result = wikitty.getExtensionDependencies("Extension2", true);
        Assert.assertEquals((int)0, (int)result.size());
    }
}

