/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittySearchEngin.java 417 2010-10-15 15:24:44Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-2.2.2/wikitty-api/src/main/java/org/nuiton/wikitty/WikittySearchEngin.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.wikitty;

import java.util.Collection;
import java.util.Map;

/**
 * WikittySearchEngin is used to abstract search engine used in WikittyService.
 *
 *
 * @author poussin
 * @version $Revision: 417 $
 *
 * Last update: $Date: 2010-10-15 17:24:44 +0200 (ven., 15 oct. 2010) $
 * by : $Author: sletellier $
 */
public interface WikittySearchEngin {

    /**
     * Remove all data in index
     */
    public void clear(WikittyTransaction transaction);

    /**
     * Store wikitty in storage
     * @return information usefull for client side update data
     */
    public UpdateResponse store(WikittyTransaction transaction,
            Collection<Wikitty> wikitties);

    /**
     * Delete all object with idList argument. If id is not valid or don't exist.
     * 
     * @param idList list of ids to delete
     * @return <code>UpdateResponse</code>>
     * @throws WikittyException
     */
    public UpdateResponse delete(WikittyTransaction transaction,
            Collection<String> idList) throws WikittyException;

    /**
     * Delete all object with idList argument. idList is directly passed to search engine
     * and is processed without any other kind of treatment.
     * 
     * @param idList list of ids to delete
     * @return <code>UpdateResponse</code>
     * @throws WikittyException
     */
    public void delete(Collection<String> idList) throws WikittyException;
    
    public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria);

    /**
     * Find count of child for a node
     * @param w
     * @return
     */
    public Integer findNodeCount(WikittyTransaction transaction, Wikitty w, Criteria filter);

    /**
     * Find all children ids with count for a node wikitty.
     * @param w
     * @return
     */
    public Map<String, Integer> findAllChildrenCount(WikittyTransaction transaction, Wikitty w, Criteria filter);

}
