/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: UpdateResponse.java 439 2010-10-20 22:26:21Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-2.2.2/wikitty-api/src/main/java/org/nuiton/wikitty/UpdateResponse.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UpdateResponse implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5908785223965002731L;

    protected Map<String, String> idVersionMap = new HashMap<String, String>();
    protected Map<String, Date> idDeletionDateMap = new HashMap<String, Date>();
    
    public UpdateResponse() {
        super();
        idVersionMap = new HashMap<String, String>();
    }

    /**
     * Merge all update passed in argument in local update list
     * @param update
     */
    public void add(UpdateResponse update) {
        idVersionMap.putAll(update.idVersionMap);
        idDeletionDateMap.putAll(update.idDeletionDateMap);
    }

    public void addVersionUpdate( String id, String version ) {
        idVersionMap.put(id, version);
    }

    public void addDeletionDateUpdate(String id, Date date) {
        idDeletionDateMap.put(id, date);
    }
//    @Deprecated
//    public void update(BusinessEntity e) {
//        update((BusinessEntityWikitty) e);
//    }

//    @Deprecated
//    public void update(BusinessEntityWikitty e) {
//        update(e.getWikitty());
//    }

    /**
     * Update data directly in object passed in argument.
     * Actualy only version and deletion date are updated.
     * And internaly wikitty object is marked clean (not dirty)
     * @param e
     */
    public void update(Wikitty e) {
        // update version
        String id = e.getId();
        String version = idVersionMap.get(id);
        if (version != null) {
            e.setVersion(version);
        }
        Date date = idDeletionDateMap.get(id);
        if (date != null) {
            e.setDeleteDate(date);
        }
        e.clearDirty();
    }

}
