/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.importexport;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImportExportService;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.importexport.ImportExportCSV;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:META-INF/spring/wikitty-test.xml"})
public class ImportExportCSVTest {
    @Autowired
    protected WikittyService ws;
    protected static final WikittyExtension extensionClient = new WikittyExtension("Client", "1.0", null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name"}));
    protected static final WikittyExtension extensionTag = new WikittyExtension("Tag", "1.0", null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"String tags"}));

    public WikittyService getWikittyService() {
        return this.ws;
    }

    public void setWikittyService(WikittyService wikittyService) {
        this.ws = wikittyService;
    }

    @Test
    public void testQueryPattern() {
        ImportExportCSV task = new ImportExportCSV();
        Pattern pattern = task.queryPattern;
        Matcher m = pattern.matcher("rtet");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client=4e2e4a93-c412-46b8-beb9-e76e0f16740d");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client=4e2e4a93-c412-46b8-beb9-e76e0f16740d");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client.name=toto");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"Client.name", (Object)m.group(1));
        Assert.assertEquals((Object)"Client", (Object)m.group(2));
        Assert.assertEquals((Object)"name", (Object)m.group(3));
        Assert.assertEquals((Object)"toto", (Object)m.group(4));
        m = pattern.matcher("Client.name=toto");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"toto", (Object)m.group(6));
        m = pattern.matcher("Client.name=\"toto\"");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"toto", (Object)m.group(5));
        m = pattern.matcher("Client.name=\"toto");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client.name=\"to\"to\"");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"to\"to", (Object)m.group(5));
        m = pattern.matcher("Client.name=toto\"");
        Assert.assertFalse((boolean)m.find());
    }

    @Test
    public void testMultipleFieldsParsing() {
        String test = "(sdfsdf),(dfsdf),(fdsfsdfg),(sdfsdfqs)";
        String[] result = StringUtil.split((String)test);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertEquals((Object)"(sdfsdf)", (Object)result[0]);
        Assert.assertEquals((Object)"sdfsdf", (Object)result[0].substring(1, result[0].length() - 1));
        Assert.assertEquals((Object)"(dfsdf)", (Object)result[1]);
        Assert.assertEquals((Object)"(fdsfsdfg)", (Object)result[2]);
        Assert.assertEquals((Object)"(sdfsdfqs)", (Object)result[3]);
        test = "(sdf\",\"sdf),(df()sdf),(fds\"(),()\"fsdfg),(sdfsdfqs)";
        result = StringUtil.split((String)test);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertEquals((Object)"(sdf\",\"sdf)", (Object)result[0]);
        Assert.assertEquals((Object)"(df()sdf)", (Object)result[1]);
        Assert.assertEquals((Object)"(fds\"(),()\"fsdfg)", (Object)result[2]);
        Assert.assertEquals((Object)"(sdfsdfqs)", (Object)result[3]);
        test = "toto ?";
        result = StringUtil.split((String)test);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)"toto ?", (Object)result[0]);
    }

    @Test
    public void testImport() {
        String[] importFiles;
        WikittyProxy proxy = new WikittyProxy(this.ws);
        proxy.storeExtension(extensionClient);
        proxy.storeExtension(TreeNodeImpl.extensionTreeNode);
        proxy.storeExtension(extensionTag);
        WikittyImportExportService wsImport = new WikittyImportExportService(null, this.ws);
        for (String importFile : importFiles = new String[]{"/csv/importclient.csv", "/csv/importtree.csv", "/csv/importtree2.csv"}) {
            URL importFileURL = ImportExportCSVTest.class.getResource(importFile);
            wsImport.syncImportFromUri(WikittyImportExportService.FORMAT.CSV, importFileURL.toExternalForm());
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, extensionTag.getName()).criteria();
        PagedResult pagedResult = this.ws.findAllByCriteria(null, criteria);
        Assert.assertEquals((long)1L, (long)pagedResult.getNumFound());
        Criteria criteria2 = Search.query().eq(extensionClient.getName() + ".name", "Toto").criteria();
        PagedResult pagedResult2 = this.ws.findAllByCriteria(null, criteria2);
        Assert.assertEquals((long)1L, (long)pagedResult2.getNumFound());
        Criteria criteria3 = Search.query().eq("TreeNode.name", "MyTreeNode").criteria();
        PagedResult pagedResult3 = proxy.findAllByCriteria(TreeNode.class, criteria3);
        Assert.assertEquals((long)1L, (long)pagedResult3.getNumFound());
        TreeNode myTreeNode = (TreeNode)pagedResult3.getFirst();
        Assert.assertEquals((long)1L, (long)myTreeNode.getAttachment().size());
        Criteria criteria4 = Search.query().eq("TreeNode.parent", myTreeNode.getWikittyId()).criteria();
        PagedResult pagedResult4 = proxy.findAllByCriteria(TreeNode.class, criteria4);
        Assert.assertEquals((long)1L, (long)pagedResult4.getNumFound());
        TreeNode mySubNode = (TreeNode)pagedResult4.getFirst();
        Assert.assertEquals((Object)"MySubNode", (Object)mySubNode.getName());
    }
}

