/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.importexport;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FacetTopic;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.importexport.ImportExportMethod;
import org.nuiton.wikitty.importexport.WikittyBatchUpdate;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class ImportExportCSV
implements ImportExportMethod {
    private static Log log = LogFactory.getLog(ImportExportCSV.class);
    protected static final String FIELD_WIKITTY_ID = "Wikitty.Id";
    protected Pattern queryPattern = Pattern.compile("^((\\w+)\\.(\\w+))=(\"(.+)\"|([^\"]+))$");

    @Override
    public void importReader(String securityToken, Reader reader, WikittyService ws, WikittyTransaction transaction, WikittyBatchUpdate batchUpdate) throws Exception {
        String[] currentLine;
        int wikittyIdIndex = -1;
        CSVReader csvReader = new CSVReader(reader);
        String[] header = csvReader.readNext();
        String[] ext = new String[header.length];
        String[] fieldsName = new String[header.length];
        for (int i = 0; i < header.length; ++i) {
            if (FIELD_WIKITTY_ID.equals(header[i])) {
                wikittyIdIndex = i;
                continue;
            }
            ext[i] = header[i].substring(0, header[i].indexOf("."));
            fieldsName[i] = header[i].substring(header[i].indexOf(".") + 1);
        }
        while ((currentLine = csvReader.readNext()) != null) {
            String wikittyId = "";
            if (wikittyIdIndex != -1) {
                wikittyId = currentLine[wikittyIdIndex];
            }
            WikittyImpl currentWikitty = StringUtils.isNotEmpty((String)wikittyId) ? new WikittyImpl(wikittyId) : new WikittyImpl();
            for (int i = 0; i < header.length; ++i) {
                if (i == wikittyIdIndex) continue;
                String extName = ext[i];
                String fieldName = fieldsName[i];
                String value = currentLine[i];
                if (!StringUtils.isNotEmpty((String)value)) continue;
                this.addMissingExtension(securityToken, ws, transaction, currentWikitty, extName);
                value = this.convertLinkValues(securityToken, transaction, ws, value);
                FieldType fieldType = currentWikitty.getFieldType(extName + "." + fieldName);
                if (fieldType.isCollection()) {
                    String[] multiplesValues;
                    for (String multiplesValue : multiplesValues = StringUtil.split((String)value)) {
                        if (multiplesValue.startsWith("(") && multiplesValue.endsWith(")")) {
                            multiplesValue = multiplesValue.substring(1, multiplesValue.length() - 1);
                        }
                        currentWikitty.addToField(extName, fieldName, multiplesValue);
                    }
                    continue;
                }
                currentWikitty.setField(extName, fieldName, value);
            }
            batchUpdate.addWikitty(currentWikitty);
        }
    }

    protected void addMissingExtension(String securityToken, WikittyService ws, WikittyTransaction transaction, Wikitty currentWikitty, String extName) {
        if (!currentWikitty.hasExtension(extName)) {
            WikittyExtension extension = ws.restoreExtensionLastVersion(securityToken, transaction, extName);
            if (extension != null) {
                String requires = extension.getRequires();
                if (StringUtils.isNotEmpty((String)requires)) {
                    for (String require : requires.split(",")) {
                        String localRequire = require.trim();
                        this.addMissingExtension(securityToken, ws, transaction, currentWikitty, localRequire);
                    }
                }
                currentWikitty.addExtension(extension);
            } else {
                throw new WikittyException("Extension " + extName + " does not exist");
            }
        }
    }

    protected String convertLinkValues(String securityToken, WikittyTransaction transaction, WikittyService ws, String value) {
        boolean correctQueries;
        String resultValue;
        String originalValue;
        block7: {
            originalValue = value;
            resultValue = "";
            String separator = "";
            correctQueries = true;
            try {
                String[] queries;
                for (String query : queries = StringUtil.split((String)value, (String)",")) {
                    Matcher m = this.queryPattern.matcher(query.trim());
                    if (m.find()) {
                        Criteria criteria;
                        Wikitty wikitty;
                        String fqField = m.group(1);
                        String fValue = m.group(5);
                        if (fValue == null) {
                            fValue = m.group(6);
                        }
                        if ((wikitty = ws.findByCriteria(securityToken, transaction, criteria = Search.query().eq(fqField, fValue).criteria())) == null) {
                            correctQueries = false;
                            continue;
                        }
                        resultValue = resultValue + separator + wikitty.getId();
                        separator = ",";
                        continue;
                    }
                    correctQueries = false;
                }
            }
            catch (StringIndexOutOfBoundsException eee) {
                if (!log.isTraceEnabled()) break block7;
                log.trace((Object)"Can't split field on , skipping");
            }
        }
        if (!correctQueries || StringUtils.isEmpty((String)resultValue)) {
            resultValue = originalValue;
        }
        return resultValue;
    }

    @Override
    public void exportWriter(String securityToken, Writer writer, WikittyService ws, WikittyTransaction transaction, PagedResult<Wikitty> pagedResult) throws Exception {
        CSVWriter csvWriter = new CSVWriter(writer);
        LinkedList<String> extensionHeader = new LinkedList<String>();
        extensionHeader.add(FIELD_WIKITTY_ID);
        for (FacetTopic topic : pagedResult.getTopic(Element.ELT_EXTENSION)) {
            String extName = topic.getTopicName();
            WikittyExtension extension = ws.restoreExtensionLastVersion(securityToken, transaction, extName);
            String ext = WikittyExtension.computeName(extName);
            for (String fieldName : extension.getFieldNames()) {
                extensionHeader.add(ext + "." + fieldName);
            }
        }
        csvWriter.writeNext(extensionHeader.toArray(new String[extensionHeader.size()]));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting wikitty : " + pagedResult.getAll().size() + " results"));
        }
        List<Wikitty> wikitties = pagedResult.getAll();
        for (Wikitty w : wikitties) {
            String[] wikittyField = new String[extensionHeader.size()];
            wikittyField[extensionHeader.indexOf((Object)FIELD_WIKITTY_ID)] = w.getId();
            for (String fieldName : w.fieldNames()) {
                String currentField = "";
                FieldType type = w.getFieldType(fieldName);
                if (type.isCollection()) {
                    Object fqField = w.getFqField(fieldName);
                    if (fqField != null) {
                        String separator = "";
                        for (Object o : (Collection)fqField) {
                            String fqFieldValue = WikittyUtil.toString(type, o);
                            currentField = currentField + separator + "(" + fqFieldValue + ")";
                            separator = ",";
                        }
                    }
                } else {
                    String fqFieldValue;
                    currentField = fqFieldValue = WikittyUtil.toString(type, w.getFqField(fieldName));
                }
                wikittyField[extensionHeader.indexOf((Object)fieldName)] = currentField;
            }
            csvWriter.writeNext(wikittyField);
        }
        csvWriter.close();
    }
}

