package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class WikittyAuthorisationAbstract extends BusinessEntityWikitty implements WikittyAuthorisation {

    private static final long serialVersionUID = 1568911264L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionWikittyAuthorisation =
        new WikittyExtension(EXT_WIKITTYAUTHORISATION, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String Owner",
				"String Admin[0-*] unique=true",
				"String Writer[0-*] unique=true",
				"String Reader[0-*] unique=true",
				"String parent documentation=\"Pointe sur un autre WikittyAuthorisation qui permet d'indiquer que les droits de l'objet courant sont les mêmes que l'objet pointée. Les droits de l'objet courant s'ajoute au droit de l'objet pointé\""));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionWikittyAuthorisation);

        extensions = Collections.unmodifiableList(exts);
    }

	public WikittyAuthorisationAbstract() {
		super();
	}

    public WikittyAuthorisationAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public WikittyAuthorisationAbstract(Wikitty wi) {
		super(wi);
	}


    public void setOwner(String Owner) {
        Object oldValue = getField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_OWNER);
        getWikitty().setField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_OWNER, Owner);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_OWNER, oldValue, Owner);
    }

    public String getOwner() {
        String result = getWikitty().getFieldAsString(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_OWNER);
        return result;
    }

    public Set<String> getAdmin() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_ADMIN, String.class);
        return result;
    }

    public void addAdmin(String element) {
        getWikitty().addToField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_ADMIN, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
    }
    
    public void removeAdmin(String element) {
        getWikitty().removeFromField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_ADMIN, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
    }
    
    public void clearAdmin() {
        getWikitty().clearField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_ADMIN);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
    }

    public Set<String> getWriter() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_WRITER, String.class);
        return result;
    }

    public void addWriter(String element) {
        getWikitty().addToField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_WRITER, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
    }
    
    public void removeWriter(String element) {
        getWikitty().removeFromField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_WRITER, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
    }
    
    public void clearWriter() {
        getWikitty().clearField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_WRITER);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
    }

    public Set<String> getReader() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_READER, String.class);
        return result;
    }

    public void addReader(String element) {
        getWikitty().addToField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_READER, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
    }
    
    public void removeReader(String element) {
        getWikitty().removeFromField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_READER, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
    }
    
    public void clearReader() {
        getWikitty().clearField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_READER);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
    }


    public void setParent(String parent) {
        Object oldValue = getField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_PARENT);
        getWikitty().setField(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_PARENT, parent);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYAUTHORISATION_PARENT, oldValue, parent);
    }

    public String getParent() {
        String result = getWikitty().getFieldAsString(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_PARENT);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_OWNER);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_OWNER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_ADMIN);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_ADMIN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_WRITER);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_WRITER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_READER);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_READER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_PARENT);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYAUTHORISATION, FIELD_WIKITTYAUTHORISATION_PARENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //WikittyAuthorisationAbstract
