package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TreeNodeHelper extends TreeNodeImpl {

    private static final long serialVersionUID = 1877636640L;


    /**
     * This class is not instanciable, it's just helper
     */
    private TreeNodeHelper() {
    }


    static public void setName(Wikitty w, String name) {
        w.setField(EXT_TREENODE, TreeNode.FIELD_TREENODE_NAME, name);
    }

    static public String getName(Wikitty w) {
        String result = w.getFieldAsString(EXT_TREENODE, TreeNode.FIELD_TREENODE_NAME);
        return result;
    }


    static public void setParent(Wikitty w, String parent) {
        w.setField(EXT_TREENODE, TreeNode.FIELD_TREENODE_PARENT, parent);
    }

    static public String getParent(Wikitty w) {
        String result = w.getFieldAsString(EXT_TREENODE, TreeNode.FIELD_TREENODE_PARENT);
        return result;
    }

    static public Set<String> getChildren(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_TREENODE, TreeNode.FIELD_TREENODE_CHILDREN, String.class);
        return result;
    }

    static public void addChildren(Wikitty w, String element) {
        w.addToField(EXT_TREENODE, TreeNode.FIELD_TREENODE_CHILDREN, element);
    }
    
    static public void removeChildren(Wikitty w, String element) {
        w.removeFromField(EXT_TREENODE, TreeNode.FIELD_TREENODE_CHILDREN, element);
    }
    
    static public void clearChildren(Wikitty w) {
        w.clearField(EXT_TREENODE, TreeNode.FIELD_TREENODE_CHILDREN);
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_TREENODE);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_TREENODE, TreeNode.FIELD_TREENODE_NAME);
            Object f2 = w2.getFieldAsObject(EXT_TREENODE, TreeNode.FIELD_TREENODE_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_TREENODE, TreeNode.FIELD_TREENODE_PARENT);
            Object f2 = w2.getFieldAsObject(EXT_TREENODE, TreeNode.FIELD_TREENODE_PARENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_TREENODE, TreeNode.FIELD_TREENODE_CHILDREN);
            Object f2 = w2.getFieldAsObject(EXT_TREENODE, TreeNode.FIELD_TREENODE_CHILDREN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //TreeNodeHelper
