package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class SecurityTokenAbstract extends BusinessEntityWikitty implements SecurityToken {

    private static final long serialVersionUID = 733790430L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionSecurityToken =
        new WikittyExtension(EXT_SECURITYTOKEN, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String user"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionSecurityToken);

        extensions = Collections.unmodifiableList(exts);
    }

	public SecurityTokenAbstract() {
		super();
	}

    public SecurityTokenAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public SecurityTokenAbstract(Wikitty wi) {
		super(wi);
	}


    public void setUser(String user) {
        Object oldValue = getField(EXT_SECURITYTOKEN, FIELD_SECURITYTOKEN_USER);
        getWikitty().setField(EXT_SECURITYTOKEN, FIELD_SECURITYTOKEN_USER, user);
        getPropertyChangeSupport().firePropertyChange(FIELD_SECURITYTOKEN_USER, oldValue, user);
    }

    public String getUser() {
        String result = getWikitty().getFieldAsString(EXT_SECURITYTOKEN, FIELD_SECURITYTOKEN_USER);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SECURITYTOKEN, FIELD_SECURITYTOKEN_USER);
            Object f2 = w2.getFieldAsObject(EXT_SECURITYTOKEN, FIELD_SECURITYTOKEN_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //SecurityTokenAbstract
