/* *##% 
 * ToPIA :: SOA
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/
package org.nuiton.topia.generator;

import org.nuiton.eugene.models.object.*;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.topia.service.TopiaApplicationServiceAbstract;
import org.apache.commons.lang.StringUtils;


/**
* ServiceAbstractGenerator.java
*
* Created: 19 juin 2007
*
* @author dupont
* @version $Revision: 1732 $
*
* Le service abstrait etend TopiaApplicationServiceAbstract et implemente
* l'interface du service.
* 
* Genere l'implantation des methodes qui utilisent les methodes des DAO 
* et celles des entites.
*
* @see ServiceInterfaceGenerator
* @see TopiaApplicationServiceAbstract
*
* Mise a jour: $Date: 2009-12-20 17:29:38 +0100 (dim. 20 déc. 2009) $
* par : $Author: tchemit $
* @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.ServiceAbstractGenerator"
*/
public class ServiceAbstractGenerator extends ObjectModelGenerator {
	
    private static final Log log = LogFactory
            .getLog(ServiceAbstractGenerator.class);

    @Override
    public String getFilenameForInterface(ObjectModelInterface clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "Abstract.java";
    }

    @Override
    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
    	 
    	if (!interfacez.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_SERVICE)) {
            return;
        }
    	
    	// generer l'entete du service abstrait
    	generateInterfaceHeader(output, interfacez);

    	// generer les signatures des methodes metier du service
    	generateInterfaceOperations(output, interfacez);
	        
    	// generer les methodes etendues en modifiant les signatures pour eviter les doublons (findAllByAddress heritee de Person et Employee)
    	generateInheritedInterfaceOperations(output, interfacez);
	
    	// generer les signatures des methodes metier des entites
    	generateAssociatedClassOperations(output, interfacez);
	       
    	// generer les signatures des methodes des entites (getter/setter)
    	generateMethodsGetter(output, interfacez);

/*{
} //<%=interfacez.getName()%>
}*/
    }

    private void generateInterfaceHeader(Writer output, ObjectModelClassifier classifier) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        String classifierName = classifier.getName();
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
/*{<%=copyright%>
}*/
        }
/*{package <%=classifier.getPackageName()%>;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.service.TopiaApplicationServiceAbstract;
import org.nuiton.topia.framework.TopiaContextImplementor;}*/
    	
    	classifier.getInterfaces();
    	// ajouter les imports des interfaces de DAO
    	for (ObjectModelInterface parent : classifier.getInterfaces()) {
    		if(parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO)){            	
            	// récupérer la classe de l'object model correspondant à la DAO
    			String className = parent.getQualifiedName().replace("DAO", "");
            	String interfaceName = parent.getQualifiedName()+"Abstract";
/*{
import <%=interfaceName%>;
import <%=className%>;}*/
    		}
    	}
            	
        if (TopiaGeneratorUtil.hasDocumentation(classifier)) {
/*{
/**
 *
 * <%=classifier.getDocumentation()%>
 *)
}*/
        }
/*{

public abstract class <%=classifierName%>Abstract extends TopiaApplicationServiceAbstract implements <%=classifierName%> {
}*/
    }

    private void generateMethodsGetter(Writer output, ObjectModelClassifier classifier) throws IOException {
/*{
    public String[] getMethods(){
    	return methods;
    }
}*/
    }
    
    private void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
        	String opName = op.getName();
        	String opVisibility = op.getVisibility();
        	String opType = op.getReturnType();
/*{
    /**
     * Implementation a la charge du developpeur
}*/
            if (TopiaGeneratorUtil.hasDocumentation(op)) {
            	String opDocumentation = op.getDocumentation();
/*{     * <%=opName%> : <%=opDocumentation%>
}*/
            }
            Collection<ObjectModelParameter> params = op.getParameters();
            for(ObjectModelParameter param : params) {
            	String paramName = param.getName();
            	String paramDocumentation = param.getDocumentation();
/*{     * @param <%=paramName%> <%=paramDocumentation%>
}*/ 
            }
/*{     *)
    <%=opVisibility%> abstract <%=opType%> <%=opName%>(}*/
            String comma = "";
            for(ObjectModelParameter param : params){
            	String paramName = param.getName();
            	String paramType = param.getType();
/*{<%=comma%><%=paramType%> <%=paramName%>}*/
                comma = ", ";
            }
/*{)}*/
            Set<String> exceptions = op.getExceptions();
            comma = " throws ";
            for (String exception : exceptions) {
/*{<%=comma%><%=exception%>}*/
                comma = ", ";
            }
/*{;
}*/
        }
    }
    
    private void generateInheritedInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
    	
        for (ObjectModelInterface parent : classifier.getInterfaces()) {
            // pour tous les DAOInterface
            if(parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO)){
            	
            	// récupérer la classe de l'object model correspondant à la DAO
            	String entityClassName = parent.getQualifiedName().replace("DAO", "");
            	if(getModel().hasClass(entityClassName)){
            		ObjectModelClass clazz =  getModel().getClass(entityClassName);
            		String clazzName = clazz.getName();
            		String clazzFQN = clazz.getQualifiedName();
            		
            		if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            			return;  
            		}
/*{
    /**
     * Supprime l'entite <%=clazzName%> passee en parametre
     * @param entity l'entite a supprimer
     *)
	public void delete<%=clazzName%>(<%=clazzFQN%> entity) throws TopiaException{
		TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		dao.delete(entity);
	}

	/**
     * Creer l'entite <%=clazzName%> avec les proprietes passees en parametre
     * @param properties les proprietes de l'entite a creer
     *)
    public <%=clazzFQN%> create<%=clazzName%>(Object ... properties) throws TopiaException{
        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
        <%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
        <%=clazzName%> entity = (<%=clazzName%>) dao.create(properties);
        return entity;
    }
    
    /**
     * Mise a jour de l'entite <%=clazzName%> passee en parametre
     * @param entity l'entite a mettre a jour
     *)
    public <%=clazzFQN%> update<%=clazzName%>(<%=clazzFQN%> entity) throws TopiaException{
        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
        <%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
        <%=clazzName%> entit = (<%=clazzName%>) dao.update(entity);
        return entit;
    }
    
	/**
     * Retourne tous les <%=clazzName%> 
     * @return une liste
     *)
    public List<<%=clazzFQN%>> findAll<%=clazzName%>() throws TopiaException {
		TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		List<<%=clazzName%>> result = dao.findAll(); 
    	return result;
    }
    
    /**
     * Retourne le <%=clazzName%> par son TopiaId 
     * @return le <%=clazzName%>
     *)
    public <%=clazzFQN%> find<%=clazzName%>ByTopiaId(String v) throws TopiaException {
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(v); 
    	return entity;
    }   
}*/
            	    for (ObjectModelAttribute attr : clazz.getAttributes()) {
            		    if (!attr.isNavigable()) {
            		 	   continue;
                        }

            	        if (!GeneratorUtil.isNMultiplicity(attr)) {
            	            generateNoNMultiplicity(output, attr, clazz, false);
            	        } else {
            	            generateNMultiplicity(output, attr, clazz, false);
            	        }
            	    }

            	    if (clazz instanceof ObjectModelAssociationClass) {
            	        ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            	        for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
            	            if (attr != null) {
            	                if (!GeneratorUtil.isNMultiplicity(attr)) {
            	                   generateNoNMultiplicity(output, attr, clazz, true);
            	                } else {
            	                   generateNMultiplicity(output, attr, clazz, true);
            	                }
            	            }
            	        }
            		} 	    	    
            	}
            }
        }
    }
    
    protected void generateNoNMultiplicity(Writer output, ObjectModelAttribute attr, ObjectModelClass clazz, boolean isAssoc) throws IOException {
	    String propertyName = attr.getName();
	    if (!isAssoc && attr.hasAssociationClass()) {
	        propertyName = TopiaGeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName()) + "." + propertyName;
	    }
	    String clazzName = clazz.getName();
	    String clazzFQN = clazz.getQualifiedName();
/*{
    /**
     * Retourne le premier element trouve ayant comme valeur pour l'attribut
     * <%=attr.getName()%> le parametre
     * @param v la valeur que doit avoir <%=attr.getName()%>
     * @return un element ou null
     *)
    public <%=clazzFQN%> find<%=clazzName%>By<%=StringUtils.capitalize(attr.getName())%>(<%=attr.getType()%> v) throws TopiaException{
		TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = dao.findBy<%=StringUtils.capitalize(attr.getName())%>(v);
    	return entity;
    };
    
    /**
     * Retourne les elements ayant comme valeur pour l'attribut
     * <%=attr.getName()%> le parametre
     * @param v la valeur que doit avoir <%=attr.getName()%>
     * @return une liste
     *)
    public List<<%=clazzFQN%>> findAll<%=clazzName%>By<%=StringUtils.capitalize(attr.getName())%>(<%=attr.getType()%> v) throws TopiaException{
		TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		List<<%=clazzName%>> entityList = dao.findAllBy<%=StringUtils.capitalize(attr.getName())%>(v);
    	return entityList; 
    };
}*/
        if (attr.hasAssociationClass()) {
/*{
    /**
     * Retourne le premier element trouve ayant comme valeur pour l'attribut
     * <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%> le parametre
     * @param value la valeur que doit avoir <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>
     * @return un element ou null
     *)
    public <%=clazzFQN%> find<%=clazzName%>By<%=StringUtils.capitalize(attr.getAssociationClass().getName())%>(<%=attr.getAssociationClass().getQualifiedName()%> value) throws TopiaException{
		TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = dao.findBy<%=StringUtils.capitalize(attr.getName())%>(v);
    	return entity; 
    };
    
    /**
     * Retourne les elements ayant comme valeur pour l'attribut
     * <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%> le param�tre
     * @param value la valeur que doit avoir <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>
     * @return une liste
     *)
    public List<<%=clazzFQN%>> findAll<%=clazzName%>By<%=StringUtils.capitalize(attr.getAssociationClass().getName())%>(<%=attr.getAssociationClass().getQualifiedName()%> value) throws TopiaException{
		TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		List<<%=clazzName%>> entityList = dao.findAllBy<%=StringUtils.capitalize(attr.getName())%>(v);
    	return entityList;
    };
}*/
	    }
	}        
	        
    protected void generateNMultiplicity(Writer output, ObjectModelAttribute attr, ObjectModelClass clazz, boolean isAssoc) throws IOException {
	    String clazzName = clazz.getName();
	    String clazzFQN = clazz.getQualifiedName();
/*{    
    /**
     * Retourne le premier element trouve dont l'attribut
     * <%=attr.getName()%> contient le parametre
     * @param v la valeur que doit contenir <%=attr.getName()%>
     * @return un element ou null
     *)
    public <%=clazzFQN%> find<%=clazzName%>Contains<%=StringUtils.capitalize(attr.getName())%>(<%=attr.getType()%> ... v) throws TopiaException{
		TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>) dao.findContainsProperties("<%=TopiaGeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>", Arrays.asList(v)); 
    	return entity; 
    };
    
    /**
     * Retourne les elements trouve dont l'attribut
     * <%=attr.getName()%> contient le parametre
     * @param v la valeur que doit contenir <%=attr.getName()%>
     * @return une liste
     *)
    public List<<%=clazzFQN%>> findAll<%=clazzName%>Contains<%=StringUtils.capitalize(attr.getName())%>(<%=attr.getType()%> ... v) throws TopiaException{
		TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		List<<%=clazzName%>> entityList = dao.findAllContainsProperties("<%=TopiaGeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>", Arrays.asList(v)); 
    	return entityList;
    };
}*/        
	}


    private void generateAssociatedClassOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelInterface parent : classifier.getInterfaces()) {
            // pour tous les DAOInterface
            if(parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO)){
            	
            	// r�cup�rer la classe de l'object model correspondant � la DAO
            	String entityClassName;
            	entityClassName = parent.getQualifiedName().replace("DAO", "");
            	if(getModel().hasClass(entityClassName)){
            		ObjectModelClass clazz =  getModel().getClass(entityClassName);
                    generateFromDAOClass(output, clazz);
            	}
            }		
        }
    }
    
    private void generateFromDAOClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }

        String clazzName = clazz.getName();
	    String clazzFQN = clazz.getQualifiedName();

        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            String capitalizedAttrName = StringUtils.capitalize(attr.getName());
            if (!attr.isNavigable()
                    && !hasUnidirectionalRelationOnAbstractType(reverse, model)) {
                continue;
            }
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
/*{    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
/*{     * <%=attr.getName()%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%> La valeur de l'attribut <%=attr.getName()%> a positionner.
     *)
    public void set<%=capitalizedAttrName%>Of<%=clazzName%>(String topiaId, <%=attr.getType()%> <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>) throws TopiaException{
        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId); 
    	entity.set<%=StringUtils.capitalize(attr.getName())%>(<%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>);
    	usedContextImpl.commitTransaction();
    }

}*/
/*{    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
/*{     * <%=attr.getName()%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @return La valeur de l'attribut <%=attr.getName()%>.
     *)
    public <%=attr.getType()%> get<%=StringUtils.capitalize(attr.getName())%>Of<%=clazzName%>(String topiaId) throws TopiaException{
        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId); 
    	return entity.get<%=StringUtils.capitalize(attr.getName())%>();
    }

}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    if (log.isTraceEnabled()) { log.trace("assocAttrName: " + assocAttrName); }
/*{    /**
     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%> La valeur de l'attribut <%=attr.getAssociationClass().getName()%> � positionner.
     *)
    public void set<%=StringUtils.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=attr.getAssociationClass().getQualifiedName()%> <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>) throws TopiaException{
        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId); 
        entity.set<%=StringUtils.capitalize(assocAttrName)%>(<%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>);
    }

    /**
     * @return La valeur de l'attribut <%=attr.getAssociationClass().getName()%>.
     *)
    public <%=attr.getAssociationClass().getQualifiedName()%> get<%=StringUtils.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException{
        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId); 
    	return entity.get<%=StringUtils.capitalize(assocAttrName)%>();
    }

}*/
                }
            } else { //NMultiplicity
                if (!attr.hasAssociationClass()) { //M�thodes remplac�es par des add/set sur les classes d'assoc
/*{    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
/*{     * <%=attr.getName()%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%> L'instance de <%=attr.getName()%> � ajouter.
     *)
    public void add<%=StringUtils.capitalize(attr.getName())%>Of<%=clazzName%>(String topiaId, <%=attr.getType()%> <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>) throws TopiaException{
        TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId); 
    	entity.add<%=StringUtils.capitalize(attr.getName())%>(<%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>);
    }

    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
/*{     * <%=attr.getName()%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%> Les instances de <%=attr.getName()%> � ajouter.
     *)
    public void addAll<%=StringUtils.capitalize(attr.getName())%>Of<%=clazzName%>(String topiaId, <%=(attr.isOrdered()?"java.util.List":"java.util.Collection")%><<%=attr.getType()%>> <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	entity.addAll<%=StringUtils.capitalize(attr.getName())%>(<%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>);
    }

    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
/*{     * <%=attr.getName()%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%> La Collection de <%=attr.getName()%> � positionner.
     *)
    public void set<%=StringUtils.capitalize(attr.getName())%>Of<%=clazzName%>(String topiaId, <%=(attr.isOrdered()?"java.util.List":"java.util.Collection")%><<%=attr.getType()%>> <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	entity.set<%=StringUtils.capitalize(attr.getName())%>(<%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>);
    }

    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
/*{     * <%=attr.getName()%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%> L'instance de <%=attr.getName()%> � retirer.
     *)
    public void remove<%=StringUtils.capitalize(attr.getName())%>Of<%=clazzName%>(String topiaId, <%=attr.getType()%> <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	entity.remove<%=StringUtils.capitalize(attr.getName())%>(<%=GeneratorUtil.toLowerCaseFirstLetter(attr.getName())%>);
    }

    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
/*{     * <%=attr.getName()%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * Vide la Collection de <%=attr.getName()%>.
     *)
    public void clear<%=StringUtils.capitalize(attr.getName())%>Of<%=clazzName%>(String topiaId) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	entity.clear<%=StringUtils.capitalize(attr.getName())%>();
    }

}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    if (log.isTraceEnabled()) { log.trace("assocAttrName: " + assocAttrName); }
/*{    /**
     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%> L'instance de <%=attr.getAssociationClass().getName()%> � ajouter.
     *)
    public void add<%=StringUtils.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=attr.getAssociationClass().getQualifiedName()%> <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	entity.add<%=StringUtils.capitalize(assocAttrName)%>(<%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>);
    }

    /**
     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%> Les instances de <%=attr.getAssociationClass().getName()%> � ajouter.
     *)
    public void addAll<%=StringUtils.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=(attr.isOrdered()?"java.util.List":"java.util.Collection")%><<%=attr.getAssociationClass().getQualifiedName()%>> <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	entity.addAll<%=StringUtils.capitalize(assocAttrName)%>(<%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>);
    }

    /**
     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%> La Collection de <%=attr.getAssociationClass().getName()%> � positionner.
     *)
    public void set<%=StringUtils.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=(attr.isOrdered()?"java.util.List":"java.util.Collection")%><<%=attr.getAssociationClass().getQualifiedName()%>> <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	entity.set<%=StringUtils.capitalize(assocAttrName)%>(<%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>);
    }

    /**
     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%> L'instance de <%=attr.getAssociationClass().getName()%> � retirer.
     *)
    public void remove<%=StringUtils.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=attr.getAssociationClass().getQualifiedName()%> <%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	entity.remove<%=StringUtils.capitalize(assocAttrName)%>(<%=GeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName())%>);
    }

    /**
     * Vide la Collection de <%=attr.getAssociationClass().getName()%>.
     *)
    public void clear<%=StringUtils.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	entity.clear<%=StringUtils.capitalize(assocAttrName)%>();
    }

}*/
                }

                if (!attr.hasAssociationClass()) {
/*{    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
/*{     * <%=attr.getName()%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @return La Liste de <%=attr.getName()%>.
     *)
    public <%=(attr.isOrdered()?"java.util.List":"java.util.Collection")%><<%=attr.getType()%>> get<%=StringUtils.capitalize(attr.getName())%>Of<%=clazzName%>(String topiaId) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	return entity.get<%=StringUtils.capitalize(attr.getName())%>();
    }

    /**
     * @return Le nombre d'�l�ments de la collection <%=attr.getName()%>.
     *)
    public int size<%=StringUtils.capitalize(attr.getName())%>Of<%=clazzName%>(String topiaId) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	return entity.size<%=StringUtils.capitalize(attr.getName())%>();
    }

}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    if (log.isTraceEnabled()) { log.trace("assocAttrName: " + assocAttrName); }
/*{    /**
     * @return La liste des attributs <%=attr.getAssociationClass().getName()%>.
     *)
    public <%=(attr.isOrdered()?"java.util.List":"java.util.Collection")%><<%=attr.getAssociationClass().getQualifiedName()%>> get<%=StringUtils.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	return entity.get<%=StringUtils.capitalize(assocAttrName)%>();
    }

    /**
     * @return L'attribut <%=attr.getAssociationClass().getName()%> associ� � la valeur <code>value</code> de l'attribut <%=attr.getName()%>.
     *)
    public <%=attr.getAssociationClass().getQualifiedName()%> get<%=StringUtils.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=attr.getType()%> value) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	return entity.get<%=StringUtils.capitalize(assocAttrName)%>((<%=attr.getType()%>) value);
    }

    /**
     * @return Le nombre d'�l�ments de la collection <%=attr.getName()%>.
     *)
    public int size<%=StringUtils.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	return entity.size<%=StringUtils.capitalize(assocAttrName)%>();
    }

}*/
                }
            }
        }

        //M�thodes d'acc�s aux attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (Iterator i = assoc.getParticipantsAttributes().iterator(); i.hasNext(); ) {
               ObjectModelAttribute attr = (ObjectModelAttribute) i.next();
               if (attr != null) {
                   String type = attr.getType();
                   String name = attr.getName();
                   generateAssociationAccessors(output, clazz, name, type);
                   if (attr.getReverseAttribute() == null) {
                       type = ((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName();
                       name = attr.getDeclaringElement().getName();
                       generateAssociationAccessors(output, clazz, name, type);
                   }
               }
            }
        }

        generateInterfaceOperationsOfClass(output, clazz);

    }

    private void generateInterfaceOperationsOfClass(Writer output, ObjectModelClassifier classifier) throws IOException {
    	String classifierName = classifier.getName();
        for (ObjectModelOperation op : classifier.getOperations()) {
        	String opName = op.getName();
        	String opVisibility = op.getVisibility();
        	String opType = op.getReturnType();
/*{    /**
}*/
            if (TopiaGeneratorUtil.hasDocumentation(op)) {
/*{     * <%=opName%> : <%=op.getDocumentation()%>
}*/
            }
            Collection<ObjectModelParameter> params = (Collection<ObjectModelParameter>)op.getParameters();
            for(ObjectModelParameter param : params) {
            	String paramName = param.getName();
            	String paramDocumentation = param.getDocumentation();
/*{     * @param <%=paramName%> <%=paramDocumentation%>
 }*/ 
            }
/*{     *)
    <%=opVisibility%> <%=opType%> <%=opName%>Of<%=classifierName%>(String topiaId}*/
            String comma = ",";
            for(ObjectModelParameter param : params){
            	String paramName = param.getName();
            	String paramType = param.getType();
/*{<%=comma%><%=paramType%> <%=paramName%>}*/
            }
/*{)}*/
            Set<String> exceptions = (Set<String>)op.getExceptions();
            if(exceptions.isEmpty()){
/*{throws TopiaException}*/     	
            }
            comma = " throws ";
            for (String exception : exceptions) {
/*{<%=comma%><%=exception%>}*/
                comma = ", ";
            }
/*{{
		TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=classifierName%>DAOAbstract dao = (<%=classifierName%>DAOAbstract)usedContextImpl.getDAO(<%=classifierName%>.class);
		<%=classifierName%> entity = (<%=classifierName%>)dao.findByTopiaId(topiaId);
}*/            
            if(!op.getReturnType().toString().equalsIgnoreCase("void")){
/*{        return }*/            	
            }
/*{ entity.<%=opName%>(}*/
            comma = "";
            for(ObjectModelParameter param : params){
            	String paramName = param.getName();
/*{<%=comma%><%=paramName%>}*/
                comma = ", ";
            }
/*{);
    }
}*/

/*{

}*/
        }
    }

    private void generateAssociationAccessors(Writer output, ObjectModelClass clazz, String name, String type) throws IOException {
    	String clazzName = clazz.getName();
/*{    /**
     * @param value La valeur de l'attribut <%=name%> à positionner.
     *)
    public void set<%=StringUtils.capitalize(name)%>Of<%=clazzName%>(String topiaId, <%=type%> value) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	entity.set<%=StringUtils.capitalize(name)%>( value);
    }

    /**
     * @return La valeur de l'attribut <%=name%>.
     *)
    public <%=type%> get<%=StringUtils.capitalize(name)%>Of<%=clazzName%>(String topiaId) throws TopiaException{
    	TopiaContextImplementor usedContextImpl = (TopiaContextImplementor) topiaContext;
		<%=clazzName%>DAOAbstract dao = (<%=clazzName%>DAOAbstract)usedContextImpl.getDAO(<%=clazzName%>.class);
		<%=clazzName%> entity = (<%=clazzName%>)dao.findByTopiaId(topiaId);
    	return entity.get<%=StringUtils.capitalize(name)%>();
    }

}*/
    }

} //ServiceAbstractGenerator
