/* *##% ToPIA - SOA
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.topia.service.servers;

import java.lang.reflect.Method;

import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.server.http.XFireHttpServer;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.service.invoker.Invoker;
import org.nuiton.topia.service.TopiaApplicationService;
import org.nuiton.topia.service.TopiaServiceServerAbstract;

/**
 * SOAPServer.java
 * 
 * @author chatellier
 * @version $Revision: 1558 $
 * 
 * Last update : $Date: 2009-06-11 06:53:44 +0200 (jeu., 11 juin 2009) $ By : $Author: tchemit $
 */
public class SOAPServer extends TopiaServiceServerAbstract implements Invoker {

    /** Version UID */
    private static final long serialVersionUID = 3692192673769687321L;

    /** Logger (common logging) */
    //private static final Log logger = LogFactory.getLog(SOAPServer.class);
    /** Port du serveur web */
    protected static final int DEFAULT_PORT = 8888;

    /** Server already launched */
    protected boolean alreadyLaunched = false;

    /** Current used port */
    protected int port;

    /**
     * Constructeur.
     */
    public SOAPServer() {
        this(DEFAULT_PORT);
    }

    /**
     * Constructeur.
     */
    public SOAPServer(int port) {
        this.port = port;
    }

    /*
     * (non-Javadoc)
     * @see org.nuiton.topia.service.TopiaServiceServer#addService(java.lang.Class)
     */
    public void addService(Class<? extends TopiaApplicationService> clazz) {

        // Create an XFire Service
        ObjectServiceFactory serviceFactory = new ObjectServiceFactory();
        Service service = serviceFactory.create(clazz);
        //service.setInvoker(new BeanInvoker(new EchoImpl()));
        service.setInvoker(this);

        // Register the service in the ServiceRegistry
        XFire xfire = XFireFactory.newInstance().getXFire();
        xfire.getServiceRegistry().register(service);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.service.TopiaServiceServer#launch()
     */
    public void launch() {
        if (!alreadyLaunched) {
            // Start the HTTP server
            XFireHttpServer server = new XFireHttpServer();
            server.setPort(this.port);
            try {
                server.start();
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            alreadyLaunched = true;
        }
    }

    /* (non-Javadoc)
     * @see org.codehaus.xfire.service.invoker.Invoker#invoke(java.lang.reflect.Method, java.lang.Object[], org.codehaus.xfire.MessageContext)
     */
    public Object invoke(Method method, Object[] args, MessageContext ctx)
            throws XFireFault {
        return super.invoke(method, args);
    }
}
