package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class TaasAuthorizationAbstract extends TopiaEntityAbstract implements TaasAuthorization {

    /**
     * Nom de l'attribut en BD : expression
     */
    protected String expression;

    /**
     * Nom de l'attribut en BD : actions
     */
    protected int actions;

    private static final long serialVersionUID = 3904955563887912290L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, EXPRESSION, String.class, expression);
        visitor.visit(this, ACTIONS, int.class, actions);
        visitor.end(this);
    }

    @Override
    public void setExpression(String expression) {
        String oldValue = this.expression;
        fireOnPreWrite(EXPRESSION, oldValue, expression);
        this.expression = expression;
        fireOnPostWrite(EXPRESSION, oldValue, expression);
    }

    @Override
    public String getExpression() {
        fireOnPreRead(EXPRESSION, expression);
        String result = this.expression;
        fireOnPostRead(EXPRESSION, expression);
        return result;
    }

    @Override
    public void setActions(int actions) {
        int oldValue = this.actions;
        fireOnPreWrite(ACTIONS, oldValue, actions);
        this.actions = actions;
        fireOnPostWrite(ACTIONS, oldValue, actions);
    }

    @Override
    public int getActions() {
        fireOnPreRead(ACTIONS, actions);
        int result = this.actions;
        fireOnPostRead(ACTIONS, actions);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(EXPRESSION, this.expression).
            append(ACTIONS, this.actions).
         toString();
        return result;
    }

} //TaasAuthorizationAbstract
