package org.nuiton.topia.security.entities.user;

import java.util.Collection;
import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.security.listener.NoSecurityLoad;


public interface TopiaGroup extends NoSecurityLoad, TopiaEntity {     String NAME = "name";
     String DESCRIPTION = "description";
     String TOPIA_USER = "topiaUser";
     String SUPER_GROUP = "superGroup";
     String SUB_GROUP = "subGroup";
    /**
     * setName :
     * @param name La valeur de l'attribut à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setDescription :
     * @param description La valeur de l'attribut à positionner.
     */

     void setDescription(String description);

    /**
     * getDescription :
     * @return String 
     */

     String getDescription();

    /**
     * addTopiaUser :
     * @param topiaUser L'instance de org.nuiton.topia.security.entities.user.TopiaUser à ajouter
     */

     void addTopiaUser(TopiaUser topiaUser);

    /**
     * addAllTopiaUser :
     * @param topiaUser Les instances de org.nuiton.topia.security.entities.user.TopiaUser à ajouter
     */

     void addAllTopiaUser(Collection<TopiaUser> topiaUser);

    /**
     * setTopiaUser :
     * @param topiaUser La valeur de l'attribut à positionner.
     */

     void setTopiaUser(Collection<TopiaUser> topiaUser);

    /**
     * removeTopiaUser :
     * @param topiaUser L'instance de org.nuiton.topia.security.entities.user.TopiaUser à retirer
     */

     void removeTopiaUser(TopiaUser topiaUser);

    /**
     * clearTopiaUser :
     */

     void clearTopiaUser();

    /**
     * getTopiaUser :
     * Retourne la collection.
     * @return Collection<TopiaUser> 
     */

     Collection<TopiaUser> getTopiaUser();

    /**
     * getTopiaUserByTopiaId :
     * Recupère l'attribut topiaUser à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return TopiaUser 
     */

     TopiaUser getTopiaUserByTopiaId(String topiaId);

    /**
     * sizeTopiaUser :
     * Retourne le nombre d'éléments de la collection topiaUser
     * @return int 
     */

     int sizeTopiaUser();

    /**
     * isTopiaUserEmpty :
     * Retourne {@code true} si la collection topiaUser est vide.
     * @return boolean 
     */

     boolean isTopiaUserEmpty();

    /**
     * setSuperGroup :
     * @param superGroup La valeur de l'attribut à positionner.
     */

     void setSuperGroup(TopiaGroup superGroup);

    /**
     * getSuperGroup :
     * @return TopiaGroup 
     */

     TopiaGroup getSuperGroup();

    /**
     * addSubGroup :
     * @param subGroup L'instance de org.nuiton.topia.security.entities.user.TopiaGroup à ajouter
     */

     void addSubGroup(TopiaGroup subGroup);

    /**
     * addAllSubGroup :
     * @param subGroup Les instances de org.nuiton.topia.security.entities.user.TopiaGroup à ajouter
     */

     void addAllSubGroup(Collection<TopiaGroup> subGroup);

    /**
     * setSubGroup :
     * @param subGroup La valeur de l'attribut à positionner.
     */

     void setSubGroup(Collection<TopiaGroup> subGroup);

    /**
     * removeSubGroup :
     * @param subGroup L'instance de org.nuiton.topia.security.entities.user.TopiaGroup à retirer
     */

     void removeSubGroup(TopiaGroup subGroup);

    /**
     * clearSubGroup :
     */

     void clearSubGroup();

    /**
     * getSubGroup :
     * Retourne la collection.
     * @return Collection<TopiaGroup> 
     */

     Collection<TopiaGroup> getSubGroup();

    /**
     * getSubGroupByTopiaId :
     * Recupère l'attribut subGroup à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return TopiaGroup 
     */

     TopiaGroup getSubGroupByTopiaId(String topiaId);

    /**
     * sizeSubGroup :
     * Retourne le nombre d'éléments de la collection subGroup
     * @return int 
     */

     int sizeSubGroup();

    /**
     * isSubGroupEmpty :
     * Retourne {@code true} si la collection subGroup est vide.
     * @return boolean 
     */

     boolean isSubGroupEmpty();

    /**
     * getAllUser :
     * @return List 
     */

     List getAllUser();

    /**
     * getAllSuperGroup :
     * @return List 
     */

     List getAllSuperGroup();


} //TopiaGroup
