package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaTransaction.java 2949 2013-12-20 14:59:42Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-8/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaTransaction.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * This API provides methods to manipulate transaction
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 * @since 3.0
 */
public interface TopiaTransaction {

    /**
     * Applies all the modifications made to this context on the persistence
     * device. Once commit is done, a new transaction is started.
     */
    void commit();

    /**
     * Cancels all the modifications made to this context, coming back to the
     * state on the last beginTransaction. Once rollback is done, a new
     * transaction is started.
     */
    void rollback();

}
