/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaEntity.java 2955 2013-12-20 16:19:35Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-8/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaEntity.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin, Chemit Tony
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/* *
 * TopiaEntity.java
 *
 * Created: 28 déc. 2005 22:48:10
 *
 * @author poussin <poussin@codelutin.com>
 * @version $Revision: 2955 $
 *
 * Last update: $Date: 2013-12-20 17:19:35 +0100 (Fri, 20 Dec 2013) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.persistence;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * The TopiaEntity is the main interface for each entity generated.
 * An entity is simply a persistent bean mapped with Hibernate.
 * The manipulation on entities (create, update, delete, find) is
 * made by the DAO associated. The corresponding DAO interface is {@link
 * TopiaDAO}.
 * <p/>
 * Setter methods have to be used only in internal. They are in the interface to
 * make easier their usages in internal.
 *
 * @author poussin <poussin@codelutin.com>
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: TopiaEntity.java 2955 2013-12-20 16:19:35Z tchemit $
 */
public interface TopiaEntity extends Serializable {

    String PROPERTY_TOPIA_ID = "topiaId";

    /** @deprecated since 3.0, will be removed in 3.1, use {@link TopiaEntity#PROPERTY_TOPIA_ID} instead */
    @Deprecated
    String TOPIA_ID = PROPERTY_TOPIA_ID;

    String PROPERTY_TOPIA_CREATE_DATE = "topiaCreateDate";

    /** @deprecated since 3.0, will be removed in 3.1, use {@link TopiaEntity#PROPERTY_TOPIA_CREATE_DATE} instead */
    @Deprecated
    String TOPIA_CREATE_DATE = PROPERTY_TOPIA_CREATE_DATE;

    String PROPERTY_TOPIA_VERSION = "topiaVersion";

    /** @deprecated since 3.0, will be removed in 3.1, use {@link TopiaEntity#PROPERTY_TOPIA_VERSION} instead */
    @Deprecated
    String TOPIA_VERSION = PROPERTY_TOPIA_VERSION;

    /** @deprecated since 3.0, will be removed in 3.1, unused */
    @Deprecated
    String COMPOSITE = "composite";

    /** @deprecated since 3.0, will be removed in 3.1, unused */
    @Deprecated
    String AGGREGATE = "aggregate";

    /**
     * Unique technical Id of the entity. This id contains the full qualified
     * name of the entity interface. This id has also an index and is used to
     * identify uniquely the entity in the database.
     *
     * @return the technical Id of the entity
     */
    String getTopiaId();

    /**
     * Set the technical {@code id} of the entity. Careful, use this method only
     * for copy. The technical id is generated by ToPIA when entity is created
     * using {@link TopiaDAO#create(Object...)}.
     *
     * @param id technical id to set
     */
    void setTopiaId(String id);

    /**
     * Technical property to keep versionning of the entity. The version is
     * incremented on each change of the entity.
     *
     * @return the current version of the entity
     */
    long getTopiaVersion();

    /**
     * Set the technical {@code version} of the entity. Careful, use this method
     * only for copy. The version is automatically incremented on entity
     * changes.
     *
     * @param version technical version to set
     */
    void setTopiaVersion(long version);

    /**
     * Technical date creation of the entity. This date doesn't change through
     * time and was initialized on entity creation when using {@link
     * TopiaDAO#create(Object...)}.
     *
     * @return the creation date of the entity
     */
    Date getTopiaCreateDate();

    /**
     * Set the technical creation {@code date} of the entity. Careful, use this
     * method only for copy. This date is immutable and was created on entity
     * creation.
     *
     * @param date technical create date to set
     */
    void setTopiaCreateDate(Date date);

    /**
     * This method must be used to know if the current entity is present on the
     * persistent support. If the entity is not yet persisted or if the entity
     * has been removed, this method will return false.
     *
     * @return true if the entity is persisted and not yet deleted
     * @since 3.0
     */
    boolean isPersisted();

    /**
     * Notifies the current entity instance than it has been removed from the
     * persistent support.
     *
     * @since 3.0
     */
    void notifyDeleted();

    /**
     * @return all object that must be deleted if this object is deleted
     * @throws TopiaException if any pb
     * @deprecated from 3.0, method will be moved to entity's generated DAO (cf http://nuiton.org/issues/2776)
     */
    @Deprecated
    List<TopiaEntity> getComposite() throws TopiaException;

    /**
     * @return all object that are aggregate with this instance, aggreate object
     *         are not removed automaticaly
     * @throws TopiaException if any pb
     * @deprecated from 3.0, method will be moved to entity's generated DAO (cf http://nuiton.org/issues/2776)
     */
    @Deprecated
    List<TopiaEntity> getAggregate() throws TopiaException;

    /**
     * Route the entity using a {@code visitor}.
     *
     * @param visitor to used
     * @throws TopiaException for all type of error
     */
    void accept(EntityVisitor visitor) throws TopiaException;

    //------------------------------------------------------------------------//
    //-- PropertyListener (read) methods -------------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Add listener for property reading.
     *
     * @param listener the listener to register
     */
    // TODO AThimel 20/07/13 Javadoc
    void addPropertyListener(PropertyChangeListener listener);

    /**
     * Add listener for property reading.
     *
     * @param propertyName the property name to listen
     * @param listener     the listener to register
     */
    // TODO AThimel 20/07/13 Javadoc
    void addPropertyListener(String propertyName,
                             PropertyChangeListener listener);

    // TODO AThimel 20/07/13 Javadoc
    void removePropertyListener(PropertyChangeListener listener);

    // TODO AThimel 20/07/13 Javadoc
    void removePropertyListener(String propertyName,
                                PropertyChangeListener listener);

    //------------------------------------------------------------------------//
    //-- PropertyChangeListener (write) methods ------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Add listener for property writing.
     *
     * @param listener the listener to register
     */
    // TODO AThimel 20/07/13 Javadoc
    void addPropertyChangeListener(PropertyChangeListener listener);

    /**
     * Add listener for property writing.
     *
     * @param propertyName name of property to listen
     * @param listener     the listener to register
     */
    // TODO AThimel 20/07/13 Javadoc
    void addPropertyChangeListener(String propertyName,
                                   PropertyChangeListener listener);

    // TODO AThimel 20/07/13 Javadoc
    void removePropertyChangeListener(PropertyChangeListener listener);

    // TODO AThimel 20/07/13 Javadoc
    void removePropertyChangeListener(String propertyName,
                                      PropertyChangeListener listener);

    //------------------------------------------------------------------------//
    //-- VetoableListener (read) methods -------------------------------------//
    //------------------------------------------------------------------------//

    // TODO AThimel 20/07/13 Javadoc
    void addVetoableListener(VetoableChangeListener vetoable);

    // TODO AThimel 20/07/13 Javadoc
    void addVetoableListener(String propertyName,
                             VetoableChangeListener vetoable);

    // TODO AThimel 20/07/13 Javadoc
    void removeVetoableListener(VetoableChangeListener vetoable);

    // TODO AThimel 20/07/13 Javadoc
    void removeVetoableListener(String propertyName,
                                VetoableChangeListener vetoable);

    //------------------------------------------------------------------------//
    //-- VetoableChangeListener (write) methods ------------------------------//
    //------------------------------------------------------------------------//

    // TODO AThimel 20/07/13 Javadoc
    void addVetoableChangeListener(VetoableChangeListener vetoable);

    // TODO AThimel 20/07/13 Javadoc
    void addVetoableChangeListener(String propertyName,
                                   VetoableChangeListener vetoable);

    // TODO AThimel 20/07/13 Javadoc
    void removeVetoableChangeListener(VetoableChangeListener vetoable);

    // TODO AThimel 20/07/13 Javadoc
    void removeVetoableChangeListener(String propertyName,
                                      VetoableChangeListener vetoable);

} //TopiaEntity
