package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaApplicationContext.java 2954 2013-12-20 16:07:29Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-8/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaApplicationContext.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import org.nuiton.topia.persistence.support.TopiaListenableSupport;
import org.nuiton.topia.persistence.support.TopiaServiceSupport;

import java.util.List;

/**
 * Created on 12/20/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.0
 */
public interface TopiaApplicationContext<K extends TopiaPersistenceContext> extends TopiaListenableSupport, TopiaServiceSupport {

    K newPersistenceContext();

    String getModelVersion();

    String getModelName();

    <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass);

    <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass);

    Class<? extends TopiaEntity>[] getContractClasses();

    ImmutableMap<String, String> getConfiguration();

    List<Class<?>> getPersistenceClasses();

    boolean isSchemaEmpty();

    boolean isTableExists(Class<?> clazz);

    String getSchemaName();

    void createSchema();

    void showCreateSchema();

    void updateSchema();

    void dropSchema();

    void closeContext() throws TopiaException;

    boolean isClosed();
}
