/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.nuiton.topia.TopiaDaoSupplier;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaPersistenceContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.topia.persistence.TopiaHibernateSessionRegistry;

public class TopiaHibernateEventListener
implements PreInsertEventListener,
PostInsertEventListener,
PreLoadEventListener,
PostLoadEventListener,
PreUpdateEventListener,
PostUpdateEventListener,
PreDeleteEventListener,
PostDeleteEventListener,
SaveOrUpdateEventListener {
    private static final Log log = LogFactory.getLog(TopiaHibernateEventListener.class);
    private static final long serialVersionUID = -9206039888626756924L;
    protected TopiaHibernateSessionRegistry registry;

    public TopiaHibernateEventListener(TopiaHibernateSessionRegistry registry) {
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0);
        this.registry = registry;
    }

    protected TopiaPersistenceContext getContext(AbstractEvent event) {
        EventSource session = event.getSession();
        TopiaPersistenceContext result = this.registry.getPersistenceContext((Session)session);
        return result;
    }

    private void attachContext(Object entity, TopiaDaoSupplier daoSupplier) {
        block3: {
            TopiaEntityContextable topiaEntityContextable;
            if (entity instanceof TopiaEntityContextable && (topiaEntityContextable = (TopiaEntityContextable)entity).getTopiaDAOSupplier() == null) {
                try {
                    topiaEntityContextable.setTopiaDAOSupplier(daoSupplier);
                }
                catch (TopiaException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Impossible d'initialiser le TopiaContext sur cette entit\u00e9 : " + topiaEntityContextable), (Throwable)eee);
                }
            }
        }
    }

    public boolean onPreInsert(PreInsertEvent event) {
        TopiaPersistenceContext context = this.getContext((AbstractEvent)event);
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            TopiaEntity entity = (TopiaEntity)event.getEntity();
            context.getTopiaFiresSupport().fireOnPreCreate(context, entity, event.getState());
            if (StringUtils.isBlank((CharSequence)entity.getTopiaId()) && log.isDebugEnabled()) {
                log.debug((Object)("Adding topia id on entity " + entity.getClass().getSimpleName()));
            }
        }
        return false;
    }

    public void onPostInsert(PostInsertEvent event) {
        TopiaPersistenceContext context = this.getContext((AbstractEvent)event);
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            TopiaEntity entity = (TopiaEntity)event.getEntity();
            context.getTopiaFiresSupport().fireOnPostCreate(context, entity, event.getState());
        }
    }

    public void onPreLoad(PreLoadEvent event) {
        TopiaPersistenceContext context = this.getContext((AbstractEvent)event);
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            TopiaEntity entity = (TopiaEntity)event.getEntity();
            context.getTopiaFiresSupport().fireOnPreLoad(context, entity, event.getState());
        }
    }

    public void onPostLoad(PostLoadEvent event) {
        TopiaPersistenceContext context = this.getContext((AbstractEvent)event);
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            this.attachContext(event.getEntity(), context);
            TopiaEntity entity = (TopiaEntity)event.getEntity();
            context.getTopiaFiresSupport().fireOnPostLoad(context, entity, new Object[0]);
        }
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        TopiaPersistenceContext context = this.getContext((AbstractEvent)event);
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            TopiaEntity entity = (TopiaEntity)event.getEntity();
            context.getTopiaFiresSupport().fireOnPreUpdate(context, entity, event.getOldState());
        }
        return false;
    }

    public void onPostUpdate(PostUpdateEvent event) {
        TopiaPersistenceContext context = this.getContext((AbstractEvent)event);
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            TopiaEntity entity = (TopiaEntity)event.getEntity();
            context.getTopiaFiresSupport().fireOnPostUpdate(context, entity, event.getState());
        }
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        TopiaPersistenceContext context = this.getContext((AbstractEvent)event);
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            TopiaEntity entity = (TopiaEntity)event.getEntity();
            context.getTopiaFiresSupport().fireOnPreDelete(context, entity, event.getDeletedState());
        }
        return false;
    }

    public void onPostDelete(PostDeleteEvent event) {
        TopiaPersistenceContext context = this.getContext((AbstractEvent)event);
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            TopiaEntity entity = (TopiaEntity)event.getEntity();
            context.getTopiaFiresSupport().fireOnPostDelete(context, entity, event.getDeletedState());
        }
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        try {
            TopiaEntity entity;
            TopiaPersistenceContext context = this.getContext((AbstractEvent)event);
            if (event.getObject() instanceof TopiaEntity && StringUtils.isBlank((CharSequence)(entity = (TopiaEntity)event.getObject()).getTopiaId())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding topiaId into entity " + entity.getClass()));
                }
                Class<?> entityInterface = Class.forName(event.getEntityName().replace("Impl", ""));
                String topiaId = context.getTopiaIdFactory().newTopiaId(entityInterface, entity);
                entity.setTopiaId(topiaId);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new HibernateException("Can't set id", (Throwable)ex);
        }
    }
}

