/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.nuiton.topia.TopiaDaoSupplier;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.AbstractTopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public class TopiaHibernateEventListener
implements PreInsertEventListener,
PostInsertEventListener,
PreLoadEventListener,
PostLoadEventListener,
PreUpdateEventListener,
PostUpdateEventListener,
PreDeleteEventListener,
PostDeleteEventListener,
SaveOrUpdateEventListener {
    private static final Log log = LogFactory.getLog(TopiaHibernateEventListener.class);
    private static final long serialVersionUID = -9206039888626756924L;
    protected TopiaContextImplementor rootContext;

    public TopiaHibernateEventListener(TopiaContextImplementor rootContext) {
        this.rootContext = rootContext;
    }

    protected TopiaContextImplementor getContext(TopiaContextImplementor parent, Session hibernate) {
        TopiaContextImplementor result = null;
        if (parent != null) {
            for (TopiaContextImplementor context : parent.getChildContext()) {
                try {
                    result = context.getHibernate() == hibernate ? context : this.getContext(context, hibernate);
                    if (result == null) continue;
                    break;
                }
                catch (TopiaException eee) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"Error durant la recherche d'un context pour lancer un event", (Throwable)eee);
                }
            }
        }
        return result;
    }

    private void attachContext(Object entity, TopiaDaoSupplier daoSupplier) {
        block3: {
            TopiaEntityContextable topiaEntityContextable;
            if (entity instanceof TopiaEntityContextable && (topiaEntityContextable = (TopiaEntityContextable)entity).getTopiaDAOSupplier() == null) {
                try {
                    topiaEntityContextable.setTopiaDAOSupplier(daoSupplier);
                }
                catch (TopiaException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Impossible d'initialiser le TopiaContext sur cette entit\u00e9 : " + topiaEntityContextable), (Throwable)eee);
                }
            }
        }
    }

    public boolean onPreInsert(PreInsertEvent event) {
        TopiaContextImplementor context = this.getContext(this.rootContext, (Session)event.getSession());
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            TopiaEntity entity = (TopiaEntity)event.getEntity();
            context.getFiresSupport().fireOnPreCreate(context, entity, event.getState());
            if (StringUtils.isBlank((CharSequence)entity.getTopiaId()) && log.isDebugEnabled()) {
                log.debug((Object)("Adding topia id on entity " + entity.getClass().getSimpleName()));
            }
        }
        return false;
    }

    public void onPostInsert(PostInsertEvent event) {
        TopiaContextImplementor context = this.getContext(this.rootContext, (Session)event.getSession());
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            context.getFiresSupport().fireOnPostCreate(context, (TopiaEntity)event.getEntity(), event.getState());
        }
    }

    public void onPreLoad(PreLoadEvent event) {
        TopiaContextImplementor context = this.getContext(this.rootContext, (Session)event.getSession());
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            context.getFiresSupport().fireOnPreLoad(context, (TopiaEntity)event.getEntity(), event.getState());
        }
    }

    public void onPostLoad(PostLoadEvent event) {
        TopiaDaoSupplier daoSupplier = null;
        if (daoSupplier != null && event.getEntity() instanceof TopiaEntity) {
            this.attachContext(event.getEntity(), daoSupplier);
            TopiaEntity entity = (TopiaEntity)event.getEntity();
            AbstractTopiaDao dao = (AbstractTopiaDao)daoSupplier.getDao(entity.getClass());
            dao.getTopiaFiresSupport().fireOnPostLoad(dao, (TopiaEntity)event.getEntity(), new Object[0]);
        }
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        TopiaContextImplementor context = this.getContext(this.rootContext, (Session)event.getSession());
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            context.getFiresSupport().fireOnPreUpdate(context, (TopiaEntity)event.getEntity(), event.getOldState());
        }
        return false;
    }

    public void onPostUpdate(PostUpdateEvent event) {
        TopiaContextImplementor context = this.getContext(this.rootContext, (Session)event.getSession());
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            context.getFiresSupport().fireOnPostUpdate(context, (TopiaEntity)event.getEntity(), event.getState());
        }
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        TopiaContextImplementor context = this.getContext(this.rootContext, (Session)event.getSession());
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            context.getFiresSupport().fireOnPreDelete(context, (TopiaEntity)event.getEntity(), event.getDeletedState());
        }
        return false;
    }

    public void onPostDelete(PostDeleteEvent event) {
        TopiaContextImplementor context = this.getContext(this.rootContext, (Session)event.getSession());
        if (context != null && event.getEntity() instanceof TopiaEntity) {
            context.getFiresSupport().fireOnPostDelete(context, (TopiaEntity)event.getEntity(), event.getDeletedState());
        }
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        try {
            TopiaEntity entity;
            TopiaContextImplementor context = this.getContext(this.rootContext, (Session)event.getSession());
            if (event.getObject() instanceof TopiaEntity && StringUtils.isBlank((CharSequence)(entity = (TopiaEntity)event.getObject()).getTopiaId())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding topiaId into entity " + entity.getClass()));
                }
                Class<?> entityInterface = Class.forName(event.getEntityName().replace("Impl", ""));
                String topiaId = context.getTopiaIdFactory().newTopiaId(entityInterface, entity);
                entity.setTopiaId(topiaId);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new HibernateException("Can't set id", (Throwable)ex);
        }
    }
}

