/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.AbstractGenerator;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.validator.AttributeNamesValidator;
import org.nuiton.eugene.models.object.validator.ClassNamesValidator;
import org.nuiton.eugene.models.object.validator.ObjectModelValidator;
import org.nuiton.topia.generator.DAOAbstractGenerator;
import org.nuiton.topia.generator.DAOGenerator;
import org.nuiton.topia.generator.DAOHelperGenerator;
import org.nuiton.topia.generator.DAOImplGenerator;
import org.nuiton.topia.generator.EntityAbstractGenerator;
import org.nuiton.topia.generator.EntityHibernateMappingGenerator;
import org.nuiton.topia.generator.EntityImplGenerator;
import org.nuiton.topia.generator.EntityInterfaceGenerator;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.generator.TopiaJavaValidator;
import org.nuiton.topia.generator.TopiaRelationValidator;

public class TopiaMetaGenerator
extends ObjectModelGenerator {
    protected static Log log = LogFactory.getLog(TopiaMetaGenerator.class);
    protected static final List<Class<? extends ObjectModelGenerator>> DEFAULT_GENERATORS = Collections.unmodifiableList(Arrays.asList(EntityInterfaceGenerator.class, EntityAbstractGenerator.class, EntityImplGenerator.class, EntityHibernateMappingGenerator.class, DAOGenerator.class, DAOImplGenerator.class, DAOAbstractGenerator.class, DAOHelperGenerator.class));

    protected boolean validateModel(ObjectModel model) {
        ArrayList<Object> validators = new ArrayList<Object>();
        AttributeNamesValidator attrValidator = new AttributeNamesValidator(model);
        attrValidator.addNameAndReason("next", "Le nom d'attribut \"next\" est incompatible avec HSQL");
        attrValidator.addNameAndReason("value", "Le nom d'attribut \"value\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("values", "Le nom d'attribut \"values\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("begin", "Le nom d'attribut \"begin\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("end", "Le nom d'attribut \"end\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("authorization", "Le nom d'attribut \"authorization\" est incompatible avec certains SGBD");
        validators.add(attrValidator);
        ClassNamesValidator classValidator = new ClassNamesValidator(model);
        classValidator.addNameAndReason("constraint", "Nom de classe incompatible avec certains SGBD");
        classValidator.addNameAndReason("user", "Nom de classe incompatible avec certains SGBD");
        validators.add(classValidator);
        validators.add((Object)new TopiaJavaValidator(model));
        validators.add((Object)new TopiaRelationValidator(model));
        boolean isValid = true;
        for (ObjectModelValidator objectModelValidator : validators) {
            if (objectModelValidator.validate()) continue;
            for (String error : objectModelValidator.getErrors()) {
                log.info((Object)("[VALIDATION] " + error));
            }
            isValid = false;
        }
        return isValid;
    }

    public void applyTemplate(ObjectModel model, File destDir) throws IOException {
        this.validateModel(model);
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);
        if (classes.isEmpty()) {
            log.warn((Object)("no entity to generate, " + ((Object)((Object)this)).getClass().getName() + " is skipped"));
            return;
        }
        this.generatePersistence(model, destDir);
    }

    public void generatePersistence(ObjectModel model, File destDir) throws IOException {
        for (Class<? extends ObjectModelGenerator> generatorClass : DEFAULT_GENERATORS) {
            ObjectModelGenerator generator;
            if (this.getExcludeTemplates().contains(generatorClass.getName())) {
                log.info((Object)("exclude generator " + generatorClass));
                continue;
            }
            try {
                generator = generatorClass.newInstance();
                generator.setParent((AbstractGenerator)this);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"An error occurs when generating persistence", (Throwable)e);
                }
                throw new RuntimeException(e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("call template : " + generatorClass.getSimpleName()));
            }
            generator.applyTemplate(model, destDir);
        }
    }
}

