/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class EntityInterfaceGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(EntityInterfaceGenerator.class);

    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return interfacez.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
        if (!interfacez.hasStereotype("entity")) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating interface for : " + interfacez.getName()));
        }
        this.generateInterfaceHeaderFromClassifier(output, (ObjectModelClassifier)interfacez);
        this.generateInterfaceOperations(output, (ObjectModelClassifier)interfacez);
        output.write("} //" + interfacez.getName() + "\n");
        output.write("");
    }

    private String getStringRepresentation(List<String> strings) {
        StringBuffer result = new StringBuffer();
        String doubleQuote = "\"";
        String comma = ",";
        Iterator<String> it = strings.iterator();
        while (it.hasNext()) {
            result.append(doubleQuote);
            result.append(it.next());
            result.append(doubleQuote);
            if (!it.hasNext()) continue;
            result.append(comma);
        }
        return result.toString();
    }

    private void generateSearchFields(Writer output, ObjectModelClass clazz) throws IOException {
        ArrayList<String> txtFields = new ArrayList<String>();
        ArrayList<String> numFields = new ArrayList<String>();
        ArrayList<String> boolFields = new ArrayList<String>();
        ArrayList<String> dateFields = new ArrayList<String>();
        ArrayList allAttrs = new ArrayList();
        allAttrs.addAll(clazz.getAttributes());
        allAttrs.addAll(clazz.getAllOtherAttributes());
        boolean needAnnotation = false;
        for (ObjectModelAttribute attr : allAttrs) {
            String name = GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName());
            if (TopiaGeneratorUtil.isTextType(attr)) {
                txtFields.add(name);
                needAnnotation = true;
                continue;
            }
            if (TopiaGeneratorUtil.isNumericType(attr)) {
                numFields.add(name);
                needAnnotation = true;
                continue;
            }
            if (TopiaGeneratorUtil.isBooleanType(attr)) {
                boolFields.add(name);
                needAnnotation = true;
                continue;
            }
            if (!TopiaGeneratorUtil.isDateType(attr)) continue;
            dateFields.add(name);
            needAnnotation = true;
        }
        output.write("@SearchFields (");
        if (needAnnotation) {
            StringBuilder buffer = new StringBuilder();
            if (!txtFields.isEmpty()) {
                buffer.append("\n  txtFields={").append(this.getStringRepresentation(txtFields)).append("}");
                if (!(numFields.isEmpty() && boolFields.isEmpty() && dateFields.isEmpty())) {
                    buffer.append(",");
                }
            }
            if (!numFields.isEmpty()) {
                buffer.append("\n  numFields={").append(this.getStringRepresentation(numFields)).append("}");
                if (!boolFields.isEmpty() || !dateFields.isEmpty()) {
                    buffer.append(",");
                }
            }
            if (!boolFields.isEmpty()) {
                buffer.append("\n  boolFields={").append(this.getStringRepresentation(boolFields)).append("}");
                if (!dateFields.isEmpty()) {
                    buffer.append(",");
                }
            }
            if (!dateFields.isEmpty()) {
                buffer.append("\n  dateFields={").append(this.getStringRepresentation(dateFields)).append("}");
            }
            output.write("" + buffer.toString() + "\n");
            output.write("");
        }
        output.write(")        \n");
        output.write("");
    }

    private void generateInterfaceHeaderFromClassifier(Writer output, ObjectModelClassifier classifier) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright(this.model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        output.write("package " + classifier.getPackageName() + ";\n");
        output.write("\n");
        output.write("import org.nuiton.topia.persistence.SearchFields;\n");
        output.write("import org.nuiton.topia.persistence.TopiaEntity;\n");
        output.write("\n");
        output.write("");
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)classifier)) {
            String documentation = classifier.getDocumentation();
            output.write("\n");
            output.write("/**\n");
            output.write(" * " + documentation + "\n");
            output.write(" */\n");
            output.write("");
        }
        if (classifier instanceof ObjectModelClass) {
            this.generateSearchFields(output, (ObjectModelClass)classifier);
        }
        String classifierName = classifier.getName();
        output.write("public interface " + classifierName + " extends ");
        String extendClass = "";
        for (ObjectModelInterface parent : classifier.getInterfaces()) {
            extendClass = extendClass + parent.getQualifiedName();
            extendClass = extendClass + ", ";
        }
        if (classifier instanceof ObjectModelClass) {
            ObjectModelClass clazz = (ObjectModelClass)classifier;
            for (ObjectModelClass parent : clazz.getSuperclasses()) {
                if (parent.hasStereotype("entity")) {
                    extendClass = extendClass + parent.getQualifiedName();
                }
                extendClass = extendClass + ", ";
            }
        }
        output.write("" + extendClass + "TopiaEntity {\n");
        output.write("\n");
        output.write("");
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype("entity")) {
            return;
        }
        String clazzName = clazz.getName();
        this.generateInterfaceHeaderFromClassifier(output, (ObjectModelClassifier)clazz);
        this.generateStaticColumnNames(output, clazz);
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model)) continue;
            String attrName = attr.getName();
            String attrType = attr.getType();
            if (!attr.hasAssociationClass()) {
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    output.write("    /**\n");
                    output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                        output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                        output.write("");
                    }
                    output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " La valeur de l'attribut " + attrName + " \u00e0 positionner.\n");
                    output.write("     */\n");
                    output.write("    public void set" + GeneratorUtil.capitalize((String)attrName) + "(" + attrType + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ");\n");
                    output.write("\n");
                    output.write("");
                    output.write("    /**\n");
                    output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                        output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                        output.write("");
                    }
                    output.write("     * @return La valeur de l'attribut " + attrName + ".\n");
                    output.write("     */\n");
                    output.write("    public " + attrType + " get" + GeneratorUtil.capitalize((String)attrName) + "();\n");
                    output.write("\n");
                    output.write("");
                    continue;
                }
                String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " L'instance de " + attrName + " \u00e0 ajouter.\n");
                output.write("     */\n");
                output.write("    public void add" + GeneratorUtil.capitalize((String)attrName) + "(" + attrType + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ");\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " Les instances de " + attrName + " \u00e0 ajouter.\n");
                output.write("     */\n");
                output.write("    public void addAll" + GeneratorUtil.capitalize((String)attrName) + "(" + collectionInterface + "<" + attrType + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ");\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " La Collection de " + attrName + " \u00e0 positionner.\n");
                output.write("     */\n");
                output.write("    public void set" + GeneratorUtil.capitalize((String)attrName) + "(" + collectionInterface + "<" + attrType + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ");\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " L'instance de " + attrName + " \u00e0 retirer.\n");
                output.write("     */\n");
                output.write("    public void remove" + GeneratorUtil.capitalize((String)attrName) + "(" + attrType + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ");\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * Vide la Collection de " + attrName + ".\n");
                output.write("     */\n");
                output.write("    public void clear" + GeneratorUtil.capitalize((String)attrName) + "();\n");
                output.write("\n");
                output.write("");
                output.write("    /**\n");
                output.write("");
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    output.write("     * " + attrName + " : " + attr.getDocumentation() + "\n");
                    output.write("");
                }
                output.write("     * @return La Liste de " + attrName + ".\n");
                output.write("     */\n");
                output.write("    public " + collectionInterface + "<" + attrType + "> get" + GeneratorUtil.capitalize((String)attrName) + "();\n");
                output.write("\n");
                output.write("");
                if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {
                    output.write("\n");
                    output.write("    /**\n");
                    output.write("     * Recup\u00e8re l'attribut " + attrName + " \u00e0 partir de son topiaId.\n");
                    output.write("     *\n");
                    output.write("     * @param topiaId le topia id de l'entit\u00e9 recherch\u00e9e\n");
                    output.write("     *\n");
                    output.write("     * @return l'attribut recherch\u00e9, ou <code>null</code> s'il n'existe pas.\n");
                    output.write("     */\n");
                    output.write("    public " + attrType + " get" + GeneratorUtil.capitalize((String)attrName) + "ByTopiaId(String topiaId);\n");
                    output.write(" ");
                }
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @return Le nombre d'\u00e9l\u00e9ments de la collection " + attrName + ".\n");
                output.write("     */\n");
                output.write("    public int size" + GeneratorUtil.capitalize((String)attrName) + "();\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @return <code>true</code> si la collection " + attrName + " est vide.\n");
                output.write("     */\n");
                output.write("    public boolean is" + GeneratorUtil.capitalize((String)attrName) + "Empty();\n");
                output.write("\n");
                output.write("");
                continue;
            }
            String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
            String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            String assocClassName = attr.getAssociationClass().getName();
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                output.write("    /**\n");
                output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " La valeur de l'attribut " + assocClassName + " \u00e0 positionner.\n");
                output.write("     */\n");
                output.write("    public void set" + GeneratorUtil.capitalize((String)assocAttrName) + "(" + assocClassFQN + " " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ");\n");
                output.write("\n");
                output.write("    /**\n");
                output.write("     * @return La valeur de l'attribut " + assocClassName + ".\n");
                output.write("     */\n");
                output.write("    public " + assocClassFQN + " get" + GeneratorUtil.capitalize((String)assocAttrName) + "();\n");
                output.write("\n");
                output.write("");
                continue;
            }
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
            output.write("    /**\n");
            output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " L'instance de " + assocClassName + " \u00e0 ajouter.\n");
            output.write("     */\n");
            output.write("    public void add" + GeneratorUtil.capitalize((String)assocAttrName) + "(" + assocClassFQN + " " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ");\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " Les instances de " + assocClassName + " \u00e0 ajouter.\n");
            output.write("     */\n");
            output.write("    public void addAll" + GeneratorUtil.capitalize((String)assocAttrName) + "(" + collectionInterface + "<" + assocClassFQN + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ");\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " La Collection de " + assocClassName + " \u00e0 positionner.\n");
            output.write("     */\n");
            output.write("    public void set" + GeneratorUtil.capitalize((String)assocAttrName) + "(" + collectionInterface + "<" + assocClassFQN + "> " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ");\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * @param " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " L'instance de " + assocClassName + " \u00e0 retirer.\n");
            output.write("     */\n");
            output.write("    public void remove" + GeneratorUtil.capitalize((String)assocAttrName) + "(" + assocClassFQN + " " + GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + ");\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * Vide la Collection de " + assocClassName + ".\n");
            output.write("     */\n");
            output.write("    public void clear" + GeneratorUtil.capitalize((String)assocAttrName) + "();\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * @return La liste des attributs " + assocClassName + ".\n");
            output.write("     */\n");
            output.write("    public " + collectionInterface + "<" + assocClassFQN + "> get" + GeneratorUtil.capitalize((String)assocAttrName) + "();\n");
            output.write("");
            if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {
                output.write("\n");
                output.write("    /**\n");
                output.write("     * Recup\u00e8re l'attribut " + attrName + " \u00e0 partir de son topiaId.\n");
                output.write("     *\n");
                output.write("     * @param topiaId le topia id de l'attribut recherch\u00e9e\n");
                output.write("     * \n");
                output.write("     * @return l'attribut recherch\u00e9, ou <code>null</code> s'il n'existe pas.\n");
                output.write("     */\n");
                output.write("    public " + assocClassFQN + " get" + GeneratorUtil.capitalize((String)assocAttrName) + "ByTopiaId(String topiaId);\n");
                output.write("");
            }
            output.write("\n");
            output.write("    /**\n");
            output.write("     * @return L'attribut " + assocClassName + " associ\u00e9 \u00e0 la valeur <code>value</code> de l'attribut " + attrName + ".\n");
            output.write("     */\n");
            output.write("    public " + assocClassFQN + " get" + GeneratorUtil.capitalize((String)assocAttrName) + "(" + attrType + " value);\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * @return Le nombre d'\u00e9l\u00e9ments de la collection " + attrName + ".\n");
            output.write("     */\n");
            output.write("    public int size" + GeneratorUtil.capitalize((String)assocAttrName) + "();\n");
            output.write("  \n");
            output.write("    /**\n");
            output.write("     * @return <code>true</code> si la collection " + assocAttrName + " est vide.\n");
            output.write("     */\n");
            output.write("    public boolean is" + GeneratorUtil.capitalize((String)assocAttrName) + "Empty();\n");
            output.write("");
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String type = attr.getType();
                String name = attr.getName();
                this.generateAssociationAccessors(output, name, type);
                if (attr.getReverseAttribute() != null) continue;
                type = ((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName();
                name = attr.getDeclaringElement().getName();
                this.generateAssociationAccessors(output, name, type);
            }
        }
        this.generateInterfaceOperations(output, (ObjectModelClassifier)clazz);
        output.write("} //" + clazzName + "\n");
        output.write("");
    }

    private void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
            if (op.hasStereotype("dao")) continue;
            String opName = op.getName();
            output.write("    /**\n");
            output.write("");
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)op)) {
                String opDocumentation = op.getDocumentation();
                output.write("     * " + opName + " : " + opDocumentation + "\n");
                output.write("");
            }
            Collection params = op.getParameters();
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramDocumentation = param.getDocumentation();
                output.write("     * @param " + paramName + " " + paramDocumentation + "\n");
                output.write(" ");
            }
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            output.write("     */\n");
            output.write("    " + opVisibility + " " + opType + " " + opName + "(");
            String comma = "";
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramType = param.getType();
                output.write("" + comma + "" + paramType + " " + paramName + "");
                comma = ", ";
            }
            output.write(")");
            Set exceptions = op.getExceptions();
            comma = " throws ";
            for (String exception : exceptions) {
                output.write("" + comma + "" + exception + "");
                comma = ", ";
            }
            output.write(";\n");
            output.write("\n");
            output.write("");
        }
    }

    private void generateAssociationAccessors(Writer output, String attrName, String attrType) throws IOException {
        output.write("    /**\n");
        output.write("     * @param value La valeur de l'attribut " + attrName + " \u00e0 positionner.\n");
        output.write("     */\n");
        output.write("    public void set" + GeneratorUtil.capitalize((String)attrName) + "(" + attrType + " value);\n");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * @return La valeur de l'attribut " + attrName + ".\n");
        output.write("     */\n");
        output.write("    public " + attrType + " get" + GeneratorUtil.capitalize((String)attrName) + "();\n");
        output.write("\n");
        output.write("");
    }

    private void generateStaticColumnNames(Writer output, ObjectModelClass clazz) throws IOException {
        String attrColName;
        String attrName;
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr.hasAssociationClass()) continue;
            if (!attr.hasAssociationClass()) {
                attrName = attr.getName();
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                attrName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
            }
            attrColName = TopiaGeneratorUtil.convertVariableNameToConstantName(attrName);
            output.write("    public static final String " + attrColName + " = \"" + attrName + "\";\n");
            output.write("\n");
            output.write("");
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                attrName = attr.getName();
                attrColName = TopiaGeneratorUtil.convertVariableNameToConstantName(attrName);
                output.write("    public static final String " + attrColName + " = \"" + attrName + "\";\n");
                output.write("\n");
                output.write("");
            }
        }
    }
}

