package org.nuiton.topia.it.legacy.topiatest;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.it.legacy.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.AbstractTopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 12 10:36:34 CET 2013")
public abstract class GeneratedCompanyTopiaDao<E extends Company> extends AbstractTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Company.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Company;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            DepartmentTopiaDao dao = topiaDaoSupplier
                    .getDao(Department.class, DepartmentTopiaDao.class);
            List<Department> list = dao
                    .forProperties(Department.PROPERTY_COMPANY, entity)
                    .findAll();
            for (Department item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCompany())) {
                    item.setCompany(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Iterable<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Company.PROPERTY_NAME, (Iterable) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Company.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSiretIn(Iterable<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Company.PROPERTY_SIRET, (Iterable) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSiretEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Company.PROPERTY_SIRET, v);
        return result;
    }

    @Deprecated
    public E findBySiret(int v) {
        return forSiretEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySiret(int v) {
        return forSiretEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmployeContains(Employe v) {
        return forContains(Company.PROPERTY_EMPLOYE, v);
    }

    @Deprecated
    public E findContainsEmploye(Employe v) {
        return forEmployeContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsEmploye(Employe v) {
        return forEmployeContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDepartmentContains(Department v) {
        return forContains(Company.PROPERTY_DEPARTMENT, v);
    }

    @Deprecated
    public E findContainsDepartment(Department v) {
        return forDepartmentContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsDepartment(Department v) {
        return forDepartmentContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Department.class) {
            DepartmentTopiaDao dao =
                topiaDaoSupplier.getDao(Department.class, DepartmentTopiaDao.class);
            tmp = dao.forCompanyEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Department.class, entity);
        if (!list.isEmpty()) {
            result.put(Department.class, list);
        }

        return result;
    }

} //GeneratedCompanyTopiaDao<E extends Company>
