/**
 * *##% Nuiton utilities library
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.util.config;

/**
 * Enumaration of properties to be used in a {@link org.nuiton.util.config.IdentityConfig}
 *
 * @author chemit
 * @see IdentityConfig
 */
public enum IdentityConfigProperty implements Property{

    /** property <code>name</code>, first name of user */
    firstName(String.class),

    /** property <code>type</code>, lastname of user */
    lastName(String.class),

    /** property <code>email</code>, email of user */
    email(String.class);

    private Class<?> type;

    //TODO add locale + encoding

    public Class<?> getType() {
        return type;
    }

    IdentityConfigProperty(Class<?> type) {
        this.type = type;
    }
}
