/* 
 * *##% Nuiton utilities library
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */
package org.nuiton.util;

import org.apache.commons.beanutils.ConversionException;
import static org.apache.commons.logging.LogFactory.getLog;
import static org.nuiton.i18n.I18n._;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.beanutils.Converter;

/**
 * classe pour convertir une chaine en un objet URL.
 *
 * @author chemit
 */
public class URLConverter implements Converter {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static org.apache.commons.logging.Log log = getLog(URLConverter.class);

    @Override
    public Object convert(Class aClass, Object value) {
        if (value == null) {
            throw new ConversionException(_("nuitonutil.error.convertor.noValue", this));
        }
        if (isEnabled(aClass)) {
            Object result;
            if (isEnabled(value.getClass())) {
                result = value;
                return result;
            }
            if (value instanceof String) {
                result = valueOf((String) value);
                return result;
            }
        }
        throw new ConversionException(_("nuitonutil.error.no.convertor", aClass.getName(), value));
    }

    protected URL valueOf(String value) {
        try {
            URL result;
            result = new URL(value);
            return result;
        } catch (MalformedURLException e) {
            throw new ConversionException(_("nuitonutil.error.url.convertor", value, this, e.getMessage()));
        }
    }

    public URLConverter() {
        log.info(this);
    }

    protected boolean isEnabled(Class<?> aClass) {
        return aClass == URL.class;
    }

    public Class<?> getType() {
        return URL.class;
    }


}
