/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin.header.generator;

import java.io.IOException;
import org.nuiton.license.plugin.header.generator.HeaderGenerator;
import org.nuiton.plugin.PluginHelper;

public abstract class LicenseHeaderGenerator
implements HeaderGenerator {
    protected String linePrefix;
    protected String openTag;
    protected String closeTag;
    protected String openProcessTag;
    protected String closeProcessTag;

    public LicenseHeaderGenerator(String linePrefix, String openTag, String closeTag, String openProcessTag, String closeProcessTag) {
        this.linePrefix = linePrefix;
        this.openTag = openTag;
        this.closeTag = closeTag;
        this.openProcessTag = openProcessTag;
        this.closeProcessTag = closeProcessTag;
    }

    @Override
    public String getHeader(String licenseHeaderContent) {
        return this.openTag + "\n" + this.linePrefix + " " + this.openProcessTag + " " + licenseHeaderContent + " " + this.closeProcessTag + "\n" + this.closeTag + "\n";
    }

    @Override
    public String prefixContent(String content) throws IOException {
        String result = PluginHelper.prefixLines((String)(this.linePrefix + " "), (String)this.linePrefix, (String)content);
        return result;
    }

    @Override
    public String getLinePrefix() {
        return this.linePrefix;
    }

    @Override
    public String getCloseProcessTag() {
        return this.closeProcessTag;
    }

    @Override
    public String getCloseTag() {
        return this.closeTag;
    }

    @Override
    public String getOpenProcessTag() {
        return this.openProcessTag;
    }

    @Override
    public String getOpenTag() {
        return this.openTag;
    }

    @Override
    public void setCloseProcessTag(String closeProcessTag) {
        this.closeProcessTag = closeProcessTag;
    }

    @Override
    public void setCloseTag(String closeTag) {
        this.closeTag = closeTag;
    }

    @Override
    public void setLinePrefix(String linePrefix) {
        this.linePrefix = linePrefix;
    }

    @Override
    public void setOpenProcessTag(String openProcessTag) {
        this.openProcessTag = openProcessTag;
    }

    @Override
    public void setOpenTag(String openTag) {
        this.openTag = openTag;
    }
}

