/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.Arrays;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.Vector;
import org.nuiton.math.matrix.VectorIterator;
import org.nuiton.math.matrix.VectorIteratorImpl;

public class FloatBigVector
implements Vector {
    protected float[] data = null;

    public FloatBigVector() {
    }

    public FloatBigVector(int capacity) {
        this.init(capacity);
    }

    @Override
    public void init(long capacity) {
        if (capacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("FloatBigVector don't support this capacity : " + capacity);
        }
        if (this.data == null) {
            this.data = new float[(int)capacity];
        }
    }

    @Override
    public String getInfo() {
        return "Float vector dense: " + this.size();
    }

    @Override
    public long getNumberOfAssignedValue() {
        return this.size();
    }

    @Override
    public long size() {
        return this.data.length;
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        return MatrixHelper.maxOccurrence(this.data);
    }

    @Override
    public double getValue(long pos) {
        return this.data[(int)pos];
    }

    @Override
    public void setValue(long pos, double value) {
        this.data[(int)pos] = (float)value;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof FloatBigVector) {
            FloatBigVector other = (FloatBigVector)o;
            result = Arrays.equals(this.data, other.data);
        } else if (o instanceof Vector) {
            Vector other = (Vector)o;
            result = true;
            int i = 0;
            while ((long)i < this.size() && result) {
                result = this.getValue(i) == other.getValue(i);
                ++i;
            }
        }
        return result;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof FloatBigVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector v) {
        FloatBigVector fbv = (FloatBigVector)v;
        System.arraycopy(fbv.data, 0, this.data, 0, (int)this.size());
    }

    @Override
    public void map(MapFunction f) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (float)f.apply(this.data[i]);
        }
    }

    @Override
    public VectorIterator iterator() {
        return new VectorIteratorImpl(this);
    }

    @Override
    public VectorIterator iteratorNotZero() {
        return new VectorIteratorImpl(this, 0.0);
    }
}

