/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.Vector;
import org.nuiton.math.matrix.VectorIterator;

public class LazyVector
implements Vector {
    private static Log log = LogFactory.getLog(LazyVector.class);
    protected boolean isInitBackend = false;
    protected Vector backend;
    protected AtomicInteger users = new AtomicInteger();
    protected int capacity;

    public LazyVector(Vector backend) {
        this.isInitBackend = true;
        this.backend = backend;
        this.capacity = backend.size();
    }

    public LazyVector(Vector backend, int capacity) {
        this.backend = backend;
        this.capacity = capacity;
    }

    @Override
    public void init(int capacity) {
    }

    @Override
    public String getInfo() {
        return "Lazy vector: " + (this.isInitBackend ? this.backend.getInfo() : "no backend");
    }

    @Override
    public int getNumberOfAssignedValue() {
        return this.isInitBackend ? this.backend.getNumberOfAssignedValue() : 0;
    }

    @Override
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        double result = 0.0;
        if (this.isInitBackend) {
            result = this.backend.getMaxOccurrence();
        }
        return result;
    }

    @Override
    public double getValue(int pos) {
        double result = 0.0;
        if (this.isInitBackend) {
            result = this.backend.getValue(pos);
        }
        return result;
    }

    @Override
    public void setValue(int pos, double value) {
        this.prepareBackendForModification();
        this.backend.setValue(pos, value);
    }

    @Override
    public int size() {
        return this.capacity;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return true;
    }

    @Override
    public boolean isImplementedAdd(Vector v) {
        return this.backend.isImplementedAdd(v);
    }

    @Override
    public boolean isImplementedMinus(Vector v) {
        return this.backend.isImplementedMinus(v);
    }

    @Override
    public boolean isImplementedMap() {
        return this.backend.isImplementedMap();
    }

    @Override
    public void paste(Vector source) {
        if (!this.isInitBackend && source instanceof LazyVector && ((LazyVector)source).size() == this.size()) {
            LazyVector l = (LazyVector)source;
            l.users.incrementAndGet();
            this.users = l.users;
            this.isInitBackend = l.isInitBackend;
            this.backend = l.backend;
        } else {
            this.prepareBackendForModification();
            this.pasteToBackend(this.backend, source);
        }
    }

    @Override
    public void add(Vector v) {
        this.prepareBackendForModification();
        this.backend.add(v);
    }

    @Override
    public void minus(Vector v) {
        this.prepareBackendForModification();
        this.backend.minus(v);
    }

    @Override
    public void map(MapFunction f) {
        this.prepareBackendForModification();
        this.backend.map(f);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            if (this.size() == v.size()) {
                result = this.isInitBackend ? v.equals(this.backend) : (v instanceof LazyVector && !((LazyVector)v).isInitBackend ? true : v.equals(this));
            }
        }
        return result;
    }

    public int hashCode() {
        return this.size();
    }

    protected void prepareBackendForModification() {
        if (this.users.get() > 0) {
            try {
                Vector copy = (Vector)this.backend.getClass().newInstance();
                if (this.isInitBackend) {
                    copy.init(this.capacity);
                    this.pasteToBackend(copy, this.backend);
                }
                this.backend = copy;
                this.users.decrementAndGet();
                this.users = new AtomicInteger();
            }
            catch (Exception eee) {
                throw new MatrixException("Can't create new backend Vector", eee);
            }
        }
        if (!this.isInitBackend) {
            this.backend.init(this.capacity);
            this.isInitBackend = true;
        }
    }

    protected void pasteToBackend(Vector target, Vector copy) {
        if (target.isImplementedPaste(copy)) {
            target.paste(copy);
        } else {
            int max = Math.min(this.size(), copy.size());
            for (int i = 0; i < max; ++i) {
                double v = copy.getValue(i);
                target.setValue(i, v);
            }
        }
    }

    @Override
    public VectorIterator iterator() {
        VectorIterator result = this.isInitBackend ? new LazyVectorIterator(this, this.backend.iterator()) : new DummyVectorIterator(this, this.capacity, 0.0);
        return result;
    }

    @Override
    public VectorIterator iteratorNotZero() {
        VectorIterator result = this.isInitBackend ? new LazyVectorIterator(this, this.backend.iteratorNotZero()) : new DummyVectorIterator(this, 0, 0.0);
        return result;
    }

    protected class LazyVectorIterator
    implements VectorIterator {
        protected LazyVector vector;
        protected VectorIterator iter;
        protected double value;

        public LazyVectorIterator(LazyVector vector, VectorIterator iter) {
            this.vector = vector;
            this.iter = iter;
        }

        @Override
        public void setExclude(double exclude) {
            this.iter.setExclude(exclude);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public double next() {
            this.value = this.iter.next();
            return this.value;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public void setValue(double value) {
            int pos = this.getPosition();
            this.vector.setValue(pos, value);
            this.value = value;
        }

        @Override
        public int getPosition() {
            return this.iter.getPosition();
        }
    }

    protected class DummyVectorIterator
    implements VectorIterator {
        protected LazyVector vector;
        protected int size;
        protected double defaultValue;
        protected double value;
        protected int pos = -1;

        public DummyVectorIterator(LazyVector vector, int size, double defaultValue) {
            this.vector = vector;
            this.defaultValue = defaultValue;
            this.size = size;
        }

        @Override
        public void setExclude(double exclude) {
            if (exclude != 0.0) {
                throw new UnsupportedOperationException("In DummyVectorIterator you can exclude only 0");
            }
            this.size = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < this.size;
        }

        @Override
        public double next() {
            ++this.pos;
            this.value = this.defaultValue;
            return this.value;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public void setValue(double value) {
            this.vector.setValue(this.pos, value);
            this.value = value;
        }

        @Override
        public int getPosition() {
            return this.pos;
        }
    }
}

